/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.api;

import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;
import org.eclipse.milo.opcua.sdk.server.DiagnosticsContext;
import org.eclipse.milo.opcua.sdk.server.OpcUaServer;
import org.eclipse.milo.opcua.sdk.server.Session;

public class OperationContext<T, U> {
    private final CompletableFuture<List<U>> future;
    private final OpcUaServer server;
    private final Session session;
    private final DiagnosticsContext<T> diagnostics;

    public OperationContext(OpcUaServer server, @Nullable Session session, DiagnosticsContext<T> diagnostics) {
        this(server, session, new CompletableFuture<List<U>>(), diagnostics);
    }

    public OperationContext(OpcUaServer server, @Nullable Session session, CompletableFuture<List<U>> future, DiagnosticsContext<T> diagnosticsContext) {
        this.server = server;
        this.session = session;
        this.future = future;
        this.diagnostics = diagnosticsContext;
    }

    public void complete(List<U> value) {
        this.future.complete(value);
    }

    public DiagnosticsContext<T> getDiagnostics() {
        return this.diagnostics;
    }

    public OpcUaServer getServer() {
        return this.server;
    }

    public Optional<Session> getSession() {
        return Optional.ofNullable(this.session);
    }
}

