/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.api;

import java.util.Optional;
import java.util.concurrent.ConcurrentMap;
import org.eclipse.milo.opcua.sdk.core.Reference;
import org.eclipse.milo.opcua.sdk.server.nodes.ServerNode;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;

public interface ServerNodeMap
extends ConcurrentMap<NodeId, ServerNode> {
    default public void addNode(ServerNode node) {
        this.put(node.getNodeId(), node);
    }

    default public boolean addReference(Reference reference) {
        return this.getNode(reference.getSourceNodeId()).map(node -> {
            node.addReference(reference);
            return true;
        }).orElse(false);
    }

    default public boolean containsNode(ServerNode node) {
        return this.containsNodeId(node.getNodeId());
    }

    default public boolean containsNodeId(NodeId nodeId) {
        return this.containsKey(nodeId);
    }

    default public Optional<ServerNode> getNode(NodeId nodeId) {
        return Optional.ofNullable(this.get(nodeId));
    }

    default public Optional<ServerNode> getNode(ExpandedNodeId nodeId) {
        return nodeId.local().flatMap(this::getNode);
    }

    default public Optional<ServerNode> removeNode(NodeId nodeId) {
        return Optional.ofNullable(this.remove(nodeId));
    }
}

