/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.model.nodes.objects;

import java.util.Optional;
import org.eclipse.milo.opcua.sdk.core.annotations.UaObjectNode;
import org.eclipse.milo.opcua.sdk.server.api.ServerNodeMap;
import org.eclipse.milo.opcua.sdk.server.api.nodes.VariableNode;
import org.eclipse.milo.opcua.sdk.server.model.nodes.objects.BaseObjectNode;
import org.eclipse.milo.opcua.sdk.server.model.nodes.variables.PropertyNode;
import org.eclipse.milo.opcua.sdk.server.model.types.objects.AggregateConfigurationType;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UByte;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;

@UaObjectNode(typeName="0:AggregateConfigurationType")
public class AggregateConfigurationNode
extends BaseObjectNode
implements AggregateConfigurationType {
    public AggregateConfigurationNode(ServerNodeMap nodeMap, NodeId nodeId, QualifiedName browseName, LocalizedText displayName, LocalizedText description, UInteger writeMask, UInteger userWriteMask, UByte eventNotifier) {
        super(nodeMap, nodeId, browseName, displayName, description, writeMask, userWriteMask, eventNotifier);
    }

    @Override
    public Boolean getTreatUncertainAsBad() {
        Optional<Boolean> property = this.getProperty(AggregateConfigurationType.TREAT_UNCERTAIN_AS_BAD);
        return property.orElse(null);
    }

    @Override
    public PropertyNode getTreatUncertainAsBadNode() {
        Optional<VariableNode> propertyNode = this.getPropertyNode(AggregateConfigurationType.TREAT_UNCERTAIN_AS_BAD.getBrowseName());
        return propertyNode.map(n -> (PropertyNode)n).orElse(null);
    }

    @Override
    public void setTreatUncertainAsBad(Boolean value) {
        this.setProperty(AggregateConfigurationType.TREAT_UNCERTAIN_AS_BAD, value);
    }

    @Override
    public UByte getPercentDataBad() {
        Optional<UByte> property = this.getProperty(AggregateConfigurationType.PERCENT_DATA_BAD);
        return property.orElse(null);
    }

    @Override
    public PropertyNode getPercentDataBadNode() {
        Optional<VariableNode> propertyNode = this.getPropertyNode(AggregateConfigurationType.PERCENT_DATA_BAD.getBrowseName());
        return propertyNode.map(n -> (PropertyNode)n).orElse(null);
    }

    @Override
    public void setPercentDataBad(UByte value) {
        this.setProperty(AggregateConfigurationType.PERCENT_DATA_BAD, value);
    }

    @Override
    public UByte getPercentDataGood() {
        Optional<UByte> property = this.getProperty(AggregateConfigurationType.PERCENT_DATA_GOOD);
        return property.orElse(null);
    }

    @Override
    public PropertyNode getPercentDataGoodNode() {
        Optional<VariableNode> propertyNode = this.getPropertyNode(AggregateConfigurationType.PERCENT_DATA_GOOD.getBrowseName());
        return propertyNode.map(n -> (PropertyNode)n).orElse(null);
    }

    @Override
    public void setPercentDataGood(UByte value) {
        this.setProperty(AggregateConfigurationType.PERCENT_DATA_GOOD, value);
    }

    @Override
    public Boolean getUseSlopedExtrapolation() {
        Optional<Boolean> property = this.getProperty(AggregateConfigurationType.USE_SLOPED_EXTRAPOLATION);
        return property.orElse(null);
    }

    @Override
    public PropertyNode getUseSlopedExtrapolationNode() {
        Optional<VariableNode> propertyNode = this.getPropertyNode(AggregateConfigurationType.USE_SLOPED_EXTRAPOLATION.getBrowseName());
        return propertyNode.map(n -> (PropertyNode)n).orElse(null);
    }

    @Override
    public void setUseSlopedExtrapolation(Boolean value) {
        this.setProperty(AggregateConfigurationType.USE_SLOPED_EXTRAPOLATION, value);
    }
}

