/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.model.nodes.objects;

import java.util.Optional;
import org.eclipse.milo.opcua.sdk.core.annotations.UaObjectNode;
import org.eclipse.milo.opcua.sdk.server.api.ServerNodeMap;
import org.eclipse.milo.opcua.sdk.server.api.nodes.VariableNode;
import org.eclipse.milo.opcua.sdk.server.model.nodes.objects.BaseEventNode;
import org.eclipse.milo.opcua.sdk.server.model.nodes.variables.PropertyNode;
import org.eclipse.milo.opcua.sdk.server.model.types.objects.AuditEventType;
import org.eclipse.milo.opcua.stack.core.types.builtin.DateTime;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UByte;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;

@UaObjectNode(typeName="0:AuditEventType")
public class AuditEventNode
extends BaseEventNode
implements AuditEventType {
    public AuditEventNode(ServerNodeMap nodeMap, NodeId nodeId, QualifiedName browseName, LocalizedText displayName, LocalizedText description, UInteger writeMask, UInteger userWriteMask, UByte eventNotifier) {
        super(nodeMap, nodeId, browseName, displayName, description, writeMask, userWriteMask, eventNotifier);
    }

    @Override
    public DateTime getActionTimeStamp() {
        Optional<DateTime> property = this.getProperty(AuditEventType.ACTION_TIME_STAMP);
        return property.orElse(null);
    }

    @Override
    public PropertyNode getActionTimeStampNode() {
        Optional<VariableNode> propertyNode = this.getPropertyNode(AuditEventType.ACTION_TIME_STAMP.getBrowseName());
        return propertyNode.map(n -> (PropertyNode)n).orElse(null);
    }

    @Override
    public void setActionTimeStamp(DateTime value) {
        this.setProperty(AuditEventType.ACTION_TIME_STAMP, value);
    }

    @Override
    public Boolean getStatus() {
        Optional<Boolean> property = this.getProperty(AuditEventType.STATUS);
        return property.orElse(null);
    }

    @Override
    public PropertyNode getStatusNode() {
        Optional<VariableNode> propertyNode = this.getPropertyNode(AuditEventType.STATUS.getBrowseName());
        return propertyNode.map(n -> (PropertyNode)n).orElse(null);
    }

    @Override
    public void setStatus(Boolean value) {
        this.setProperty(AuditEventType.STATUS, value);
    }

    @Override
    public String getServerId() {
        Optional<String> property = this.getProperty(AuditEventType.SERVER_ID);
        return property.orElse(null);
    }

    @Override
    public PropertyNode getServerIdNode() {
        Optional<VariableNode> propertyNode = this.getPropertyNode(AuditEventType.SERVER_ID.getBrowseName());
        return propertyNode.map(n -> (PropertyNode)n).orElse(null);
    }

    @Override
    public void setServerId(String value) {
        this.setProperty(AuditEventType.SERVER_ID, value);
    }

    @Override
    public String getClientAuditEntryId() {
        Optional<String> property = this.getProperty(AuditEventType.CLIENT_AUDIT_ENTRY_ID);
        return property.orElse(null);
    }

    @Override
    public PropertyNode getClientAuditEntryIdNode() {
        Optional<VariableNode> propertyNode = this.getPropertyNode(AuditEventType.CLIENT_AUDIT_ENTRY_ID.getBrowseName());
        return propertyNode.map(n -> (PropertyNode)n).orElse(null);
    }

    @Override
    public void setClientAuditEntryId(String value) {
        this.setProperty(AuditEventType.CLIENT_AUDIT_ENTRY_ID, value);
    }

    @Override
    public String getClientUserId() {
        Optional<String> property = this.getProperty(AuditEventType.CLIENT_USER_ID);
        return property.orElse(null);
    }

    @Override
    public PropertyNode getClientUserIdNode() {
        Optional<VariableNode> propertyNode = this.getPropertyNode(AuditEventType.CLIENT_USER_ID.getBrowseName());
        return propertyNode.map(n -> (PropertyNode)n).orElse(null);
    }

    @Override
    public void setClientUserId(String value) {
        this.setProperty(AuditEventType.CLIENT_USER_ID, value);
    }
}

