/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.model.nodes.objects;

import java.util.Optional;
import org.eclipse.milo.opcua.sdk.core.annotations.UaObjectNode;
import org.eclipse.milo.opcua.sdk.server.api.ServerNodeMap;
import org.eclipse.milo.opcua.sdk.server.api.nodes.VariableNode;
import org.eclipse.milo.opcua.sdk.server.model.nodes.objects.SystemOffNormalAlarmNode;
import org.eclipse.milo.opcua.sdk.server.model.nodes.variables.PropertyNode;
import org.eclipse.milo.opcua.sdk.server.model.types.objects.CertificateExpirationAlarmType;
import org.eclipse.milo.opcua.stack.core.types.builtin.ByteString;
import org.eclipse.milo.opcua.stack.core.types.builtin.DateTime;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UByte;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;

@UaObjectNode(typeName="0:CertificateExpirationAlarmType")
public class CertificateExpirationAlarmNode
extends SystemOffNormalAlarmNode
implements CertificateExpirationAlarmType {
    public CertificateExpirationAlarmNode(ServerNodeMap nodeMap, NodeId nodeId, QualifiedName browseName, LocalizedText displayName, LocalizedText description, UInteger writeMask, UInteger userWriteMask, UByte eventNotifier) {
        super(nodeMap, nodeId, browseName, displayName, description, writeMask, userWriteMask, eventNotifier);
    }

    @Override
    public DateTime getExpirationDate() {
        Optional<DateTime> property = this.getProperty(CertificateExpirationAlarmType.EXPIRATION_DATE);
        return property.orElse(null);
    }

    @Override
    public PropertyNode getExpirationDateNode() {
        Optional<VariableNode> propertyNode = this.getPropertyNode(CertificateExpirationAlarmType.EXPIRATION_DATE.getBrowseName());
        return propertyNode.map(n -> (PropertyNode)n).orElse(null);
    }

    @Override
    public void setExpirationDate(DateTime value) {
        this.setProperty(CertificateExpirationAlarmType.EXPIRATION_DATE, value);
    }

    @Override
    public NodeId getCertificateType() {
        Optional<NodeId> property = this.getProperty(CertificateExpirationAlarmType.CERTIFICATE_TYPE);
        return property.orElse(null);
    }

    @Override
    public PropertyNode getCertificateTypeNode() {
        Optional<VariableNode> propertyNode = this.getPropertyNode(CertificateExpirationAlarmType.CERTIFICATE_TYPE.getBrowseName());
        return propertyNode.map(n -> (PropertyNode)n).orElse(null);
    }

    @Override
    public void setCertificateType(NodeId value) {
        this.setProperty(CertificateExpirationAlarmType.CERTIFICATE_TYPE, value);
    }

    @Override
    public ByteString getCertificate() {
        Optional<ByteString> property = this.getProperty(CertificateExpirationAlarmType.CERTIFICATE);
        return property.orElse(null);
    }

    @Override
    public PropertyNode getCertificateNode() {
        Optional<VariableNode> propertyNode = this.getPropertyNode(CertificateExpirationAlarmType.CERTIFICATE.getBrowseName());
        return propertyNode.map(n -> (PropertyNode)n).orElse(null);
    }

    @Override
    public void setCertificate(ByteString value) {
        this.setProperty(CertificateExpirationAlarmType.CERTIFICATE, value);
    }
}

