/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.model.nodes.variables;

import java.util.Optional;
import org.eclipse.milo.opcua.sdk.core.annotations.UaVariableNode;
import org.eclipse.milo.opcua.sdk.server.api.ServerNodeMap;
import org.eclipse.milo.opcua.sdk.server.api.nodes.VariableNode;
import org.eclipse.milo.opcua.sdk.server.api.nodes.VariableTypeNode;
import org.eclipse.milo.opcua.sdk.server.model.nodes.variables.BaseDataVariableNode;
import org.eclipse.milo.opcua.sdk.server.model.types.variables.BuildInfoType;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.DateTime;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UByte;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.structured.BuildInfo;

@UaVariableNode(typeName="0:BuildInfoType")
public class BuildInfoNode
extends BaseDataVariableNode
implements BuildInfoType {
    public BuildInfoNode(ServerNodeMap nodeMap, NodeId nodeId, VariableTypeNode variableTypeNode) {
        super(nodeMap, nodeId, variableTypeNode);
    }

    public BuildInfoNode(ServerNodeMap nodeMap, NodeId nodeId, QualifiedName browseName, LocalizedText displayName, LocalizedText description, UInteger writeMask, UInteger userWriteMask, DataValue value, NodeId dataType, Integer valueRank, UInteger[] arrayDimensions, UByte accessLevel, UByte userAccessLevel, Double minimumSamplingInterval, boolean historizing) {
        super(nodeMap, nodeId, browseName, displayName, description, writeMask, userWriteMask, value, dataType, valueRank, arrayDimensions, accessLevel, userAccessLevel, minimumSamplingInterval, historizing);
    }

    @Override
    public synchronized DataValue getValue() {
        BuildInfo value = new BuildInfo(this.getProductUri(), this.getManufacturerName(), this.getProductName(), this.getSoftwareVersion(), this.getBuildNumber(), this.getBuildDate());
        return new DataValue(new Variant((Object)value));
    }

    @Override
    public synchronized void setValue(DataValue value) {
        super.setValue(value);
        Object o = value.getValue().getValue();
        if (o instanceof BuildInfo) {
            BuildInfo v = (BuildInfo)o;
            this.setProductUri(v.getProductUri());
            this.setManufacturerName(v.getManufacturerName());
            this.setProductName(v.getProductName());
            this.setSoftwareVersion(v.getSoftwareVersion());
            this.setBuildNumber(v.getBuildNumber());
            this.setBuildDate(v.getBuildDate());
        }
    }

    @Override
    public String getProductUri() {
        Optional<VariableNode> component = this.getVariableComponent("ProductUri");
        return component.map(node -> (String)node.getValue().getValue().getValue()).orElse(null);
    }

    @Override
    public BaseDataVariableNode getProductUriNode() {
        Optional<VariableNode> component = this.getVariableComponent("ProductUri");
        return component.map(node -> (BaseDataVariableNode)node).orElse(null);
    }

    @Override
    public void setProductUri(String value) {
        this.getVariableComponent("ProductUri").ifPresent(n -> n.setValue(new DataValue(new Variant((Object)value))));
    }

    @Override
    public String getManufacturerName() {
        Optional<VariableNode> component = this.getVariableComponent("ManufacturerName");
        return component.map(node -> (String)node.getValue().getValue().getValue()).orElse(null);
    }

    @Override
    public BaseDataVariableNode getManufacturerNameNode() {
        Optional<VariableNode> component = this.getVariableComponent("ManufacturerName");
        return component.map(node -> (BaseDataVariableNode)node).orElse(null);
    }

    @Override
    public void setManufacturerName(String value) {
        this.getVariableComponent("ManufacturerName").ifPresent(n -> n.setValue(new DataValue(new Variant((Object)value))));
    }

    @Override
    public String getProductName() {
        Optional<VariableNode> component = this.getVariableComponent("ProductName");
        return component.map(node -> (String)node.getValue().getValue().getValue()).orElse(null);
    }

    @Override
    public BaseDataVariableNode getProductNameNode() {
        Optional<VariableNode> component = this.getVariableComponent("ProductName");
        return component.map(node -> (BaseDataVariableNode)node).orElse(null);
    }

    @Override
    public void setProductName(String value) {
        this.getVariableComponent("ProductName").ifPresent(n -> n.setValue(new DataValue(new Variant((Object)value))));
    }

    @Override
    public String getSoftwareVersion() {
        Optional<VariableNode> component = this.getVariableComponent("SoftwareVersion");
        return component.map(node -> (String)node.getValue().getValue().getValue()).orElse(null);
    }

    @Override
    public BaseDataVariableNode getSoftwareVersionNode() {
        Optional<VariableNode> component = this.getVariableComponent("SoftwareVersion");
        return component.map(node -> (BaseDataVariableNode)node).orElse(null);
    }

    @Override
    public void setSoftwareVersion(String value) {
        this.getVariableComponent("SoftwareVersion").ifPresent(n -> n.setValue(new DataValue(new Variant((Object)value))));
    }

    @Override
    public String getBuildNumber() {
        Optional<VariableNode> component = this.getVariableComponent("BuildNumber");
        return component.map(node -> (String)node.getValue().getValue().getValue()).orElse(null);
    }

    @Override
    public BaseDataVariableNode getBuildNumberNode() {
        Optional<VariableNode> component = this.getVariableComponent("BuildNumber");
        return component.map(node -> (BaseDataVariableNode)node).orElse(null);
    }

    @Override
    public void setBuildNumber(String value) {
        this.getVariableComponent("BuildNumber").ifPresent(n -> n.setValue(new DataValue(new Variant((Object)value))));
    }

    @Override
    public DateTime getBuildDate() {
        Optional<VariableNode> component = this.getVariableComponent("BuildDate");
        return component.map(node -> (DateTime)node.getValue().getValue().getValue()).orElse(null);
    }

    @Override
    public BaseDataVariableNode getBuildDateNode() {
        Optional<VariableNode> component = this.getVariableComponent("BuildDate");
        return component.map(node -> (BaseDataVariableNode)node).orElse(null);
    }

    @Override
    public void setBuildDate(DateTime value) {
        this.getVariableComponent("BuildDate").ifPresent(n -> n.setValue(new DataValue(new Variant((Object)value))));
    }
}

