/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.model.nodes.variables;

import java.util.Optional;
import org.eclipse.milo.opcua.sdk.core.annotations.UaVariableNode;
import org.eclipse.milo.opcua.sdk.server.api.ServerNodeMap;
import org.eclipse.milo.opcua.sdk.server.api.nodes.VariableNode;
import org.eclipse.milo.opcua.sdk.server.api.nodes.VariableTypeNode;
import org.eclipse.milo.opcua.sdk.server.model.nodes.variables.BaseDataVariableNode;
import org.eclipse.milo.opcua.sdk.server.model.types.variables.ServerDiagnosticsSummaryType;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UByte;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.structured.ServerDiagnosticsSummaryDataType;

@UaVariableNode(typeName="0:ServerDiagnosticsSummaryType")
public class ServerDiagnosticsSummaryNode
extends BaseDataVariableNode
implements ServerDiagnosticsSummaryType {
    public ServerDiagnosticsSummaryNode(ServerNodeMap nodeMap, NodeId nodeId, VariableTypeNode variableTypeNode) {
        super(nodeMap, nodeId, variableTypeNode);
    }

    public ServerDiagnosticsSummaryNode(ServerNodeMap nodeMap, NodeId nodeId, QualifiedName browseName, LocalizedText displayName, LocalizedText description, UInteger writeMask, UInteger userWriteMask, DataValue value, NodeId dataType, Integer valueRank, UInteger[] arrayDimensions, UByte accessLevel, UByte userAccessLevel, Double minimumSamplingInterval, boolean historizing) {
        super(nodeMap, nodeId, browseName, displayName, description, writeMask, userWriteMask, value, dataType, valueRank, arrayDimensions, accessLevel, userAccessLevel, minimumSamplingInterval, historizing);
    }

    @Override
    public synchronized DataValue getValue() {
        ServerDiagnosticsSummaryDataType value = new ServerDiagnosticsSummaryDataType(this.getServerViewCount(), this.getCurrentSessionCount(), this.getCumulatedSessionCount(), this.getSecurityRejectedSessionCount(), this.getRejectedSessionCount(), this.getSessionTimeoutCount(), this.getSessionAbortCount(), this.getPublishingIntervalCount(), this.getCurrentSubscriptionCount(), this.getCumulatedSubscriptionCount(), this.getSecurityRejectedRequestsCount(), this.getRejectedRequestsCount());
        return new DataValue(new Variant((Object)value));
    }

    @Override
    public synchronized void setValue(DataValue value) {
        super.setValue(value);
        Object o = value.getValue().getValue();
        if (o instanceof ServerDiagnosticsSummaryDataType) {
            ServerDiagnosticsSummaryDataType v = (ServerDiagnosticsSummaryDataType)o;
            this.setServerViewCount(v.getServerViewCount());
            this.setCurrentSessionCount(v.getCurrentSessionCount());
            this.setCumulatedSessionCount(v.getCumulatedSessionCount());
            this.setSecurityRejectedSessionCount(v.getSecurityRejectedSessionCount());
            this.setRejectedSessionCount(v.getRejectedSessionCount());
            this.setSessionTimeoutCount(v.getSessionTimeoutCount());
            this.setSessionAbortCount(v.getSessionAbortCount());
            this.setPublishingIntervalCount(v.getPublishingIntervalCount());
            this.setCurrentSubscriptionCount(v.getCurrentSubscriptionCount());
            this.setCumulatedSubscriptionCount(v.getCumulatedSubscriptionCount());
            this.setSecurityRejectedRequestsCount(v.getSecurityRejectedRequestsCount());
            this.setRejectedRequestsCount(v.getRejectedRequestsCount());
        }
    }

    @Override
    public UInteger getServerViewCount() {
        Optional<VariableNode> component = this.getVariableComponent("ServerViewCount");
        return component.map(node -> (UInteger)node.getValue().getValue().getValue()).orElse(null);
    }

    @Override
    public BaseDataVariableNode getServerViewCountNode() {
        Optional<VariableNode> component = this.getVariableComponent("ServerViewCount");
        return component.map(node -> (BaseDataVariableNode)node).orElse(null);
    }

    @Override
    public void setServerViewCount(UInteger value) {
        this.getVariableComponent("ServerViewCount").ifPresent(n -> n.setValue(new DataValue(new Variant((Object)value))));
    }

    @Override
    public UInteger getCurrentSessionCount() {
        Optional<VariableNode> component = this.getVariableComponent("CurrentSessionCount");
        return component.map(node -> (UInteger)node.getValue().getValue().getValue()).orElse(null);
    }

    @Override
    public BaseDataVariableNode getCurrentSessionCountNode() {
        Optional<VariableNode> component = this.getVariableComponent("CurrentSessionCount");
        return component.map(node -> (BaseDataVariableNode)node).orElse(null);
    }

    @Override
    public void setCurrentSessionCount(UInteger value) {
        this.getVariableComponent("CurrentSessionCount").ifPresent(n -> n.setValue(new DataValue(new Variant((Object)value))));
    }

    @Override
    public UInteger getCumulatedSessionCount() {
        Optional<VariableNode> component = this.getVariableComponent("CumulatedSessionCount");
        return component.map(node -> (UInteger)node.getValue().getValue().getValue()).orElse(null);
    }

    @Override
    public BaseDataVariableNode getCumulatedSessionCountNode() {
        Optional<VariableNode> component = this.getVariableComponent("CumulatedSessionCount");
        return component.map(node -> (BaseDataVariableNode)node).orElse(null);
    }

    @Override
    public void setCumulatedSessionCount(UInteger value) {
        this.getVariableComponent("CumulatedSessionCount").ifPresent(n -> n.setValue(new DataValue(new Variant((Object)value))));
    }

    @Override
    public UInteger getSecurityRejectedSessionCount() {
        Optional<VariableNode> component = this.getVariableComponent("SecurityRejectedSessionCount");
        return component.map(node -> (UInteger)node.getValue().getValue().getValue()).orElse(null);
    }

    @Override
    public BaseDataVariableNode getSecurityRejectedSessionCountNode() {
        Optional<VariableNode> component = this.getVariableComponent("SecurityRejectedSessionCount");
        return component.map(node -> (BaseDataVariableNode)node).orElse(null);
    }

    @Override
    public void setSecurityRejectedSessionCount(UInteger value) {
        this.getVariableComponent("SecurityRejectedSessionCount").ifPresent(n -> n.setValue(new DataValue(new Variant((Object)value))));
    }

    @Override
    public UInteger getRejectedSessionCount() {
        Optional<VariableNode> component = this.getVariableComponent("RejectedSessionCount");
        return component.map(node -> (UInteger)node.getValue().getValue().getValue()).orElse(null);
    }

    @Override
    public BaseDataVariableNode getRejectedSessionCountNode() {
        Optional<VariableNode> component = this.getVariableComponent("RejectedSessionCount");
        return component.map(node -> (BaseDataVariableNode)node).orElse(null);
    }

    @Override
    public void setRejectedSessionCount(UInteger value) {
        this.getVariableComponent("RejectedSessionCount").ifPresent(n -> n.setValue(new DataValue(new Variant((Object)value))));
    }

    @Override
    public UInteger getSessionTimeoutCount() {
        Optional<VariableNode> component = this.getVariableComponent("SessionTimeoutCount");
        return component.map(node -> (UInteger)node.getValue().getValue().getValue()).orElse(null);
    }

    @Override
    public BaseDataVariableNode getSessionTimeoutCountNode() {
        Optional<VariableNode> component = this.getVariableComponent("SessionTimeoutCount");
        return component.map(node -> (BaseDataVariableNode)node).orElse(null);
    }

    @Override
    public void setSessionTimeoutCount(UInteger value) {
        this.getVariableComponent("SessionTimeoutCount").ifPresent(n -> n.setValue(new DataValue(new Variant((Object)value))));
    }

    @Override
    public UInteger getSessionAbortCount() {
        Optional<VariableNode> component = this.getVariableComponent("SessionAbortCount");
        return component.map(node -> (UInteger)node.getValue().getValue().getValue()).orElse(null);
    }

    @Override
    public BaseDataVariableNode getSessionAbortCountNode() {
        Optional<VariableNode> component = this.getVariableComponent("SessionAbortCount");
        return component.map(node -> (BaseDataVariableNode)node).orElse(null);
    }

    @Override
    public void setSessionAbortCount(UInteger value) {
        this.getVariableComponent("SessionAbortCount").ifPresent(n -> n.setValue(new DataValue(new Variant((Object)value))));
    }

    @Override
    public UInteger getPublishingIntervalCount() {
        Optional<VariableNode> component = this.getVariableComponent("PublishingIntervalCount");
        return component.map(node -> (UInteger)node.getValue().getValue().getValue()).orElse(null);
    }

    @Override
    public BaseDataVariableNode getPublishingIntervalCountNode() {
        Optional<VariableNode> component = this.getVariableComponent("PublishingIntervalCount");
        return component.map(node -> (BaseDataVariableNode)node).orElse(null);
    }

    @Override
    public void setPublishingIntervalCount(UInteger value) {
        this.getVariableComponent("PublishingIntervalCount").ifPresent(n -> n.setValue(new DataValue(new Variant((Object)value))));
    }

    @Override
    public UInteger getCurrentSubscriptionCount() {
        Optional<VariableNode> component = this.getVariableComponent("CurrentSubscriptionCount");
        return component.map(node -> (UInteger)node.getValue().getValue().getValue()).orElse(null);
    }

    @Override
    public BaseDataVariableNode getCurrentSubscriptionCountNode() {
        Optional<VariableNode> component = this.getVariableComponent("CurrentSubscriptionCount");
        return component.map(node -> (BaseDataVariableNode)node).orElse(null);
    }

    @Override
    public void setCurrentSubscriptionCount(UInteger value) {
        this.getVariableComponent("CurrentSubscriptionCount").ifPresent(n -> n.setValue(new DataValue(new Variant((Object)value))));
    }

    @Override
    public UInteger getCumulatedSubscriptionCount() {
        Optional<VariableNode> component = this.getVariableComponent("CumulatedSubscriptionCount");
        return component.map(node -> (UInteger)node.getValue().getValue().getValue()).orElse(null);
    }

    @Override
    public BaseDataVariableNode getCumulatedSubscriptionCountNode() {
        Optional<VariableNode> component = this.getVariableComponent("CumulatedSubscriptionCount");
        return component.map(node -> (BaseDataVariableNode)node).orElse(null);
    }

    @Override
    public void setCumulatedSubscriptionCount(UInteger value) {
        this.getVariableComponent("CumulatedSubscriptionCount").ifPresent(n -> n.setValue(new DataValue(new Variant((Object)value))));
    }

    @Override
    public UInteger getSecurityRejectedRequestsCount() {
        Optional<VariableNode> component = this.getVariableComponent("SecurityRejectedRequestsCount");
        return component.map(node -> (UInteger)node.getValue().getValue().getValue()).orElse(null);
    }

    @Override
    public BaseDataVariableNode getSecurityRejectedRequestsCountNode() {
        Optional<VariableNode> component = this.getVariableComponent("SecurityRejectedRequestsCount");
        return component.map(node -> (BaseDataVariableNode)node).orElse(null);
    }

    @Override
    public void setSecurityRejectedRequestsCount(UInteger value) {
        this.getVariableComponent("SecurityRejectedRequestsCount").ifPresent(n -> n.setValue(new DataValue(new Variant((Object)value))));
    }

    @Override
    public UInteger getRejectedRequestsCount() {
        Optional<VariableNode> component = this.getVariableComponent("RejectedRequestsCount");
        return component.map(node -> (UInteger)node.getValue().getValue().getValue()).orElse(null);
    }

    @Override
    public BaseDataVariableNode getRejectedRequestsCountNode() {
        Optional<VariableNode> component = this.getVariableComponent("RejectedRequestsCount");
        return component.map(node -> (BaseDataVariableNode)node).orElse(null);
    }

    @Override
    public void setRejectedRequestsCount(UInteger value) {
        this.getVariableComponent("RejectedRequestsCount").ifPresent(n -> n.setValue(new DataValue(new Variant((Object)value))));
    }
}

