/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.nodes;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.milo.opcua.sdk.core.Reference;
import org.eclipse.milo.opcua.sdk.core.util.StreamUtil;
import org.eclipse.milo.opcua.sdk.server.api.ServerNodeMap;
import org.eclipse.milo.opcua.sdk.server.api.nodes.VariableNode;
import org.eclipse.milo.opcua.sdk.server.api.nodes.VariableTypeNode;
import org.eclipse.milo.opcua.sdk.server.nodes.UaVariableNode;
import org.eclipse.milo.opcua.sdk.server.nodes.UaVariableTypeNode;
import org.eclipse.milo.opcua.stack.core.Identifiers;
import org.eclipse.milo.opcua.stack.core.UaRuntimeException;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.enumerated.NodeClass;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;

public class VariableNodeFactory {
    private static final Reflections NODE_REFLECTIONS = new Reflections("org.eclipse.milo.opcua.sdk.server.model", new Scanner[0]);
    private final ServerNodeMap nodeMap;

    public VariableNodeFactory(ServerNodeMap nodeMap) {
        this.nodeMap = nodeMap;
    }

    public UaVariableNode create(NodeId nodeId, QualifiedName browseName, LocalizedText displayName, NodeId typeDefinitionId) {
        UaVariableNode variableNode = this.create(nodeId, typeDefinitionId);
        variableNode.setBrowseName(browseName);
        variableNode.setDisplayName(displayName);
        return variableNode;
    }

    public <T extends VariableNode> T create(NodeId nodeId, QualifiedName browseName, LocalizedText displayName, NodeId typeDefinitionId, Class<T> clazz) {
        T variableNode = this.create(nodeId, typeDefinitionId, clazz);
        variableNode.setBrowseName(browseName);
        variableNode.setDisplayName(displayName);
        return variableNode;
    }

    public UaVariableNode create(NodeId nodeId, NodeId typeDefinitionId) throws UaRuntimeException {
        return this.create(nodeId, typeDefinitionId, UaVariableNode.class);
    }

    public <T extends VariableNode> T create(NodeId nodeId, NodeId typeDefinitionId, Class<T> clazz) throws UaRuntimeException {
        UaVariableTypeNode typeDefinitionNode = (UaVariableTypeNode)this.nodeMap.getNode(typeDefinitionId).orElseThrow(() -> new UaRuntimeException(2150891520L, "unknown type definition: " + typeDefinitionId));
        UaVariableNode node = this.instanceFromTypeDefinition(nodeId, typeDefinitionNode);
        this.nodeMap.addNode(node);
        List propertyDeclarations = typeDefinitionNode.getReferences().stream().filter(Reference.HAS_PROPERTY_PREDICATE).distinct().map(r -> this.nodeMap.getNode(r.getTargetNodeId())).flatMap(StreamUtil::opt2stream).map(UaVariableNode.class::cast).filter(vn -> vn.getReferences().stream().anyMatch(r -> Identifiers.HasModellingRule.equals((Object)r.getReferenceTypeId()) && Identifiers.ModellingRule_Mandatory.expanded().equals((Object)r.getTargetNodeId()))).collect(Collectors.toList());
        for (UaVariableNode declaration : propertyDeclarations) {
            UaVariableTypeNode typeDefinition = (UaVariableTypeNode)declaration.getTypeDefinitionNode();
            NodeId instanceId = this.createNodeId(nodeId, declaration.getBrowseName().getName());
            UaVariableNode instance = this.create(instanceId, typeDefinition.getNodeId());
            instance.setBrowseName(declaration.getBrowseName());
            instance.setDisplayName(declaration.getDisplayName());
            instance.setDescription(declaration.getDescription());
            instance.setWriteMask(declaration.getWriteMask());
            instance.setUserWriteMask(declaration.getUserWriteMask());
            instance.setValue(declaration.getValue());
            instance.setDataType(declaration.getDataType());
            instance.setValueRank(declaration.getValueRank());
            instance.setArrayDimensions(declaration.getArrayDimensions());
            node.addProperty(instance);
            this.nodeMap.addNode(instance);
        }
        List variableDeclarations = typeDefinitionNode.getReferences().stream().filter(Reference.HAS_COMPONENT_PREDICATE).map(r -> this.nodeMap.getNode(r.getTargetNodeId())).flatMap(StreamUtil::opt2stream).map(UaVariableNode.class::cast).collect(Collectors.toList());
        for (UaVariableNode declaration : variableDeclarations) {
            UaVariableTypeNode typeDefinition = (UaVariableTypeNode)declaration.getTypeDefinitionNode();
            NodeId instanceId = this.createNodeId(nodeId, declaration.getBrowseName().getName());
            UaVariableNode instance = this.create(instanceId, typeDefinition.getNodeId());
            instance.setBrowseName(declaration.getBrowseName());
            instance.setDisplayName(declaration.getDisplayName());
            instance.setDescription(declaration.getDescription());
            instance.setWriteMask(declaration.getWriteMask());
            instance.setUserWriteMask(declaration.getUserWriteMask());
            instance.setValue(declaration.getValue());
            instance.setDataType(declaration.getDataType());
            instance.setValueRank(declaration.getValueRank());
            instance.setArrayDimensions(declaration.getArrayDimensions());
            node.addComponent(instance);
            this.nodeMap.addNode(instance);
        }
        return (T)((VariableNode)clazz.cast(node));
    }

    private UaVariableNode instanceFromTypeDefinition(NodeId nodeId, UaVariableTypeNode typeDefinitionNode) {
        QualifiedName browseName = typeDefinitionNode.getBrowseName();
        Set classes = NODE_REFLECTIONS.getTypesAnnotatedWith((Annotation)this.variableAnnotation(browseName.toParseableString()));
        Class clazz = (Class)classes.stream().findFirst().orElseThrow(() -> new UaRuntimeException(2153971712L, "unknown variable type: " + browseName));
        try {
            Class[] uaVariableNodeCtorParams = new Class[]{ServerNodeMap.class, NodeId.class, VariableTypeNode.class};
            Constructor ctor = clazz.getDeclaredConstructor(uaVariableNodeCtorParams);
            Object[] initArgs = new Object[]{this.nodeMap, nodeId, typeDefinitionNode};
            UaVariableNode variableNode = (UaVariableNode)ctor.newInstance(initArgs);
            variableNode.addReference(new Reference(nodeId, Identifiers.HasTypeDefinition, new ExpandedNodeId(typeDefinitionNode.getNodeId()), NodeClass.VariableType, true));
            return variableNode;
        }
        catch (Exception e) {
            throw new UaRuntimeException((Throwable)e);
        }
    }

    private NodeId createNodeId(NodeId nodeId, String toAppend) {
        return new NodeId(nodeId.getNamespaceIndex(), nodeId.getIdentifier() + "." + toAppend);
    }

    private org.eclipse.milo.opcua.sdk.core.annotations.UaVariableNode variableAnnotation(final String typeName) {
        return new org.eclipse.milo.opcua.sdk.core.annotations.UaVariableNode(){

            public String typeName() {
                return typeName;
            }

            public Class<? extends Annotation> annotationType() {
                return org.eclipse.milo.opcua.sdk.core.annotations.UaVariableNode.class;
            }
        };
    }
}

