/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server;

import com.google.common.collect.Lists;
import java.time.Duration;
import java.util.List;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.eclipse.milo.opcua.sdk.server.OpcUaServer;
import org.eclipse.milo.opcua.sdk.server.services.AttributeHistoryServices;
import org.eclipse.milo.opcua.sdk.server.services.AttributeServices;
import org.eclipse.milo.opcua.sdk.server.services.MethodServices;
import org.eclipse.milo.opcua.sdk.server.services.MonitoredItemServices;
import org.eclipse.milo.opcua.sdk.server.services.NodeManagementServices;
import org.eclipse.milo.opcua.sdk.server.services.QueryServices;
import org.eclipse.milo.opcua.sdk.server.services.SubscriptionServices;
import org.eclipse.milo.opcua.sdk.server.services.ViewServices;
import org.eclipse.milo.opcua.sdk.server.subscriptions.SubscriptionManager;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.application.services.NodeManagementServiceSet;
import org.eclipse.milo.opcua.stack.core.application.services.ServiceRequest;
import org.eclipse.milo.opcua.stack.core.application.services.SessionServiceSet;
import org.eclipse.milo.opcua.stack.core.serialization.UaResponseMessage;
import org.eclipse.milo.opcua.stack.core.types.builtin.ByteString;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.Unsigned;
import org.eclipse.milo.opcua.stack.core.types.structured.ActivateSessionRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.ActivateSessionResponse;
import org.eclipse.milo.opcua.stack.core.types.structured.CancelRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.CancelResponse;
import org.eclipse.milo.opcua.stack.core.types.structured.CloseSessionRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.CloseSessionResponse;
import org.eclipse.milo.opcua.stack.core.types.structured.CreateSessionRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.CreateSessionResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Session
implements SessionServiceSet {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final List<LifecycleListener> listeners = Lists.newCopyOnWriteArrayList();
    private final SubscriptionManager subscriptionManager;
    private volatile long secureChannelId;
    private volatile Object identityObject;
    private volatile ByteString clientCertificateBytes;
    private volatile ByteString lastNonce = ByteString.NULL_VALUE;
    private volatile long lastActivity = System.nanoTime();
    private volatile ScheduledFuture<?> checkTimeoutFuture;
    private final AttributeServices attributeServices;
    private final AttributeHistoryServices attributeHistoryServices;
    private final MethodServices methodServices;
    private final MonitoredItemServices monitoredItemServices;
    private final NodeManagementServiceSet nodeManagementServices;
    private final QueryServices queryServices;
    private final SubscriptionServices subscriptionServices;
    private final ViewServices viewServices;
    private final OpcUaServer server;
    private final NodeId sessionId;
    private final String sessionName;
    private final Duration sessionTimeout;

    public Session(OpcUaServer server, NodeId sessionId, String sessionName, Duration sessionTimeout, long secureChannelId) {
        this.server = server;
        this.sessionId = sessionId;
        this.sessionName = sessionName;
        this.sessionTimeout = sessionTimeout;
        this.secureChannelId = secureChannelId;
        this.subscriptionManager = new SubscriptionManager(this, server);
        this.attributeServices = new AttributeServices();
        this.attributeHistoryServices = new AttributeHistoryServices();
        this.methodServices = new MethodServices();
        this.monitoredItemServices = new MonitoredItemServices(this.subscriptionManager);
        this.nodeManagementServices = new NodeManagementServices();
        this.queryServices = new QueryServices();
        this.subscriptionServices = new SubscriptionServices(this.subscriptionManager);
        this.viewServices = new ViewServices();
        this.checkTimeoutFuture = server.getScheduledExecutorService().schedule(this::checkTimeout, sessionTimeout.toNanos(), TimeUnit.NANOSECONDS);
    }

    public long getSecureChannelId() {
        return this.secureChannelId;
    }

    @Nullable
    public Object getIdentityObject() {
        return this.identityObject;
    }

    @Nullable
    public ByteString getClientCertificateBytes() {
        return this.clientCertificateBytes;
    }

    public void setSecureChannelId(long secureChannelId) {
        this.secureChannelId = secureChannelId;
    }

    public void setIdentityObject(Object identityObject) {
        this.identityObject = identityObject;
    }

    public void setClientCertificateBytes(ByteString clientCertificateBytes) {
        this.clientCertificateBytes = clientCertificateBytes;
    }

    void addLifecycleListener(LifecycleListener listener) {
        this.listeners.add(listener);
    }

    void updateLastActivity() {
        this.lastActivity = System.nanoTime();
    }

    void setLastNonce(ByteString lastNonce) {
        this.lastNonce = lastNonce;
    }

    public ByteString getLastNonce() {
        return this.lastNonce;
    }

    private void checkTimeout() {
        long elapsed = Math.abs(System.nanoTime() - this.lastActivity);
        if (elapsed > this.sessionTimeout.toNanos()) {
            this.logger.debug("Session id={} lifetime expired ({}ms).", (Object)this.sessionId, (Object)this.sessionTimeout.toMillis());
            this.subscriptionManager.sessionClosed(true);
            this.listeners.forEach(listener -> listener.onSessionClosed(this, true));
        } else {
            long remaining = this.sessionTimeout.toNanos() - elapsed;
            this.logger.trace("Session id={} timeout scheduled for +{}s.", (Object)this.sessionId, (Object)Duration.ofNanos(remaining).getSeconds());
            this.checkTimeoutFuture = this.server.getScheduledExecutorService().schedule(this::checkTimeout, remaining, TimeUnit.NANOSECONDS);
        }
    }

    public NodeId getSessionId() {
        return this.sessionId;
    }

    public String getSessionName() {
        return this.sessionName;
    }

    public AttributeServices getAttributeServices() {
        return this.attributeServices;
    }

    public AttributeHistoryServices getAttributeHistoryServices() {
        return this.attributeHistoryServices;
    }

    public MethodServices getMethodServices() {
        return this.methodServices;
    }

    public MonitoredItemServices getMonitoredItemServices() {
        return this.monitoredItemServices;
    }

    public NodeManagementServiceSet getNodeManagementServices() {
        return this.nodeManagementServices;
    }

    public QueryServices getQueryServices() {
        return this.queryServices;
    }

    public SubscriptionServices getSubscriptionServices() {
        return this.subscriptionServices;
    }

    public ViewServices getViewServices() {
        return this.viewServices;
    }

    public SubscriptionManager getSubscriptionManager() {
        return this.subscriptionManager;
    }

    public void onCreateSession(ServiceRequest<CreateSessionRequest, CreateSessionResponse> req) throws UaException {
        throw new UaException(0x80020000L);
    }

    public void onActivateSession(ServiceRequest<ActivateSessionRequest, ActivateSessionResponse> req) throws UaException {
        throw new UaException(0x80020000L);
    }

    public void onCloseSession(ServiceRequest<CloseSessionRequest, CloseSessionResponse> serviceRequest) throws UaException {
        this.close(((CloseSessionRequest)serviceRequest.getRequest()).getDeleteSubscriptions());
        serviceRequest.setResponse((UaResponseMessage)new CloseSessionResponse(serviceRequest.createResponseHeader()));
    }

    void close(boolean deleteSubscriptions) {
        if (this.checkTimeoutFuture != null) {
            this.checkTimeoutFuture.cancel(false);
        }
        this.subscriptionManager.sessionClosed(deleteSubscriptions);
        this.listeners.forEach(listener -> listener.onSessionClosed(this, deleteSubscriptions));
    }

    public void onCancel(ServiceRequest<CancelRequest, CancelResponse> serviceRequest) throws UaException {
        serviceRequest.setResponse((UaResponseMessage)new CancelResponse(serviceRequest.createResponseHeader(), Unsigned.uint((int)0)));
    }

    public static interface LifecycleListener {
        public void onSessionClosed(Session var1, boolean var2);
    }
}

