/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server;

import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.math.DoubleMath;
import com.google.common.primitives.Bytes;
import java.math.RoundingMode;
import java.net.URI;
import java.nio.ByteBuffer;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.eclipse.milo.opcua.sdk.server.OpcUaServer;
import org.eclipse.milo.opcua.sdk.server.Session;
import org.eclipse.milo.opcua.sdk.server.identity.IdentityValidator;
import org.eclipse.milo.opcua.sdk.server.services.ServiceAttributes;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.UaRuntimeException;
import org.eclipse.milo.opcua.stack.core.application.services.AttributeHistoryServiceSet;
import org.eclipse.milo.opcua.stack.core.application.services.AttributeServiceSet;
import org.eclipse.milo.opcua.stack.core.application.services.MethodServiceSet;
import org.eclipse.milo.opcua.stack.core.application.services.MonitoredItemServiceSet;
import org.eclipse.milo.opcua.stack.core.application.services.NodeManagementServiceSet;
import org.eclipse.milo.opcua.stack.core.application.services.QueryServiceSet;
import org.eclipse.milo.opcua.stack.core.application.services.ServiceRequest;
import org.eclipse.milo.opcua.stack.core.application.services.SessionServiceSet;
import org.eclipse.milo.opcua.stack.core.application.services.SubscriptionServiceSet;
import org.eclipse.milo.opcua.stack.core.application.services.ViewServiceSet;
import org.eclipse.milo.opcua.stack.core.channel.SecureChannel;
import org.eclipse.milo.opcua.stack.core.channel.ServerSecureChannel;
import org.eclipse.milo.opcua.stack.core.security.SecurityAlgorithm;
import org.eclipse.milo.opcua.stack.core.security.SecurityPolicy;
import org.eclipse.milo.opcua.stack.core.serialization.UaResponseMessage;
import org.eclipse.milo.opcua.stack.core.types.builtin.ByteString;
import org.eclipse.milo.opcua.stack.core.types.builtin.DiagnosticInfo;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.Unsigned;
import org.eclipse.milo.opcua.stack.core.types.structured.ActivateSessionRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.ActivateSessionResponse;
import org.eclipse.milo.opcua.stack.core.types.structured.AddNodesRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.AddNodesResponse;
import org.eclipse.milo.opcua.stack.core.types.structured.AddReferencesRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.AddReferencesResponse;
import org.eclipse.milo.opcua.stack.core.types.structured.BrowseNextRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.BrowseNextResponse;
import org.eclipse.milo.opcua.stack.core.types.structured.BrowseRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.BrowseResponse;
import org.eclipse.milo.opcua.stack.core.types.structured.CallRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.CallResponse;
import org.eclipse.milo.opcua.stack.core.types.structured.CancelRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.CancelResponse;
import org.eclipse.milo.opcua.stack.core.types.structured.CloseSessionRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.CloseSessionResponse;
import org.eclipse.milo.opcua.stack.core.types.structured.CreateMonitoredItemsRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.CreateMonitoredItemsResponse;
import org.eclipse.milo.opcua.stack.core.types.structured.CreateSessionRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.CreateSessionResponse;
import org.eclipse.milo.opcua.stack.core.types.structured.CreateSubscriptionRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.CreateSubscriptionResponse;
import org.eclipse.milo.opcua.stack.core.types.structured.DeleteMonitoredItemsRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.DeleteMonitoredItemsResponse;
import org.eclipse.milo.opcua.stack.core.types.structured.DeleteNodesRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.DeleteNodesResponse;
import org.eclipse.milo.opcua.stack.core.types.structured.DeleteReferencesRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.DeleteReferencesResponse;
import org.eclipse.milo.opcua.stack.core.types.structured.DeleteSubscriptionsRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.DeleteSubscriptionsResponse;
import org.eclipse.milo.opcua.stack.core.types.structured.EndpointDescription;
import org.eclipse.milo.opcua.stack.core.types.structured.HistoryReadRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.HistoryReadResponse;
import org.eclipse.milo.opcua.stack.core.types.structured.HistoryUpdateRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.HistoryUpdateResponse;
import org.eclipse.milo.opcua.stack.core.types.structured.ModifyMonitoredItemsRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.ModifyMonitoredItemsResponse;
import org.eclipse.milo.opcua.stack.core.types.structured.ModifySubscriptionRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.ModifySubscriptionResponse;
import org.eclipse.milo.opcua.stack.core.types.structured.PublishRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.PublishResponse;
import org.eclipse.milo.opcua.stack.core.types.structured.QueryFirstRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.QueryFirstResponse;
import org.eclipse.milo.opcua.stack.core.types.structured.QueryNextRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.QueryNextResponse;
import org.eclipse.milo.opcua.stack.core.types.structured.ReadRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.ReadResponse;
import org.eclipse.milo.opcua.stack.core.types.structured.RegisterNodesRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.RegisterNodesResponse;
import org.eclipse.milo.opcua.stack.core.types.structured.RepublishRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.RepublishResponse;
import org.eclipse.milo.opcua.stack.core.types.structured.SetMonitoringModeRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.SetMonitoringModeResponse;
import org.eclipse.milo.opcua.stack.core.types.structured.SetPublishingModeRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.SetPublishingModeResponse;
import org.eclipse.milo.opcua.stack.core.types.structured.SetTriggeringRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.SetTriggeringResponse;
import org.eclipse.milo.opcua.stack.core.types.structured.SignatureData;
import org.eclipse.milo.opcua.stack.core.types.structured.SignedSoftwareCertificate;
import org.eclipse.milo.opcua.stack.core.types.structured.TransferSubscriptionsRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.TransferSubscriptionsResponse;
import org.eclipse.milo.opcua.stack.core.types.structured.TranslateBrowsePathsToNodeIdsRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.TranslateBrowsePathsToNodeIdsResponse;
import org.eclipse.milo.opcua.stack.core.types.structured.UnregisterNodesRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.UnregisterNodesResponse;
import org.eclipse.milo.opcua.stack.core.types.structured.UserIdentityToken;
import org.eclipse.milo.opcua.stack.core.types.structured.UserTokenPolicy;
import org.eclipse.milo.opcua.stack.core.types.structured.WriteRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.WriteResponse;
import org.eclipse.milo.opcua.stack.core.util.CertificateUtil;
import org.eclipse.milo.opcua.stack.core.util.ConversionUtil;
import org.eclipse.milo.opcua.stack.core.util.NonceUtil;
import org.eclipse.milo.opcua.stack.core.util.SignatureUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionManager
implements AttributeServiceSet,
AttributeHistoryServiceSet,
MethodServiceSet,
MonitoredItemServiceSet,
NodeManagementServiceSet,
QueryServiceSet,
SessionServiceSet,
SubscriptionServiceSet,
ViewServiceSet {
    private static final int MAX_SESSION_TIMEOUT_MS = 120000;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Map<NodeId, Session> createdSessions = Maps.newConcurrentMap();
    private final Map<NodeId, Session> activeSessions = Maps.newConcurrentMap();
    private final Map<NodeId, Session> inactiveSessions = Maps.newConcurrentMap();
    private final List<ByteString> clientNonces = Lists.newCopyOnWriteArrayList();
    private final OpcUaServer server;

    public SessionManager(OpcUaServer server) {
        this.server = server;
    }

    public List<Session> getActiveSessions() {
        return Lists.newArrayList(this.activeSessions.values());
    }

    public List<Session> getInactiveSessions() {
        return Lists.newArrayList(this.inactiveSessions.values());
    }

    public void killSession(NodeId nodeId, boolean deleteSubscriptions) {
        this.activeSessions.values().stream().filter(s -> s.getSessionId().equals((Object)nodeId)).findFirst().ifPresent(s -> s.close(deleteSubscriptions));
    }

    private Session session(ServiceRequest<?, ?> service) throws UaException {
        long secureChannelId = service.getSecureChannel().getChannelId();
        NodeId authToken = service.getRequest().getRequestHeader().getAuthenticationToken();
        Session session = this.activeSessions.get(authToken);
        if (session == null) {
            session = this.createdSessions.remove(authToken);
            if (session == null) {
                throw new UaException(2149908480L);
            }
            if (session.getSecureChannelId() != secureChannelId) {
                this.createdSessions.put(authToken, session);
                throw new UaException(2148728832L);
            }
            throw new UaException(2150039552L);
        }
        if (session.getSecureChannelId() != secureChannelId) {
            throw new UaException(0x80220000L);
        }
        session.updateLastActivity();
        service.attr(ServiceAttributes.SERVER_KEY).set((Object)this.server);
        service.attr(ServiceAttributes.SESSION_KEY).set((Object)session);
        return session;
    }

    public void onCreateSession(ServiceRequest<CreateSessionRequest, CreateSessionResponse> serviceRequest) throws UaException {
        ByteString clientCertificate;
        CreateSessionRequest request = (CreateSessionRequest)serviceRequest.getRequest();
        long maxSessionCount = this.server.getConfig().getLimits().getMaxSessionCount().longValue();
        if ((long)(this.createdSessions.size() + this.activeSessions.size()) >= maxSessionCount) {
            serviceRequest.setServiceFault(2153119744L);
            return;
        }
        ByteString serverNonce = NonceUtil.generateNonce((int)32);
        NodeId authenticationToken = new NodeId(0, NonceUtil.generateNonce((int)32));
        long maxRequestMessageSize = serviceRequest.getServer().getChannelConfig().getMaxMessageSize();
        double revisedSessionTimeout = Math.max(5000.0, Math.min(120000.0, request.getRequestedSessionTimeout()));
        ServerSecureChannel secureChannel = serviceRequest.getSecureChannel();
        SecurityPolicy securityPolicy = secureChannel.getSecurityPolicy();
        ByteString serverCertificate = serviceRequest.getSecureChannel().getEndpointDescription().getServerCertificate();
        SignedSoftwareCertificate[] serverSoftwareCertificates = this.server.getSoftwareCertificates();
        EndpointDescription[] serverEndpoints = (EndpointDescription[])Arrays.stream(this.server.getEndpointDescriptions()).filter(ed -> this.endpointMatchesUrl((EndpointDescription)ed, request.getEndpointUrl())).toArray(EndpointDescription[]::new);
        ByteString clientNonce = request.getClientNonce();
        if (clientNonce.isNotNull() && clientNonce.length() < 32) {
            throw new UaException(2149842944L);
        }
        if (securityPolicy != SecurityPolicy.None && this.clientNonces.contains(clientNonce)) {
            throw new UaException(2149842944L);
        }
        if (securityPolicy != SecurityPolicy.None && clientNonce.isNotNull()) {
            this.clientNonces.add(clientNonce);
            while (this.clientNonces.size() > 64) {
                this.clientNonces.remove(0);
            }
        }
        if ((clientCertificate = request.getClientCertificate()).isNotNull() && secureChannel.getSecurityPolicy() != SecurityPolicy.None) {
            String applicationUri = request.getClientDescription().getApplicationUri();
            X509Certificate certificate = CertificateUtil.decodeCertificate((byte[])clientCertificate.bytes());
            this.validateApplicationUri(applicationUri, certificate);
        }
        SignatureData serverSignature = this.getServerSignature(clientNonce, clientCertificate, securityPolicy, secureChannel.getKeyPair());
        NodeId sessionId = new NodeId(1, "Session:" + UUID.randomUUID());
        String sessionName = request.getSessionName();
        Duration sessionTimeout = Duration.ofMillis(DoubleMath.roundToLong((double)revisedSessionTimeout, (RoundingMode)RoundingMode.UP));
        Session session = new Session(this.server, sessionId, sessionName, sessionTimeout, secureChannel.getChannelId());
        this.createdSessions.put(authenticationToken, session);
        session.addLifecycleListener((s, remove) -> {
            this.createdSessions.remove(authenticationToken);
            this.activeSessions.remove(authenticationToken);
        });
        session.setLastNonce(serverNonce);
        CreateSessionResponse response = new CreateSessionResponse(serviceRequest.createResponseHeader(), sessionId, authenticationToken, Double.valueOf(revisedSessionTimeout), serverNonce, serverCertificate, serverEndpoints, serverSoftwareCertificates, serverSignature, Unsigned.uint((long)maxRequestMessageSize));
        serviceRequest.setResponse((UaResponseMessage)response);
    }

    private boolean endpointMatchesUrl(EndpointDescription endpoint, String endpointUrl) {
        try {
            String requestedHost = new URI(endpointUrl).parseServerAuthority().getHost();
            String endpointHost = new URI(endpoint.getEndpointUrl()).parseServerAuthority().getHost();
            return requestedHost.equalsIgnoreCase(endpointHost);
        }
        catch (Throwable e) {
            this.logger.warn("Unable to create URI.", e);
            return false;
        }
    }

    private void validateApplicationUri(String applicationUri, X509Certificate certificate) throws UaException {
        try {
            Collection<List<?>> subjectAltNames = certificate.getSubjectAlternativeNames();
            if (subjectAltNames == null) {
                subjectAltNames = Collections.emptyList();
            }
            for (List<?> idAndValue : subjectAltNames) {
                if (idAndValue == null || idAndValue.size() != 2 || !idAndValue.get(0).equals(6)) continue;
                String certificateUri = (String)idAndValue.get(1);
                if (!applicationUri.equals(certificateUri)) {
                    String message = String.format("Certificate URI does not match. certificateUri=%s, applicationUri=%s", certificateUri, applicationUri);
                    this.logger.warn(message);
                    throw new UaException(2148990976L, message);
                }
                return;
            }
            String message = "Certificate does not contain a SubjectAlternativeName URI entry.";
            throw new UaException(2148990976L, message);
        }
        catch (CertificateParsingException e) {
            this.logger.warn("Error parsing client certificate.", (Throwable)e);
            throw new UaException(2148663296L);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void onActivateSession(ServiceRequest<ActivateSessionRequest, ActivateSessionResponse> serviceRequest) throws UaException {
        ActivateSessionRequest request = (ActivateSessionRequest)serviceRequest.getRequest();
        ServerSecureChannel secureChannel = serviceRequest.getSecureChannel();
        long secureChannelId = secureChannel.getChannelId();
        NodeId authToken = request.getRequestHeader().getAuthenticationToken();
        List clientSoftwareCertificates = ConversionUtil.l((Object[])request.getClientSoftwareCertificates());
        Session session = this.createdSessions.get(authToken);
        if (session == null) {
            session = this.activeSessions.get(authToken);
            if (session == null) {
                throw new UaException(2149908480L);
            }
            this.verifyClientSignature(request, secureChannel, session);
            if (session.getSecureChannelId() == secureChannelId) {
                Object tokenObject = request.getUserIdentityToken().decode();
                Object identityObject = this.validateIdentityToken(secureChannel, session, tokenObject, request.getUserTokenSignature());
                session.setIdentityObject(identityObject);
                Object[] results = new StatusCode[clientSoftwareCertificates.size()];
                Arrays.fill(results, StatusCode.GOOD);
                ByteString serverNonce = NonceUtil.generateNonce((int)32);
                session.setLastNonce(serverNonce);
                ActivateSessionResponse response = new ActivateSessionResponse(serviceRequest.createResponseHeader(), serverNonce, (StatusCode[])results, new DiagnosticInfo[0]);
                serviceRequest.setResponse((UaResponseMessage)response);
                return;
            } else {
                ByteString certificateBytes = secureChannel.getRemoteCertificateBytes();
                if (request.getUserIdentityToken() == null || request.getUserIdentityToken().decode() == null) {
                    throw new UaException(0x80200000L, "identity token not provided");
                }
                Object tokenObject = request.getUserIdentityToken().decode();
                Object identityObject = this.validateIdentityToken(secureChannel, session, tokenObject, request.getUserTokenSignature());
                if (!identityObject.equals(session.getIdentityObject()) || !certificateBytes.equals((Object)session.getClientCertificateBytes())) throw new UaException(2148728832L);
                session.setSecureChannelId(secureChannelId);
                this.logger.debug("Session id={} is now associated with secureChannelId={}", (Object)session.getSessionId(), (Object)secureChannelId);
                Object[] results = new StatusCode[clientSoftwareCertificates.size()];
                Arrays.fill(results, StatusCode.GOOD);
                ByteString serverNonce = NonceUtil.generateNonce((int)32);
                session.setLastNonce(serverNonce);
                ActivateSessionResponse response = new ActivateSessionResponse(serviceRequest.createResponseHeader(), serverNonce, (StatusCode[])results, new DiagnosticInfo[0]);
                serviceRequest.setResponse((UaResponseMessage)response);
            }
            return;
        } else {
            if (secureChannelId != session.getSecureChannelId()) {
                throw new UaException(2148728832L);
            }
            if (request.getUserIdentityToken() == null || request.getUserIdentityToken().decode() == null) {
                throw new UaException(0x80200000L, "identity token not provided");
            }
            this.verifyClientSignature(request, secureChannel, session);
            Object tokenObject = request.getUserIdentityToken().decode();
            Object identityObject = this.validateIdentityToken(secureChannel, session, tokenObject, request.getUserTokenSignature());
            session.setIdentityObject(identityObject);
            this.createdSessions.remove(authToken);
            this.activeSessions.put(authToken, session);
            session.setClientCertificateBytes(secureChannel.getRemoteCertificateBytes());
            Object[] results = new StatusCode[clientSoftwareCertificates.size()];
            Arrays.fill(results, StatusCode.GOOD);
            ByteString serverNonce = NonceUtil.generateNonce((int)32);
            session.setLastNonce(serverNonce);
            ActivateSessionResponse response = new ActivateSessionResponse(serviceRequest.createResponseHeader(), serverNonce, (StatusCode[])results, new DiagnosticInfo[0]);
            serviceRequest.setResponse((UaResponseMessage)response);
        }
    }

    private void verifyClientSignature(ActivateSessionRequest request, ServerSecureChannel secureChannel, Session session) throws UaException {
        if (secureChannel.getSecurityPolicy() != SecurityPolicy.None) {
            SignatureData clientSignature = request.getClientSignature();
            byte[] dataBytes = Bytes.concat((byte[][])new byte[][]{secureChannel.getLocalCertificateBytes().bytesOrEmpty(), session.getLastNonce().bytesOrEmpty()});
            byte[] signatureBytes = clientSignature.getSignature().bytesOrEmpty();
            SignatureUtil.verify((SecurityAlgorithm)SecurityAlgorithm.fromUri((String)clientSignature.getAlgorithm()), (X509Certificate)secureChannel.getRemoteCertificate(), (byte[])dataBytes, (byte[])signatureBytes);
        }
    }

    private Object validateIdentityToken(ServerSecureChannel channel, Session session, Object tokenObject, SignatureData tokenSignature) throws UaException {
        IdentityValidator identityValidator = this.server.getConfig().getIdentityValidator();
        UserTokenPolicy tokenPolicy = this.validatePolicyId(tokenObject);
        if (tokenObject instanceof UserIdentityToken) {
            return identityValidator.validateIdentityToken((SecureChannel)channel, session, (UserIdentityToken)tokenObject, tokenPolicy, tokenSignature);
        }
        throw new UaException(0x80200000L);
    }

    private UserTokenPolicy validatePolicyId(Object tokenObject) throws UaException {
        if (tokenObject instanceof UserIdentityToken) {
            UserIdentityToken token = (UserIdentityToken)tokenObject;
            String policyId = token.getPolicyId();
            for (UserTokenPolicy policy : this.server.getUserTokenPolicies()) {
                if (!Objects.equal((Object)policyId, (Object)policy.getPolicyId())) continue;
                return policy;
            }
            throw new UaException(0x80200000L, "policy not found: " + policyId);
        }
        throw new UaException(0x80200000L);
    }

    public void onCloseSession(ServiceRequest<CloseSessionRequest, CloseSessionResponse> service) throws UaException {
        long secureChannelId = service.getSecureChannel().getChannelId();
        NodeId authToken = ((CloseSessionRequest)service.getRequest()).getRequestHeader().getAuthenticationToken();
        Session session = this.activeSessions.get(authToken);
        if (session != null) {
            if (session.getSecureChannelId() != secureChannelId) {
                throw new UaException(0x80220000L);
            }
            this.activeSessions.remove(authToken);
            session.onCloseSession(service);
        } else {
            session = this.createdSessions.get(authToken);
            if (session == null) {
                throw new UaException(2149908480L);
            }
            if (session.getSecureChannelId() != secureChannelId) {
                throw new UaException(0x80220000L);
            }
            this.createdSessions.remove(authToken);
            session.onCloseSession(service);
        }
    }

    public void onCancel(ServiceRequest<CancelRequest, CancelResponse> service) throws UaException {
        this.session(service).onCancel(service);
    }

    private SignatureData getServerSignature(ByteString clientNonce, ByteString clientCertificate, SecurityPolicy securityPolicy, KeyPair keyPair) throws UaException {
        if (clientNonce.isNull() || clientCertificate.isNull() || keyPair == null) {
            return new SignatureData(null, null);
        }
        try {
            SecurityAlgorithm algorithm = securityPolicy.getAsymmetricSignatureAlgorithm();
            byte[] data = Bytes.concat((byte[][])new byte[][]{clientCertificate.bytes(), clientNonce.bytes()});
            byte[] signature = SignatureUtil.sign((SecurityAlgorithm)algorithm, (PrivateKey)keyPair.getPrivate(), (ByteBuffer[])new ByteBuffer[]{ByteBuffer.wrap(data)});
            return new SignatureData(algorithm.getUri(), ByteString.of((byte[])signature));
        }
        catch (UaRuntimeException e) {
            throw new UaException(2148728832L);
        }
    }

    public void onRead(ServiceRequest<ReadRequest, ReadResponse> service) throws UaException {
        Session session = this.session(service);
        session.getAttributeServices().onRead(service);
    }

    public void onWrite(ServiceRequest<WriteRequest, WriteResponse> service) throws UaException {
        Session session = this.session(service);
        session.getAttributeServices().onWrite(service);
    }

    public void onHistoryRead(ServiceRequest<HistoryReadRequest, HistoryReadResponse> service) throws UaException {
        Session session = this.session(service);
        session.getAttributeHistoryServices().onHistoryRead(service);
    }

    public void onHistoryUpdate(ServiceRequest<HistoryUpdateRequest, HistoryUpdateResponse> service) throws UaException {
        Session session = this.session(service);
        session.getAttributeHistoryServices().onHistoryUpdate(service);
    }

    public void onBrowse(ServiceRequest<BrowseRequest, BrowseResponse> service) throws UaException {
        Session session = this.session(service);
        session.getViewServices().onBrowse(service);
    }

    public void onBrowseNext(ServiceRequest<BrowseNextRequest, BrowseNextResponse> service) throws UaException {
        Session session = this.session(service);
        session.getViewServices().onBrowseNext(service);
    }

    public void onTranslateBrowsePaths(ServiceRequest<TranslateBrowsePathsToNodeIdsRequest, TranslateBrowsePathsToNodeIdsResponse> service) throws UaException {
        Session session = this.session(service);
        session.getViewServices().onTranslateBrowsePaths(service);
    }

    public void onRegisterNodes(ServiceRequest<RegisterNodesRequest, RegisterNodesResponse> service) throws UaException {
        Session session = this.session(service);
        session.getViewServices().onRegisterNodes(service);
    }

    public void onUnregisterNodes(ServiceRequest<UnregisterNodesRequest, UnregisterNodesResponse> service) throws UaException {
        Session session = this.session(service);
        session.getViewServices().onUnregisterNodes(service);
    }

    public void onAddNodes(ServiceRequest<AddNodesRequest, AddNodesResponse> service) throws UaException {
        Session session = this.session(service);
        session.getNodeManagementServices().onAddNodes(service);
    }

    public void onAddReferences(ServiceRequest<AddReferencesRequest, AddReferencesResponse> service) throws UaException {
        Session session = this.session(service);
        session.getNodeManagementServices().onAddReferences(service);
    }

    public void onDeleteNodes(ServiceRequest<DeleteNodesRequest, DeleteNodesResponse> service) throws UaException {
        Session session = this.session(service);
        session.getNodeManagementServices().onDeleteNodes(service);
    }

    public void onDeleteReferences(ServiceRequest<DeleteReferencesRequest, DeleteReferencesResponse> service) throws UaException {
        Session session = this.session(service);
        session.getNodeManagementServices().onDeleteReferences(service);
    }

    public void onCreateSubscription(ServiceRequest<CreateSubscriptionRequest, CreateSubscriptionResponse> service) throws UaException {
        Session session = this.session(service);
        session.getSubscriptionServices().onCreateSubscription(service);
    }

    public void onModifySubscription(ServiceRequest<ModifySubscriptionRequest, ModifySubscriptionResponse> service) throws UaException {
        Session session = this.session(service);
        session.getSubscriptionServices().onModifySubscription(service);
    }

    public void onSetPublishingMode(ServiceRequest<SetPublishingModeRequest, SetPublishingModeResponse> service) throws UaException {
        Session session = this.session(service);
        session.getSubscriptionServices().onSetPublishingMode(service);
    }

    public void onPublish(ServiceRequest<PublishRequest, PublishResponse> service) throws UaException {
        Session session = this.session(service);
        session.getSubscriptionServices().onPublish(service);
    }

    public void onRepublish(ServiceRequest<RepublishRequest, RepublishResponse> service) throws UaException {
        Session session = this.session(service);
        session.getSubscriptionServices().onRepublish(service);
    }

    public void onTransferSubscriptions(ServiceRequest<TransferSubscriptionsRequest, TransferSubscriptionsResponse> service) throws UaException {
        Session session = this.session(service);
        session.getSubscriptionServices().onTransferSubscriptions(service);
    }

    public void onDeleteSubscriptions(ServiceRequest<DeleteSubscriptionsRequest, DeleteSubscriptionsResponse> service) throws UaException {
        Session session = this.session(service);
        session.getSubscriptionServices().onDeleteSubscriptions(service);
    }

    public void onCreateMonitoredItems(ServiceRequest<CreateMonitoredItemsRequest, CreateMonitoredItemsResponse> service) throws UaException {
        Session session = this.session(service);
        session.getMonitoredItemServices().onCreateMonitoredItems(service);
    }

    public void onModifyMonitoredItems(ServiceRequest<ModifyMonitoredItemsRequest, ModifyMonitoredItemsResponse> service) throws UaException {
        Session session = this.session(service);
        session.getMonitoredItemServices().onModifyMonitoredItems(service);
    }

    public void onSetMonitoringMode(ServiceRequest<SetMonitoringModeRequest, SetMonitoringModeResponse> service) throws UaException {
        Session session = this.session(service);
        session.getMonitoredItemServices().onSetMonitoringMode(service);
    }

    public void onSetTriggering(ServiceRequest<SetTriggeringRequest, SetTriggeringResponse> service) throws UaException {
        Session session = this.session(service);
        session.getMonitoredItemServices().onSetTriggering(service);
    }

    public void onDeleteMonitoredItems(ServiceRequest<DeleteMonitoredItemsRequest, DeleteMonitoredItemsResponse> service) throws UaException {
        Session session = this.session(service);
        session.getMonitoredItemServices().onDeleteMonitoredItems(service);
    }

    public void onCall(ServiceRequest<CallRequest, CallResponse> service) throws UaException {
        Session session = this.session(service);
        session.getMethodServices().onCall(service);
    }

    public void onQueryFirst(ServiceRequest<QueryFirstRequest, QueryFirstResponse> service) throws UaException {
        Session session = this.session(service);
        session.getQueryServices().onQueryFirst(service);
    }

    public void onQueryNext(ServiceRequest<QueryNextRequest, QueryNextResponse> service) throws UaException {
        Session session = this.session(service);
        session.getQueryServices().onQueryNext(service);
    }
}

