/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.model.nodes.objects;

import java.util.Optional;
import org.eclipse.milo.opcua.sdk.core.annotations.UaObjectNode;
import org.eclipse.milo.opcua.sdk.server.api.ServerNodeMap;
import org.eclipse.milo.opcua.sdk.server.api.nodes.VariableNode;
import org.eclipse.milo.opcua.sdk.server.model.nodes.objects.ConditionNode;
import org.eclipse.milo.opcua.sdk.server.model.nodes.variables.TwoStateVariableNode;
import org.eclipse.milo.opcua.sdk.server.model.types.objects.AcknowledgeableConditionType;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UByte;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;

@UaObjectNode(typeName="0:AcknowledgeableConditionType")
public class AcknowledgeableConditionNode
extends ConditionNode
implements AcknowledgeableConditionType {
    public AcknowledgeableConditionNode(ServerNodeMap nodeMap, NodeId nodeId, QualifiedName browseName, LocalizedText displayName, LocalizedText description, UInteger writeMask, UInteger userWriteMask, UByte eventNotifier) {
        super(nodeMap, nodeId, browseName, displayName, description, writeMask, userWriteMask, eventNotifier);
    }

    @Override
    public LocalizedText getEnabledState() {
        Optional<VariableNode> component = this.getVariableComponent("EnabledState");
        return component.map(node -> (LocalizedText)node.getValue().getValue().getValue()).orElse(null);
    }

    @Override
    public TwoStateVariableNode getEnabledStateNode() {
        Optional<VariableNode> component = this.getVariableComponent("EnabledState");
        return component.map(node -> (TwoStateVariableNode)node).orElse(null);
    }

    @Override
    public void setEnabledState(LocalizedText value) {
        this.getVariableComponent("EnabledState").ifPresent(n -> n.setValue(new DataValue(new Variant((Object)value))));
    }

    @Override
    public LocalizedText getAckedState() {
        Optional<VariableNode> component = this.getVariableComponent("AckedState");
        return component.map(node -> (LocalizedText)node.getValue().getValue().getValue()).orElse(null);
    }

    @Override
    public TwoStateVariableNode getAckedStateNode() {
        Optional<VariableNode> component = this.getVariableComponent("AckedState");
        return component.map(node -> (TwoStateVariableNode)node).orElse(null);
    }

    @Override
    public void setAckedState(LocalizedText value) {
        this.getVariableComponent("AckedState").ifPresent(n -> n.setValue(new DataValue(new Variant((Object)value))));
    }

    @Override
    public LocalizedText getConfirmedState() {
        Optional<VariableNode> component = this.getVariableComponent("ConfirmedState");
        return component.map(node -> (LocalizedText)node.getValue().getValue().getValue()).orElse(null);
    }

    @Override
    public TwoStateVariableNode getConfirmedStateNode() {
        Optional<VariableNode> component = this.getVariableComponent("ConfirmedState");
        return component.map(node -> (TwoStateVariableNode)node).orElse(null);
    }

    @Override
    public void setConfirmedState(LocalizedText value) {
        this.getVariableComponent("ConfirmedState").ifPresent(n -> n.setValue(new DataValue(new Variant((Object)value))));
    }
}

