/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.model.nodes.objects;

import java.util.Optional;
import org.eclipse.milo.opcua.sdk.core.annotations.UaObjectNode;
import org.eclipse.milo.opcua.sdk.server.api.ServerNodeMap;
import org.eclipse.milo.opcua.sdk.server.api.nodes.VariableNode;
import org.eclipse.milo.opcua.sdk.server.model.nodes.objects.ConditionNode;
import org.eclipse.milo.opcua.sdk.server.model.nodes.variables.PropertyNode;
import org.eclipse.milo.opcua.sdk.server.model.nodes.variables.TwoStateVariableNode;
import org.eclipse.milo.opcua.sdk.server.model.types.objects.DialogConditionType;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UByte;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;

@UaObjectNode(typeName="0:DialogConditionType")
public class DialogConditionNode
extends ConditionNode
implements DialogConditionType {
    public DialogConditionNode(ServerNodeMap nodeMap, NodeId nodeId, QualifiedName browseName, LocalizedText displayName, LocalizedText description, UInteger writeMask, UInteger userWriteMask, UByte eventNotifier) {
        super(nodeMap, nodeId, browseName, displayName, description, writeMask, userWriteMask, eventNotifier);
    }

    @Override
    public LocalizedText getPrompt() {
        Optional<LocalizedText> property = this.getProperty(DialogConditionType.PROMPT);
        return property.orElse(null);
    }

    @Override
    public PropertyNode getPromptNode() {
        Optional<VariableNode> propertyNode = this.getPropertyNode(DialogConditionType.PROMPT.getBrowseName());
        return propertyNode.map(n -> (PropertyNode)n).orElse(null);
    }

    @Override
    public void setPrompt(LocalizedText value) {
        this.setProperty(DialogConditionType.PROMPT, value);
    }

    @Override
    public LocalizedText[] getResponseOptionSet() {
        Optional<LocalizedText[]> property = this.getProperty(DialogConditionType.RESPONSE_OPTION_SET);
        return property.orElse(null);
    }

    @Override
    public PropertyNode getResponseOptionSetNode() {
        Optional<VariableNode> propertyNode = this.getPropertyNode(DialogConditionType.RESPONSE_OPTION_SET.getBrowseName());
        return propertyNode.map(n -> (PropertyNode)n).orElse(null);
    }

    @Override
    public void setResponseOptionSet(LocalizedText[] value) {
        this.setProperty(DialogConditionType.RESPONSE_OPTION_SET, value);
    }

    @Override
    public Integer getDefaultResponse() {
        Optional<Integer> property = this.getProperty(DialogConditionType.DEFAULT_RESPONSE);
        return property.orElse(null);
    }

    @Override
    public PropertyNode getDefaultResponseNode() {
        Optional<VariableNode> propertyNode = this.getPropertyNode(DialogConditionType.DEFAULT_RESPONSE.getBrowseName());
        return propertyNode.map(n -> (PropertyNode)n).orElse(null);
    }

    @Override
    public void setDefaultResponse(Integer value) {
        this.setProperty(DialogConditionType.DEFAULT_RESPONSE, value);
    }

    @Override
    public Integer getOkResponse() {
        Optional<Integer> property = this.getProperty(DialogConditionType.OK_RESPONSE);
        return property.orElse(null);
    }

    @Override
    public PropertyNode getOkResponseNode() {
        Optional<VariableNode> propertyNode = this.getPropertyNode(DialogConditionType.OK_RESPONSE.getBrowseName());
        return propertyNode.map(n -> (PropertyNode)n).orElse(null);
    }

    @Override
    public void setOkResponse(Integer value) {
        this.setProperty(DialogConditionType.OK_RESPONSE, value);
    }

    @Override
    public Integer getCancelResponse() {
        Optional<Integer> property = this.getProperty(DialogConditionType.CANCEL_RESPONSE);
        return property.orElse(null);
    }

    @Override
    public PropertyNode getCancelResponseNode() {
        Optional<VariableNode> propertyNode = this.getPropertyNode(DialogConditionType.CANCEL_RESPONSE.getBrowseName());
        return propertyNode.map(n -> (PropertyNode)n).orElse(null);
    }

    @Override
    public void setCancelResponse(Integer value) {
        this.setProperty(DialogConditionType.CANCEL_RESPONSE, value);
    }

    @Override
    public Integer getLastResponse() {
        Optional<Integer> property = this.getProperty(DialogConditionType.LAST_RESPONSE);
        return property.orElse(null);
    }

    @Override
    public PropertyNode getLastResponseNode() {
        Optional<VariableNode> propertyNode = this.getPropertyNode(DialogConditionType.LAST_RESPONSE.getBrowseName());
        return propertyNode.map(n -> (PropertyNode)n).orElse(null);
    }

    @Override
    public void setLastResponse(Integer value) {
        this.setProperty(DialogConditionType.LAST_RESPONSE, value);
    }

    @Override
    public LocalizedText getEnabledState() {
        Optional<VariableNode> component = this.getVariableComponent("EnabledState");
        return component.map(node -> (LocalizedText)node.getValue().getValue().getValue()).orElse(null);
    }

    @Override
    public TwoStateVariableNode getEnabledStateNode() {
        Optional<VariableNode> component = this.getVariableComponent("EnabledState");
        return component.map(node -> (TwoStateVariableNode)node).orElse(null);
    }

    @Override
    public void setEnabledState(LocalizedText value) {
        this.getVariableComponent("EnabledState").ifPresent(n -> n.setValue(new DataValue(new Variant((Object)value))));
    }

    @Override
    public LocalizedText getDialogState() {
        Optional<VariableNode> component = this.getVariableComponent("DialogState");
        return component.map(node -> (LocalizedText)node.getValue().getValue().getValue()).orElse(null);
    }

    @Override
    public TwoStateVariableNode getDialogStateNode() {
        Optional<VariableNode> component = this.getVariableComponent("DialogState");
        return component.map(node -> (TwoStateVariableNode)node).orElse(null);
    }

    @Override
    public void setDialogState(LocalizedText value) {
        this.getVariableComponent("DialogState").ifPresent(n -> n.setValue(new DataValue(new Variant((Object)value))));
    }
}

