/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.model.nodes.objects;

import java.util.Optional;
import org.eclipse.milo.opcua.sdk.core.annotations.UaObjectNode;
import org.eclipse.milo.opcua.sdk.server.api.ServerNodeMap;
import org.eclipse.milo.opcua.sdk.server.api.nodes.VariableNode;
import org.eclipse.milo.opcua.sdk.server.model.nodes.objects.AlarmConditionNode;
import org.eclipse.milo.opcua.sdk.server.model.nodes.variables.PropertyNode;
import org.eclipse.milo.opcua.sdk.server.model.types.objects.LimitAlarmType;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UByte;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;

@UaObjectNode(typeName="0:LimitAlarmType")
public class LimitAlarmNode
extends AlarmConditionNode
implements LimitAlarmType {
    public LimitAlarmNode(ServerNodeMap nodeMap, NodeId nodeId, QualifiedName browseName, LocalizedText displayName, LocalizedText description, UInteger writeMask, UInteger userWriteMask, UByte eventNotifier) {
        super(nodeMap, nodeId, browseName, displayName, description, writeMask, userWriteMask, eventNotifier);
    }

    @Override
    public Double getHighHighLimit() {
        Optional<Double> property = this.getProperty(LimitAlarmType.HIGH_HIGH_LIMIT);
        return property.orElse(null);
    }

    @Override
    public PropertyNode getHighHighLimitNode() {
        Optional<VariableNode> propertyNode = this.getPropertyNode(LimitAlarmType.HIGH_HIGH_LIMIT.getBrowseName());
        return propertyNode.map(n -> (PropertyNode)n).orElse(null);
    }

    @Override
    public void setHighHighLimit(Double value) {
        this.setProperty(LimitAlarmType.HIGH_HIGH_LIMIT, value);
    }

    @Override
    public Double getHighLimit() {
        Optional<Double> property = this.getProperty(LimitAlarmType.HIGH_LIMIT);
        return property.orElse(null);
    }

    @Override
    public PropertyNode getHighLimitNode() {
        Optional<VariableNode> propertyNode = this.getPropertyNode(LimitAlarmType.HIGH_LIMIT.getBrowseName());
        return propertyNode.map(n -> (PropertyNode)n).orElse(null);
    }

    @Override
    public void setHighLimit(Double value) {
        this.setProperty(LimitAlarmType.HIGH_LIMIT, value);
    }

    @Override
    public Double getLowLimit() {
        Optional<Double> property = this.getProperty(LimitAlarmType.LOW_LIMIT);
        return property.orElse(null);
    }

    @Override
    public PropertyNode getLowLimitNode() {
        Optional<VariableNode> propertyNode = this.getPropertyNode(LimitAlarmType.LOW_LIMIT.getBrowseName());
        return propertyNode.map(n -> (PropertyNode)n).orElse(null);
    }

    @Override
    public void setLowLimit(Double value) {
        this.setProperty(LimitAlarmType.LOW_LIMIT, value);
    }

    @Override
    public Double getLowLowLimit() {
        Optional<Double> property = this.getProperty(LimitAlarmType.LOW_LOW_LIMIT);
        return property.orElse(null);
    }

    @Override
    public PropertyNode getLowLowLimitNode() {
        Optional<VariableNode> propertyNode = this.getPropertyNode(LimitAlarmType.LOW_LOW_LIMIT.getBrowseName());
        return propertyNode.map(n -> (PropertyNode)n).orElse(null);
    }

    @Override
    public void setLowLowLimit(Double value) {
        this.setProperty(LimitAlarmType.LOW_LOW_LIMIT, value);
    }
}

