/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.model.nodes.objects;

import java.util.Optional;
import org.eclipse.milo.opcua.sdk.core.annotations.UaObjectNode;
import org.eclipse.milo.opcua.sdk.server.api.ServerNodeMap;
import org.eclipse.milo.opcua.sdk.server.api.nodes.VariableNode;
import org.eclipse.milo.opcua.sdk.server.model.nodes.objects.BaseEventNode;
import org.eclipse.milo.opcua.sdk.server.model.nodes.variables.StateVariableNode;
import org.eclipse.milo.opcua.sdk.server.model.nodes.variables.TransitionVariableNode;
import org.eclipse.milo.opcua.sdk.server.model.types.objects.TransitionEventType;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UByte;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;

@UaObjectNode(typeName="0:TransitionEventType")
public class TransitionEventNode
extends BaseEventNode
implements TransitionEventType {
    public TransitionEventNode(ServerNodeMap nodeMap, NodeId nodeId, QualifiedName browseName, LocalizedText displayName, LocalizedText description, UInteger writeMask, UInteger userWriteMask, UByte eventNotifier) {
        super(nodeMap, nodeId, browseName, displayName, description, writeMask, userWriteMask, eventNotifier);
    }

    @Override
    public LocalizedText getTransition() {
        Optional<VariableNode> component = this.getVariableComponent("Transition");
        return component.map(node -> (LocalizedText)node.getValue().getValue().getValue()).orElse(null);
    }

    @Override
    public TransitionVariableNode getTransitionNode() {
        Optional<VariableNode> component = this.getVariableComponent("Transition");
        return component.map(node -> (TransitionVariableNode)node).orElse(null);
    }

    @Override
    public void setTransition(LocalizedText value) {
        this.getVariableComponent("Transition").ifPresent(n -> n.setValue(new DataValue(new Variant((Object)value))));
    }

    @Override
    public LocalizedText getFromState() {
        Optional<VariableNode> component = this.getVariableComponent("FromState");
        return component.map(node -> (LocalizedText)node.getValue().getValue().getValue()).orElse(null);
    }

    @Override
    public StateVariableNode getFromStateNode() {
        Optional<VariableNode> component = this.getVariableComponent("FromState");
        return component.map(node -> (StateVariableNode)node).orElse(null);
    }

    @Override
    public void setFromState(LocalizedText value) {
        this.getVariableComponent("FromState").ifPresent(n -> n.setValue(new DataValue(new Variant((Object)value))));
    }

    @Override
    public LocalizedText getToState() {
        Optional<VariableNode> component = this.getVariableComponent("ToState");
        return component.map(node -> (LocalizedText)node.getValue().getValue().getValue()).orElse(null);
    }

    @Override
    public StateVariableNode getToStateNode() {
        Optional<VariableNode> component = this.getVariableComponent("ToState");
        return component.map(node -> (StateVariableNode)node).orElse(null);
    }

    @Override
    public void setToState(LocalizedText value) {
        this.getVariableComponent("ToState").ifPresent(n -> n.setValue(new DataValue(new Variant((Object)value))));
    }
}

