/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.model.nodes.variables;

import java.util.Optional;
import org.eclipse.milo.opcua.sdk.core.annotations.UaVariableNode;
import org.eclipse.milo.opcua.sdk.server.api.ServerNodeMap;
import org.eclipse.milo.opcua.sdk.server.api.nodes.VariableNode;
import org.eclipse.milo.opcua.sdk.server.api.nodes.VariableTypeNode;
import org.eclipse.milo.opcua.sdk.server.model.nodes.variables.BaseDataVariableNode;
import org.eclipse.milo.opcua.sdk.server.model.nodes.variables.PropertyNode;
import org.eclipse.milo.opcua.sdk.server.model.types.variables.DataTypeDictionaryType;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UByte;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;

@UaVariableNode(typeName="0:DataTypeDictionaryType")
public class DataTypeDictionaryNode
extends BaseDataVariableNode
implements DataTypeDictionaryType {
    public DataTypeDictionaryNode(ServerNodeMap nodeMap, NodeId nodeId, VariableTypeNode variableTypeNode) {
        super(nodeMap, nodeId, variableTypeNode);
    }

    public DataTypeDictionaryNode(ServerNodeMap nodeMap, NodeId nodeId, QualifiedName browseName, LocalizedText displayName, LocalizedText description, UInteger writeMask, UInteger userWriteMask, DataValue value, NodeId dataType, Integer valueRank, UInteger[] arrayDimensions, UByte accessLevel, UByte userAccessLevel, Double minimumSamplingInterval, boolean historizing) {
        super(nodeMap, nodeId, browseName, displayName, description, writeMask, userWriteMask, value, dataType, valueRank, arrayDimensions, accessLevel, userAccessLevel, minimumSamplingInterval, historizing);
    }

    @Override
    public String getDataTypeVersion() {
        Optional<String> property = this.getProperty(DataTypeDictionaryType.DATA_TYPE_VERSION);
        return property.orElse(null);
    }

    @Override
    public PropertyNode getDataTypeVersionNode() {
        Optional<VariableNode> propertyNode = this.getPropertyNode(DataTypeDictionaryType.DATA_TYPE_VERSION.getBrowseName());
        return propertyNode.map(n -> (PropertyNode)n).orElse(null);
    }

    @Override
    public void setDataTypeVersion(String value) {
        this.setProperty(DataTypeDictionaryType.DATA_TYPE_VERSION, value);
    }

    @Override
    public String getNamespaceUri() {
        Optional<String> property = this.getProperty(DataTypeDictionaryType.NAMESPACE_URI);
        return property.orElse(null);
    }

    @Override
    public PropertyNode getNamespaceUriNode() {
        Optional<VariableNode> propertyNode = this.getPropertyNode(DataTypeDictionaryType.NAMESPACE_URI.getBrowseName());
        return propertyNode.map(n -> (PropertyNode)n).orElse(null);
    }

    @Override
    public void setNamespaceUri(String value) {
        this.setProperty(DataTypeDictionaryType.NAMESPACE_URI, value);
    }
}

