/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.model.nodes.variables;

import java.util.Optional;
import org.eclipse.milo.opcua.sdk.core.annotations.UaVariableNode;
import org.eclipse.milo.opcua.sdk.server.api.ServerNodeMap;
import org.eclipse.milo.opcua.sdk.server.api.nodes.VariableNode;
import org.eclipse.milo.opcua.sdk.server.api.nodes.VariableTypeNode;
import org.eclipse.milo.opcua.sdk.server.model.nodes.variables.BaseDataVariableNode;
import org.eclipse.milo.opcua.sdk.server.model.nodes.variables.PropertyNode;
import org.eclipse.milo.opcua.sdk.server.model.types.variables.OptionSetType;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UByte;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;

@UaVariableNode(typeName="0:OptionSetType")
public class OptionSetNode
extends BaseDataVariableNode
implements OptionSetType {
    public OptionSetNode(ServerNodeMap nodeMap, NodeId nodeId, VariableTypeNode variableTypeNode) {
        super(nodeMap, nodeId, variableTypeNode);
    }

    public OptionSetNode(ServerNodeMap nodeMap, NodeId nodeId, QualifiedName browseName, LocalizedText displayName, LocalizedText description, UInteger writeMask, UInteger userWriteMask, DataValue value, NodeId dataType, Integer valueRank, UInteger[] arrayDimensions, UByte accessLevel, UByte userAccessLevel, Double minimumSamplingInterval, boolean historizing) {
        super(nodeMap, nodeId, browseName, displayName, description, writeMask, userWriteMask, value, dataType, valueRank, arrayDimensions, accessLevel, userAccessLevel, minimumSamplingInterval, historizing);
    }

    @Override
    public LocalizedText[] getOptionSetValues() {
        Optional<LocalizedText[]> property = this.getProperty(OptionSetType.OPTION_SET_VALUES);
        return property.orElse(null);
    }

    @Override
    public PropertyNode getOptionSetValuesNode() {
        Optional<VariableNode> propertyNode = this.getPropertyNode(OptionSetType.OPTION_SET_VALUES.getBrowseName());
        return propertyNode.map(n -> (PropertyNode)n).orElse(null);
    }

    @Override
    public void setOptionSetValues(LocalizedText[] value) {
        this.setProperty(OptionSetType.OPTION_SET_VALUES, value);
    }

    @Override
    public Boolean[] getBitMask() {
        Optional<Boolean[]> property = this.getProperty(OptionSetType.BIT_MASK);
        return property.orElse(null);
    }

    @Override
    public PropertyNode getBitMaskNode() {
        Optional<VariableNode> propertyNode = this.getPropertyNode(OptionSetType.BIT_MASK.getBrowseName());
        return propertyNode.map(n -> (PropertyNode)n).orElse(null);
    }

    @Override
    public void setBitMask(Boolean[] value) {
        this.setProperty(OptionSetType.BIT_MASK, value);
    }
}

