/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.identity;

import com.google.common.primitives.Bytes;
import java.security.cert.X509Certificate;
import java.util.function.Predicate;
import org.eclipse.milo.opcua.sdk.server.Session;
import org.eclipse.milo.opcua.sdk.server.identity.AbstractIdentityValidator;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.channel.SecureChannel;
import org.eclipse.milo.opcua.stack.core.channel.ServerSecureChannel;
import org.eclipse.milo.opcua.stack.core.security.SecurityAlgorithm;
import org.eclipse.milo.opcua.stack.core.security.SecurityPolicy;
import org.eclipse.milo.opcua.stack.core.types.builtin.ByteString;
import org.eclipse.milo.opcua.stack.core.types.structured.SignatureData;
import org.eclipse.milo.opcua.stack.core.types.structured.UserTokenPolicy;
import org.eclipse.milo.opcua.stack.core.types.structured.X509IdentityToken;
import org.eclipse.milo.opcua.stack.core.util.CertificateUtil;
import org.eclipse.milo.opcua.stack.core.util.SignatureUtil;

public class X509IdentityValidator
extends AbstractIdentityValidator {
    private final Predicate<X509Certificate> predicate;

    public X509IdentityValidator(Predicate<X509Certificate> predicate) {
        this.predicate = predicate;
    }

    @Override
    public Object validateX509Token(ServerSecureChannel channel, Session session, X509IdentityToken token, UserTokenPolicy tokenPolicy, SignatureData tokenSignature) throws UaException {
        SecurityAlgorithm algorithm;
        SecurityPolicy securityPolicy;
        ByteString clientCertificateBs = token.getCertificateData();
        X509Certificate identityCertificate = CertificateUtil.decodeCertificate((byte[])clientCertificateBs.bytesOrEmpty());
        if (tokenPolicy.getSecurityPolicyUri() != null) {
            securityPolicy = SecurityPolicy.fromUri((String)tokenPolicy.getSecurityPolicyUri());
            if (!securityPolicy.getAsymmetricSignatureAlgorithm().getUri().equals(tokenSignature.getAlgorithm())) {
                throw new UaException(2148728832L, "algorithm in token signature did not match algorithm specified by token policy");
            }
        } else {
            securityPolicy = channel.getSecurityPolicy();
            if (!securityPolicy.getAsymmetricSignatureAlgorithm().getUri().equals(tokenSignature.getAlgorithm())) {
                throw new UaException(2148728832L, "algorithm in token signature did not match algorithm specified by secure channel");
            }
        }
        if ((algorithm = SecurityAlgorithm.fromUri((String)tokenSignature.getAlgorithm())) != SecurityAlgorithm.None) {
            this.verifySignature((SecureChannel)channel, session, tokenSignature, identityCertificate, algorithm);
        }
        if (this.predicate.test(identityCertificate)) {
            return identityCertificate;
        }
        throw new UaException(2149515264L);
    }

    private void verifySignature(SecureChannel channel, Session session, SignatureData tokenSignature, X509Certificate identityCertificate, SecurityAlgorithm algorithm) throws UaException {
        ByteString serverCertificateBs = channel.getLocalCertificateBytes();
        ByteString lastNonceBs = session.getLastNonce();
        byte[] dataBytes = Bytes.concat((byte[][])new byte[][]{serverCertificateBs.bytesOrEmpty(), lastNonceBs.bytesOrEmpty()});
        byte[] signatureBytes = tokenSignature.getSignature().bytesOrEmpty();
        SignatureUtil.verify((SecurityAlgorithm)algorithm, (X509Certificate)identityCertificate, (byte[])dataBytes, (byte[])signatureBytes);
    }
}

