/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.model.methods;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import org.eclipse.milo.opcua.sdk.server.OpcUaServer;
import org.eclipse.milo.opcua.sdk.server.annotations.UaInputArgument;
import org.eclipse.milo.opcua.sdk.server.annotations.UaMethod;
import org.eclipse.milo.opcua.sdk.server.annotations.UaOutputArgument;
import org.eclipse.milo.opcua.sdk.server.items.BaseMonitoredItem;
import org.eclipse.milo.opcua.sdk.server.subscriptions.Subscription;
import org.eclipse.milo.opcua.sdk.server.util.AnnotationBasedInvocationHandler;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.Unsigned;

public class GetMonitoredItems {
    private final OpcUaServer server;

    public GetMonitoredItems(OpcUaServer server) {
        this.server = server;
    }

    @UaMethod
    public void invoke(AnnotationBasedInvocationHandler.InvocationContext context, @UaInputArgument(name="subscriptionId") UInteger subscriptionId, @UaOutputArgument(name="serverHandles") AnnotationBasedInvocationHandler.Out<UInteger[]> serverHandles, @UaOutputArgument(name="clientHandles") AnnotationBasedInvocationHandler.Out<UInteger[]> clientHandles) throws UaException {
        Subscription subscription = this.server.getSubscriptions().get(subscriptionId);
        if (subscription == null) {
            context.setFailure(new UaException(new StatusCode(0x80280000L)));
        } else {
            ArrayList serverHandleList = Lists.newArrayList();
            ArrayList clientHandleList = Lists.newArrayList();
            for (BaseMonitoredItem<?> item : subscription.getMonitoredItems().values()) {
                serverHandleList.add(item.getId());
                clientHandleList.add(Unsigned.uint((long)item.getClientHandle()));
            }
            serverHandles.set(serverHandleList.toArray(new UInteger[serverHandleList.size()]));
            clientHandles.set(clientHandleList.toArray(new UInteger[clientHandleList.size()]));
        }
    }
}

