/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.namespaces;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.eclipse.milo.opcua.sdk.core.Reference;
import org.eclipse.milo.opcua.sdk.server.OpcUaServer;
import org.eclipse.milo.opcua.sdk.server.api.AccessContext;
import org.eclipse.milo.opcua.sdk.server.api.AttributeManager;
import org.eclipse.milo.opcua.sdk.server.api.DataItem;
import org.eclipse.milo.opcua.sdk.server.api.EventItem;
import org.eclipse.milo.opcua.sdk.server.api.MethodInvocationHandler;
import org.eclipse.milo.opcua.sdk.server.api.MonitoredItem;
import org.eclipse.milo.opcua.sdk.server.api.Namespace;
import org.eclipse.milo.opcua.sdk.server.api.ServerNodeMap;
import org.eclipse.milo.opcua.sdk.server.api.config.OpcUaServerConfigLimits;
import org.eclipse.milo.opcua.sdk.server.model.methods.GetMonitoredItems;
import org.eclipse.milo.opcua.sdk.server.model.methods.ResendData;
import org.eclipse.milo.opcua.sdk.server.model.nodes.objects.OperationLimitsNode;
import org.eclipse.milo.opcua.sdk.server.model.nodes.objects.ServerCapabilitiesNode;
import org.eclipse.milo.opcua.sdk.server.model.nodes.objects.ServerNode;
import org.eclipse.milo.opcua.sdk.server.model.nodes.variables.ServerStatusNode;
import org.eclipse.milo.opcua.sdk.server.namespaces.loader.UaNodeLoader;
import org.eclipse.milo.opcua.sdk.server.nodes.AttributeContext;
import org.eclipse.milo.opcua.sdk.server.nodes.DerivedVariableNode;
import org.eclipse.milo.opcua.sdk.server.nodes.UaMethodNode;
import org.eclipse.milo.opcua.sdk.server.nodes.UaObjectNode;
import org.eclipse.milo.opcua.sdk.server.nodes.UaVariableNode;
import org.eclipse.milo.opcua.sdk.server.util.AnnotationBasedInvocationHandler;
import org.eclipse.milo.opcua.sdk.server.util.SubscriptionModel;
import org.eclipse.milo.opcua.stack.core.Identifiers;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.DateTime;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UShort;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.Unsigned;
import org.eclipse.milo.opcua.stack.core.types.enumerated.NodeClass;
import org.eclipse.milo.opcua.stack.core.types.enumerated.RedundancySupport;
import org.eclipse.milo.opcua.stack.core.types.enumerated.ServerState;
import org.eclipse.milo.opcua.stack.core.types.enumerated.TimestampsToReturn;
import org.eclipse.milo.opcua.stack.core.types.structured.ReadValueId;
import org.eclipse.milo.opcua.stack.core.types.structured.WriteValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpcUaNamespace
implements Namespace {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final ServerNodeMap nodeMap;
    private final SubscriptionModel subscriptionModel;
    private final OpcUaServer server;

    public OpcUaNamespace(OpcUaServer server) {
        this.server = server;
        this.nodeMap = server.getNodeMap();
        this.subscriptionModel = new SubscriptionModel(server, this);
        this.loadNodes();
        this.configureServerObject();
    }

    @Override
    public UShort getNamespaceIndex() {
        return Unsigned.ushort((int)0);
    }

    @Override
    public String getNamespaceUri() {
        return "http://opcfoundation.org/UA/";
    }

    @Override
    public CompletableFuture<List<Reference>> browse(AccessContext context, NodeId nodeId) {
        org.eclipse.milo.opcua.sdk.server.nodes.ServerNode node = (org.eclipse.milo.opcua.sdk.server.nodes.ServerNode)this.nodeMap.get(nodeId);
        if (node != null) {
            return CompletableFuture.completedFuture(node.getReferences());
        }
        CompletableFuture<List<Reference>> f = new CompletableFuture<List<Reference>>();
        f.completeExceptionally(new UaException(2150891520L));
        return f;
    }

    @Override
    public void read(AttributeManager.ReadContext context, Double maxAge, TimestampsToReturn timestamps, List<ReadValueId> readValueIds) {
        ArrayList results = Lists.newArrayListWithCapacity((int)readValueIds.size());
        for (ReadValueId id : readValueIds) {
            org.eclipse.milo.opcua.sdk.server.nodes.ServerNode node = (org.eclipse.milo.opcua.sdk.server.nodes.ServerNode)this.nodeMap.get(id.getNodeId());
            DataValue value = node != null ? node.readAttribute(new AttributeContext(context), id.getAttributeId(), timestamps, id.getIndexRange(), id.getDataEncoding()) : new DataValue(new StatusCode(2150891520L));
            results.add(value);
        }
        context.complete(results);
    }

    @Override
    public void write(AttributeManager.WriteContext context, List<WriteValue> writeValues) {
        List results = writeValues.stream().map(value -> {
            if (this.nodeMap.containsKey(value.getNodeId())) {
                return new StatusCode(2151350272L);
            }
            return new StatusCode(2150891520L);
        }).collect(Collectors.toList());
        context.complete(results);
    }

    @Override
    public void onDataItemsCreated(List<DataItem> dataItems) {
        this.subscriptionModel.onDataItemsCreated(dataItems);
    }

    @Override
    public void onDataItemsModified(List<DataItem> dataItems) {
        this.subscriptionModel.onDataItemsModified(dataItems);
    }

    @Override
    public void onDataItemsDeleted(List<DataItem> dataItems) {
        this.subscriptionModel.onDataItemsDeleted(dataItems);
    }

    @Override
    public void onMonitoringModeChanged(List<MonitoredItem> monitoredItems) {
        this.subscriptionModel.onMonitoringModeChanged(monitoredItems);
    }

    @Override
    public void onEventItemsCreated(List<EventItem> eventItems) {
        eventItems.stream().filter(MonitoredItem::isSamplingEnabled).forEach(item -> this.server.getEventBus().register(item));
    }

    @Override
    public void onEventItemsModified(List<EventItem> eventItems) {
        for (EventItem item : eventItems) {
            if (item.isSamplingEnabled()) {
                this.server.getEventBus().register((Object)item);
                continue;
            }
            this.server.getEventBus().unregister((Object)item);
        }
    }

    @Override
    public void onEventItemsDeleted(List<EventItem> eventItems) {
        eventItems.forEach(item -> this.server.getEventBus().unregister(item));
    }

    public void addReference(NodeId sourceNodeId, NodeId referenceTypeId, boolean forward, ExpandedNodeId targetNodeId, NodeClass targetNodeClass) throws UaException {
        org.eclipse.milo.opcua.sdk.server.nodes.ServerNode node = (org.eclipse.milo.opcua.sdk.server.nodes.ServerNode)this.nodeMap.get(sourceNodeId);
        if (node == null) {
            throw new UaException(2150891520L);
        }
        Reference reference = new Reference(sourceNodeId, referenceTypeId, targetNodeId, targetNodeClass, forward);
        node.addReference(reference);
    }

    @Override
    public Optional<MethodInvocationHandler> getInvocationHandler(NodeId methodId) {
        return Optional.ofNullable(this.nodeMap.get(methodId)).filter(n -> n instanceof UaMethodNode).map(n -> {
            UaMethodNode m = (UaMethodNode)n;
            return m.getInvocationHandler().orElse(new MethodInvocationHandler.NotImplementedHandler());
        });
    }

    public UaObjectNode getObjectsFolder() {
        return (UaObjectNode)this.nodeMap.get(Identifiers.ObjectsFolder);
    }

    public ServerNode getServerNode() {
        return (ServerNode)this.nodeMap.get(Identifiers.Server);
    }

    private void loadNodes() {
        try {
            long startTime = System.nanoTime();
            new UaNodeLoader(this.nodeMap).loadNodes();
            long endTime = System.nanoTime();
            long deltaMs = TimeUnit.MILLISECONDS.convert(endTime - startTime, TimeUnit.NANOSECONDS);
            this.logger.info("Loaded nodes in {}ms.", (Object)deltaMs);
        }
        catch (Exception e) {
            this.logger.error("Error loading nodes.", (Throwable)e);
        }
    }

    private void configureServerObject() {
        AnnotationBasedInvocationHandler handler;
        ServerNode serverNode = (ServerNode)this.nodeMap.get(Identifiers.Server);
        this.replaceServerArrayNode();
        this.replaceNamespaceArrayNode();
        serverNode.setAuditing(false);
        serverNode.getServerDiagnosticsNode().setEnabledFlag(false);
        serverNode.setServiceLevel(Unsigned.ubyte((int)255));
        ServerStatusNode serverStatus = serverNode.getServerStatusNode();
        serverStatus.setBuildInfo(this.server.getConfig().getBuildInfo());
        serverStatus.setCurrentTime(DateTime.now());
        serverStatus.setSecondsTillShutdown(Unsigned.uint((int)0));
        serverStatus.setShutdownReason(LocalizedText.NULL_VALUE);
        serverStatus.setState(ServerState.Running);
        serverStatus.setStartTime(DateTime.now());
        UaVariableNode currentTime = (UaVariableNode)this.nodeMap.get(Identifiers.Server_ServerStatus_CurrentTime);
        DerivedVariableNode derivedCurrentTime = new DerivedVariableNode(this.nodeMap, currentTime){

            @Override
            public DataValue getValue() {
                return new DataValue(new Variant((Object)DateTime.now()));
            }
        };
        this.nodeMap.put(Identifiers.Server_ServerStatus_CurrentTime, derivedCurrentTime);
        OpcUaServerConfigLimits limits = this.server.getConfig().getLimits();
        ServerCapabilitiesNode serverCapabilities = serverNode.getServerCapabilitiesNode();
        serverCapabilities.setLocaleIdArray(new String[]{Locale.ENGLISH.getLanguage()});
        serverCapabilities.setMaxArrayLength(limits.getMaxArrayLength());
        serverCapabilities.setMaxBrowseContinuationPoints(limits.getMaxBrowseContinuationPoints());
        serverCapabilities.setMaxHistoryContinuationPoints(limits.getMaxHistoryContinuationPoints());
        serverCapabilities.setMaxQueryContinuationPoints(limits.getMaxQueryContinuationPoints());
        serverCapabilities.setMaxStringLength(limits.getMaxStringLength());
        serverCapabilities.setMinSupportedSampleRate(limits.getMinSupportedSampleRate());
        OperationLimitsNode limitsNode = serverCapabilities.getOperationLimitsNode();
        limitsNode.setMaxMonitoredItemsPerCall(limits.getMaxMonitoredItemsPerCall());
        limitsNode.setMaxNodesPerBrowse(limits.getMaxNodesPerBrowse());
        limitsNode.setMaxNodesPerHistoryReadData(limits.getMaxNodesPerHistoryReadData());
        limitsNode.setMaxNodesPerHistoryReadEvents(limits.getMaxNodesPerHistoryReadEvents());
        limitsNode.setMaxNodesPerHistoryUpdateData(limits.getMaxNodesPerHistoryUpdateData());
        limitsNode.setMaxNodesPerHistoryUpdateEvents(limits.getMaxNodesPerHistoryUpdateEvents());
        limitsNode.setMaxNodesPerMethodCall(limits.getMaxNodesPerMethodCall());
        limitsNode.setMaxNodesPerNodeManagement(limits.getMaxNodesPerNodeManagement());
        limitsNode.setMaxNodesPerRead(limits.getMaxNodesPerRead());
        limitsNode.setMaxNodesPerRegisterNodes(limits.getMaxNodesPerRegisterNodes());
        limitsNode.setMaxNodesPerTranslateBrowsePathsToNodeIds(limits.getMaxNodesPerTranslateBrowsePathsToNodeIds());
        limitsNode.setMaxNodesPerWrite(limits.getMaxNodesPerWrite());
        serverNode.getServerRedundancyNode().setRedundancySupport(RedundancySupport.None);
        try {
            UaMethodNode getMonitoredItems = (UaMethodNode)this.nodeMap.get(Identifiers.Server_GetMonitoredItems);
            handler = AnnotationBasedInvocationHandler.fromAnnotatedObject(this.nodeMap, new GetMonitoredItems(this.server));
            getMonitoredItems.setInvocationHandler(handler);
            getMonitoredItems.setInputArguments(handler.getInputArguments());
            getMonitoredItems.setOutputArguments(handler.getOutputArguments());
        }
        catch (Exception e) {
            this.logger.error("Error setting up GetMonitoredItems Method.", (Throwable)e);
        }
        try {
            UaMethodNode resendData = (UaMethodNode)this.nodeMap.get(Identifiers.Server_ResendData);
            handler = AnnotationBasedInvocationHandler.fromAnnotatedObject(this.nodeMap, new ResendData(this.server));
            resendData.setInvocationHandler(handler);
            resendData.setInputArguments(handler.getInputArguments());
        }
        catch (Exception e) {
            this.logger.error("Error setting up ResendData Method.", (Throwable)e);
        }
    }

    private void replaceServerArrayNode() {
        UaVariableNode originalNode = (UaVariableNode)this.nodeMap.get(Identifiers.Server_ServerArray);
        DerivedVariableNode derived = new DerivedVariableNode(this.nodeMap, originalNode){

            @Override
            public DataValue getValue() {
                return new DataValue(new Variant((Object)OpcUaNamespace.this.server.getServerTable().toArray()));
            }
        };
        this.nodeMap.put(derived.getNodeId(), derived);
    }

    private void replaceNamespaceArrayNode() {
        UaVariableNode originalNode = (UaVariableNode)this.nodeMap.get(Identifiers.Server_NamespaceArray);
        DerivedVariableNode derived = new DerivedVariableNode(this.nodeMap, originalNode){

            @Override
            public DataValue getValue() {
                return new DataValue(new Variant((Object)OpcUaNamespace.this.server.getNamespaceManager().getNamespaceTable().toArray()));
            }
        };
        this.nodeMap.put(derived.getNodeId(), derived);
    }
}

