/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.nodes;

import org.eclipse.milo.opcua.sdk.core.model.BasicProperty;
import org.eclipse.milo.opcua.sdk.core.model.Property;
import org.eclipse.milo.opcua.sdk.core.model.UaOptional;
import org.eclipse.milo.opcua.sdk.server.api.ServerNodeMap;
import org.eclipse.milo.opcua.sdk.server.api.nodes.DataTypeNode;
import org.eclipse.milo.opcua.sdk.server.nodes.UaNode;
import org.eclipse.milo.opcua.stack.core.AttributeId;
import org.eclipse.milo.opcua.stack.core.Identifiers;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.enumerated.NodeClass;
import org.eclipse.milo.opcua.stack.core.types.structured.EnumValueType;

public class UaDataTypeNode
extends UaNode
implements DataTypeNode {
    private volatile Boolean isAbstract;
    public static final Property<String> NodeVersion = new BasicProperty(new QualifiedName(0, "NodeVersion"), Identifiers.String, Integer.valueOf(-1), String.class);
    public static final Property<LocalizedText[]> EnumStrings = new BasicProperty(new QualifiedName(0, "EnumStrings"), Identifiers.LocalizedText, Integer.valueOf(1), LocalizedText[].class);
    public static final Property<EnumValueType[]> EnumValues = new BasicProperty(new QualifiedName(0, "EnumValues"), Identifiers.EnumValueType, Integer.valueOf(1), EnumValueType[].class);

    public UaDataTypeNode(ServerNodeMap nodeMap, NodeId nodeId, QualifiedName browseName, LocalizedText displayName, LocalizedText description, UInteger writeMask, UInteger userWriteMask, boolean isAbstract) {
        super(nodeMap, nodeId, NodeClass.DataType, browseName, displayName, description, writeMask, userWriteMask);
        this.isAbstract = isAbstract;
    }

    @Override
    public Boolean getIsAbstract() {
        return this.isAbstract;
    }

    @Override
    public synchronized void setIsAbstract(Boolean isAbstract) {
        this.isAbstract = isAbstract;
        this.fireAttributeChanged(AttributeId.IsAbstract, isAbstract);
    }

    @UaOptional(value="NodeVersion")
    public String getNodeVersion() {
        return this.getProperty(NodeVersion).orElse(null);
    }

    @UaOptional(value="EnumStrings")
    public LocalizedText[] getEnumStrings() {
        return this.getProperty(EnumStrings).orElse(null);
    }

    @UaOptional(value="EnumValues")
    public EnumValueType[] getEnumValues() {
        return this.getProperty(EnumValues).orElse(null);
    }

    public void setNodeVersion(String nodeVersion) {
        this.setProperty(NodeVersion, nodeVersion);
    }

    public void setEnumStrings(LocalizedText[] enumStrings) {
        this.setProperty(EnumStrings, enumStrings);
    }

    public void setEnumValues(EnumValueType[] enumValues) {
        this.setProperty(EnumValues, enumValues);
    }
}

