/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.nodes;

import org.eclipse.milo.opcua.sdk.core.Reference;
import org.eclipse.milo.opcua.sdk.server.api.ServerNodeMap;
import org.eclipse.milo.opcua.sdk.server.nodes.UaNode;
import org.eclipse.milo.opcua.sdk.server.nodes.UaObjectNode;
import org.eclipse.milo.opcua.stack.core.Identifiers;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.enumerated.NodeClass;

public class UaFolderNode
extends UaObjectNode {
    public UaFolderNode(ServerNodeMap nodeMap, NodeId nodeId, QualifiedName browseName, LocalizedText displayName) {
        super(nodeMap, nodeId, browseName, displayName);
        this.addReference(new Reference(this.getNodeId(), Identifiers.HasTypeDefinition, Identifiers.FolderType.expanded(), NodeClass.ObjectType, true));
    }

    public void addOrganizes(UaNode node) {
        this.addReference(new Reference(this.getNodeId(), Identifiers.Organizes, node.getNodeId().expanded(), node.getNodeClass(), true));
        node.addReference(new Reference(node.getNodeId(), Identifiers.Organizes, this.getNodeId().expanded(), this.getNodeClass(), false));
    }

    public void removeOrganizes(UaNode node) {
        this.removeReference(new Reference(this.getNodeId(), Identifiers.Organizes, node.getNodeId().expanded(), node.getNodeClass(), true));
        node.removeReference(new Reference(node.getNodeId(), Identifiers.Organizes, this.getNodeId().expanded(), this.getNodeClass(), false));
    }
}

