/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.services;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import org.eclipse.milo.opcua.sdk.server.DiagnosticsContext;
import org.eclipse.milo.opcua.sdk.server.OpcUaServer;
import org.eclipse.milo.opcua.sdk.server.Session;
import org.eclipse.milo.opcua.sdk.server.api.AttributeHistoryManager;
import org.eclipse.milo.opcua.sdk.server.api.Namespace;
import org.eclipse.milo.opcua.sdk.server.services.ServiceAttributes;
import org.eclipse.milo.opcua.sdk.server.services.ServiceMetric;
import org.eclipse.milo.opcua.sdk.server.util.PendingHistoryRead;
import org.eclipse.milo.opcua.sdk.server.util.PendingHistoryUpdate;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.application.services.AttributeHistoryServiceSet;
import org.eclipse.milo.opcua.stack.core.application.services.ServiceRequest;
import org.eclipse.milo.opcua.stack.core.serialization.UaResponseMessage;
import org.eclipse.milo.opcua.stack.core.types.builtin.DiagnosticInfo;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UShort;
import org.eclipse.milo.opcua.stack.core.types.structured.HistoryReadDetails;
import org.eclipse.milo.opcua.stack.core.types.structured.HistoryReadRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.HistoryReadResponse;
import org.eclipse.milo.opcua.stack.core.types.structured.HistoryReadResult;
import org.eclipse.milo.opcua.stack.core.types.structured.HistoryReadValueId;
import org.eclipse.milo.opcua.stack.core.types.structured.HistoryUpdateDetails;
import org.eclipse.milo.opcua.stack.core.types.structured.HistoryUpdateRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.HistoryUpdateResponse;
import org.eclipse.milo.opcua.stack.core.types.structured.HistoryUpdateResult;
import org.eclipse.milo.opcua.stack.core.types.structured.ResponseHeader;
import org.eclipse.milo.opcua.stack.core.util.ConversionUtil;
import org.eclipse.milo.opcua.stack.core.util.FutureUtils;

public class AttributeHistoryServices
implements AttributeHistoryServiceSet {
    private final ServiceMetric historyReadMetric = new ServiceMetric();
    private final ServiceMetric historyUpdateMetric = new ServiceMetric();

    public void onHistoryRead(ServiceRequest<HistoryReadRequest, HistoryReadResponse> service) {
        this.historyReadMetric.record(service);
        HistoryReadRequest request = (HistoryReadRequest)service.getRequest();
        DiagnosticsContext diagnosticsContext = new DiagnosticsContext();
        OpcUaServer server = (OpcUaServer)service.attr(ServiceAttributes.SERVER_KEY).get();
        Session session = (Session)service.attr(ServiceAttributes.SESSION_KEY).get();
        List nodesToRead = ConversionUtil.l((Object[])request.getNodesToRead());
        if (nodesToRead.isEmpty()) {
            service.setServiceFault(0x800F0000L);
            return;
        }
        if ((long)nodesToRead.size() > server.getConfig().getLimits().getMaxNodesPerRead().longValue()) {
            service.setServiceFault(0x80100000L);
            return;
        }
        if (request.getTimestampsToReturn() == null) {
            service.setServiceFault(2150301696L);
            return;
        }
        ArrayList pendingReads = Lists.newArrayListWithCapacity((int)nodesToRead.size());
        ArrayList futures = Lists.newArrayListWithCapacity((int)nodesToRead.size());
        for (HistoryReadValueId id : nodesToRead) {
            PendingHistoryRead pending2 = new PendingHistoryRead(id);
            pendingReads.add(pending2);
            futures.add(pending2.getFuture());
        }
        Map<UShort, List<PendingHistoryRead>> byNamespace = pendingReads.stream().collect(Collectors.groupingBy(pending -> pending.getInput().getNodeId().getNamespaceIndex()));
        byNamespace.keySet().forEach(index -> {
            List pending = (List)byNamespace.get(index);
            CompletableFuture<List<HistoryReadResult>> future = new CompletableFuture<List<HistoryReadResult>>();
            AttributeHistoryManager.HistoryReadContext context = new AttributeHistoryManager.HistoryReadContext(server, session, future, diagnosticsContext);
            server.getExecutorService().execute(() -> {
                Namespace namespace = server.getNamespaceManager().getNamespace((UShort)index);
                List<HistoryReadValueId> readValueIds = pending.stream().map(PendingHistoryRead::getInput).collect(Collectors.toList());
                namespace.historyRead(context, (HistoryReadDetails)request.getHistoryReadDetails().decode(), request.getTimestampsToReturn(), readValueIds);
            });
            future.thenAccept(values -> {
                for (int i = 0; i < values.size(); ++i) {
                    ((PendingHistoryRead)pending.get(i)).getFuture().complete((HistoryReadResult)values.get(i));
                }
            });
        });
        FutureUtils.sequence((List)futures).thenAcceptAsync(values -> {
            ResponseHeader header = service.createResponseHeader();
            DiagnosticInfo[] diagnosticInfos = diagnosticsContext.getDiagnosticInfos(nodesToRead);
            HistoryReadResponse response = new HistoryReadResponse(header, (HistoryReadResult[])ConversionUtil.a((List)values, HistoryReadResult.class), diagnosticInfos);
            service.setResponse((UaResponseMessage)response);
        }, (Executor)server.getExecutorService());
    }

    public void onHistoryUpdate(ServiceRequest<HistoryUpdateRequest, HistoryUpdateResponse> service) throws UaException {
        this.historyUpdateMetric.record(service);
        HistoryUpdateRequest request = (HistoryUpdateRequest)service.getRequest();
        DiagnosticsContext diagnosticsContext = new DiagnosticsContext();
        OpcUaServer server = (OpcUaServer)service.attr(ServiceAttributes.SERVER_KEY).get();
        Session session = (Session)service.attr(ServiceAttributes.SESSION_KEY).get();
        List nodesToUpdate = ConversionUtil.l((Object[])request.getHistoryUpdateDetails()).stream().map(e -> (HistoryUpdateDetails)e.decode()).collect(Collectors.toList());
        if (nodesToUpdate.isEmpty()) {
            service.setServiceFault(0x800F0000L);
            return;
        }
        if (nodesToUpdate.size() > server.getConfig().getLimits().getMaxNodesPerWrite().intValue()) {
            service.setServiceFault(0x80100000L);
            return;
        }
        ArrayList pendingUpdates = Lists.newArrayListWithCapacity((int)nodesToUpdate.size());
        ArrayList futures = Lists.newArrayListWithCapacity((int)nodesToUpdate.size());
        for (HistoryUpdateDetails details : nodesToUpdate) {
            PendingHistoryUpdate pending2 = new PendingHistoryUpdate(details);
            pendingUpdates.add(pending2);
            futures.add(pending2.getFuture());
        }
        Map<UShort, List<PendingHistoryUpdate>> byNamespace = pendingUpdates.stream().collect(Collectors.groupingBy(pending -> pending.getInput().getNodeId().getNamespaceIndex()));
        byNamespace.keySet().forEach(index -> {
            List pending = (List)byNamespace.get(index);
            CompletableFuture<List<HistoryUpdateResult>> future = new CompletableFuture<List<HistoryUpdateResult>>();
            AttributeHistoryManager.HistoryUpdateContext context = new AttributeHistoryManager.HistoryUpdateContext(server, session, future, diagnosticsContext);
            server.getExecutorService().execute(() -> {
                Namespace namespace = server.getNamespaceManager().getNamespace((UShort)index);
                List<HistoryUpdateDetails> updateDetails = pending.stream().map(PendingHistoryUpdate::getInput).collect(Collectors.toList());
                namespace.historyUpdate(context, updateDetails);
            });
            future.thenAccept(statusCodes -> {
                for (int i = 0; i < statusCodes.size(); ++i) {
                    ((PendingHistoryUpdate)pending.get(i)).getFuture().complete((HistoryUpdateResult)statusCodes.get(i));
                }
            });
        });
        FutureUtils.sequence((List)futures).thenAcceptAsync(values -> {
            ResponseHeader header = service.createResponseHeader();
            DiagnosticInfo[] diagnosticInfos = diagnosticsContext.getDiagnosticInfos(nodesToUpdate);
            HistoryUpdateResponse response = new HistoryUpdateResponse(header, (HistoryUpdateResult[])ConversionUtil.a((List)values, HistoryUpdateResult.class), diagnosticInfos);
            service.setResponse((UaResponseMessage)response);
        }, (Executor)server.getExecutorService());
    }
}

