/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.util;

import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import org.eclipse.milo.opcua.sdk.core.AccessLevel;
import org.eclipse.milo.opcua.sdk.core.NumericRange;
import org.eclipse.milo.opcua.sdk.core.util.StreamUtil;
import org.eclipse.milo.opcua.sdk.server.api.ServerNodeMap;
import org.eclipse.milo.opcua.sdk.server.api.nodes.VariableNode;
import org.eclipse.milo.opcua.sdk.server.api.nodes.VariableTypeNode;
import org.eclipse.milo.opcua.sdk.server.nodes.AttributeContext;
import org.eclipse.milo.opcua.sdk.server.nodes.ServerNode;
import org.eclipse.milo.opcua.sdk.server.util.AttributeUtil;
import org.eclipse.milo.opcua.stack.core.AttributeId;
import org.eclipse.milo.opcua.stack.core.Identifiers;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;
import org.eclipse.milo.opcua.stack.core.types.enumerated.NodeClass;
import org.eclipse.milo.opcua.stack.core.types.enumerated.TimestampsToReturn;

public class AttributeReader {
    private static QualifiedName ENCODING_DEFAULT_BINARY = new QualifiedName(0, "DefaultBinary");
    private static QualifiedName ENCODING_DEFAULT_XML = new QualifiedName(0, "DefaultXML");

    public static DataValue readAttribute(AttributeContext context, ServerNode node, AttributeId attributeId, @Nullable TimestampsToReturn timestamps, @Nullable String indexRange, @Nullable QualifiedName dataEncoding) {
        try {
            AttributeContext internalContext = new AttributeContext(context.getServer());
            NodeClass nodeClass = node.getNodeClass();
            if (attributeId == AttributeId.Value && nodeClass == NodeClass.Variable) {
                Set<AccessLevel> accessLevels = AttributeUtil.getAccessLevels(node, internalContext);
                if (!accessLevels.contains(AccessLevel.CurrentRead)) {
                    throw new UaException(2151284736L);
                }
                Set<AccessLevel> userAccessLevels = AttributeUtil.getUserAccessLevels(node, context);
                if (!userAccessLevels.contains(AccessLevel.CurrentRead)) {
                    throw new UaException(2149515264L);
                }
            }
            if (dataEncoding != null && dataEncoding.isNotNull()) {
                NodeId dataTypeId;
                if (attributeId != AttributeId.Value) {
                    throw new UaException(0x80380000L);
                }
                if (node instanceof VariableNode) {
                    dataTypeId = ((VariableNode)((Object)node)).getDataType();
                } else if (node instanceof VariableTypeNode) {
                    dataTypeId = ((VariableTypeNode)((Object)node)).getDataType();
                } else {
                    throw new UaException(0x80380000L);
                }
                boolean structured = AttributeReader.isStructureSubtype(context.getServer().getNodeMap(), dataTypeId);
                if (!structured) {
                    throw new UaException(0x80380000L);
                }
                if (!dataEncoding.equals((Object)ENCODING_DEFAULT_BINARY)) {
                    throw new UaException(2151219200L);
                }
            }
            DataValue value = node.getAttribute(context, attributeId);
            if (indexRange != null) {
                NumericRange range = NumericRange.parse((String)indexRange);
                Object valueAtRange = NumericRange.readFromValueAtRange((Variant)value.getValue(), (NumericRange)range);
                value = new DataValue(new Variant(valueAtRange), value.getStatusCode(), value.getSourceTime(), value.getServerTime());
            }
            if (timestamps != null) {
                value = attributeId == AttributeId.Value ? DataValue.derivedValue((DataValue)value, (TimestampsToReturn)timestamps) : DataValue.derivedNonValue((DataValue)value, (TimestampsToReturn)timestamps);
            }
            return value;
        }
        catch (UaException e) {
            return new DataValue(e.getStatusCode());
        }
    }

    private static boolean isStructureSubtype(ServerNodeMap nodeMap, NodeId dataTypeId) {
        ServerNode dataTypeNode = (ServerNode)nodeMap.get(dataTypeId);
        Optional superTypeId = dataTypeNode.getReferences().stream().filter(r -> r.getReferenceTypeId().equals((Object)Identifiers.HasSubtype) && r.isInverse() && r.getTargetNodeClass() == NodeClass.DataType).flatMap(r -> StreamUtil.opt2stream((Optional)r.getTargetNodeId().local())).findFirst();
        return superTypeId.map(id -> id.equals((Object)Identifiers.Structure) || AttributeReader.isStructureSubtype(nodeMap, id)).orElse(false);
    }
}

