/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.util;

import java.util.Set;
import java.util.function.Supplier;
import org.eclipse.milo.opcua.sdk.core.AccessLevel;
import org.eclipse.milo.opcua.sdk.core.WriteMask;
import org.eclipse.milo.opcua.sdk.server.nodes.AttributeContext;
import org.eclipse.milo.opcua.sdk.server.nodes.ServerNode;
import org.eclipse.milo.opcua.stack.core.AttributeId;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.DateTime;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UByte;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;

public class AttributeUtil {
    public static final Supplier<UaException> ATTRIBUTE_ID_INVALID_EXCEPTION = () -> new UaException(2150957056L);

    public static DataValue dv(Object o) {
        return new DataValue(new Variant(o), StatusCode.GOOD, null, DateTime.now());
    }

    public static <T> T extract(DataValue value) throws UaException {
        Variant variant = value.getValue();
        if (variant == null) {
            return null;
        }
        Object o = variant.getValue();
        if (o == null) {
            return null;
        }
        try {
            return (T)o;
        }
        catch (ClassCastException e) {
            throw new UaException(2155085824L);
        }
    }

    public static Set<AccessLevel> getAccessLevels(ServerNode node, AttributeContext context) throws UaException {
        UByte accessLevel = (UByte)AttributeUtil.extract(node.getAttribute(context, AttributeId.AccessLevel));
        return AccessLevel.fromMask((UByte)accessLevel);
    }

    public static Set<AccessLevel> getUserAccessLevels(ServerNode node, AttributeContext context) throws UaException {
        UByte userAccessLevel = (UByte)AttributeUtil.extract(node.getAttribute(context, AttributeId.UserAccessLevel));
        return AccessLevel.fromMask((UByte)userAccessLevel);
    }

    public static Set<WriteMask> getWriteMasks(ServerNode node, AttributeContext internalContext) throws UaException {
        UInteger writeMask = (UInteger)AttributeUtil.extract(node.getAttribute(internalContext, AttributeId.WriteMask));
        return WriteMask.fromMask((UInteger)writeMask);
    }

    public static Set<WriteMask> getUserWriteMasks(ServerNode node, AttributeContext internalContext) throws UaException {
        UInteger userWriteMask = (UInteger)AttributeUtil.extract(node.getAttribute(internalContext, AttributeId.UserWriteMask));
        return WriteMask.fromMask((UInteger)userWriteMask);
    }
}

