/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.api;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;
import org.eclipse.milo.opcua.sdk.server.DiagnosticsContext;
import org.eclipse.milo.opcua.sdk.server.OpcUaServer;
import org.eclipse.milo.opcua.sdk.server.Session;
import org.eclipse.milo.opcua.sdk.server.api.OperationContext;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.enumerated.TimestampsToReturn;
import org.eclipse.milo.opcua.stack.core.types.structured.HistoryReadDetails;
import org.eclipse.milo.opcua.stack.core.types.structured.HistoryReadResult;
import org.eclipse.milo.opcua.stack.core.types.structured.HistoryReadValueId;
import org.eclipse.milo.opcua.stack.core.types.structured.HistoryUpdateDetails;
import org.eclipse.milo.opcua.stack.core.types.structured.HistoryUpdateResult;

public interface AttributeHistoryManager {
    default public void historyRead(HistoryReadContext context, HistoryReadDetails readDetails, TimestampsToReturn timestamps, List<HistoryReadValueId> readValueIds) {
        ArrayList results = Lists.newArrayListWithCapacity((int)readValueIds.size());
        for (HistoryReadValueId readValueId : readValueIds) {
            results.add(new HistoryReadResult(new StatusCode(2151481344L), null, null));
        }
        context.complete(results);
    }

    default public void historyUpdate(HistoryUpdateContext context, List<HistoryUpdateDetails> updateDetails) {
        ArrayList results = Lists.newArrayListWithCapacity((int)updateDetails.size());
        for (HistoryUpdateDetails details : updateDetails) {
            results.add(new HistoryUpdateResult(new StatusCode(2151481344L), null, null));
        }
        context.complete(results);
    }

    public static final class HistoryUpdateContext
    extends OperationContext<HistoryUpdateDetails, HistoryUpdateResult> {
        public HistoryUpdateContext(OpcUaServer server, @Nullable Session session, DiagnosticsContext<HistoryUpdateDetails> diagnosticsContext) {
            super(server, session, diagnosticsContext);
        }

        public HistoryUpdateContext(OpcUaServer server, @Nullable Session session, CompletableFuture<List<HistoryUpdateResult>> future, DiagnosticsContext<HistoryUpdateDetails> diagnosticsContext) {
            super(server, session, future, diagnosticsContext);
        }
    }

    public static final class HistoryReadContext
    extends OperationContext<HistoryReadValueId, HistoryReadResult> {
        public HistoryReadContext(OpcUaServer server, @Nullable Session session, DiagnosticsContext<HistoryReadValueId> diagnosticsContext) {
            super(server, session, diagnosticsContext);
        }

        public HistoryReadContext(OpcUaServer server, @Nullable Session session, CompletableFuture<List<HistoryReadResult>> future, DiagnosticsContext<HistoryReadValueId> diagnosticsContext) {
            super(server, session, future, diagnosticsContext);
        }
    }
}

