/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.api.config;

import java.util.concurrent.TimeUnit;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UShort;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.Unsigned;

public interface OpcUaServerConfigLimits {
    default public UInteger getMaxSessionCount() {
        return Unsigned.uint((int)100);
    }

    default public Double getMinPublishingInterval() {
        return 10.0;
    }

    default public Double getMaxPublishingInterval() {
        return TimeUnit.MILLISECONDS.convert(8L, TimeUnit.HOURS);
    }

    default public Double getDefaultPublishingInterval() {
        return 250.0;
    }

    default public Double getMinSubscriptionLifetime() {
        return 10000.0;
    }

    default public Double getMaxSubscriptionLifetime() {
        return TimeUnit.MILLISECONDS.convert(24L, TimeUnit.HOURS);
    }

    default public Double getMaxSupportedSampleRate() {
        return TimeUnit.MILLISECONDS.convert(24L, TimeUnit.HOURS);
    }

    default public Double getMinSupportedSampleRate() {
        return 0.0;
    }

    default public UInteger getMaxArrayLength() {
        return Unsigned.uint((int)0x200000);
    }

    default public UInteger getMaxStringLength() {
        return Unsigned.uint((int)0x200000);
    }

    default public UInteger getMaxByteStringLength() {
        return Unsigned.uint((int)0x200000);
    }

    default public UShort getMaxBrowseContinuationPoints() {
        return Unsigned.ushort((int)250);
    }

    default public UShort getMaxQueryContinuationPoints() {
        return Unsigned.ushort((int)250);
    }

    default public UShort getMaxHistoryContinuationPoints() {
        return Unsigned.ushort((int)250);
    }

    default public UInteger getMaxNodesPerRead() {
        return Unsigned.uint((int)10000);
    }

    default public UInteger getMaxNodesPerWrite() {
        return Unsigned.uint((int)10000);
    }

    default public UInteger getMaxMonitoredItemsPerCall() {
        return Unsigned.uint((int)10000);
    }

    default public UInteger getMaxNodesPerRegisterNodes() {
        return Unsigned.uint((int)250);
    }

    default public UInteger getMaxNodesPerHistoryReadData() {
        return Unsigned.uint((int)250);
    }

    default public UInteger getMaxNodesPerHistoryReadEvents() {
        return Unsigned.uint((int)250);
    }

    default public UInteger getMaxNodesPerHistoryUpdateData() {
        return Unsigned.uint((int)250);
    }

    default public UInteger getMaxNodesPerHistoryUpdateEvents() {
        return Unsigned.uint((int)250);
    }

    default public UInteger getMaxNodesPerMethodCall() {
        return Unsigned.uint((int)250);
    }

    default public UInteger getMaxNodesPerBrowse() {
        return Unsigned.uint((int)250);
    }

    default public UInteger getMaxNodesPerTranslateBrowsePathsToNodeIds() {
        return Unsigned.uint((int)250);
    }

    default public UInteger getMaxNodesPerNodeManagement() {
        return Unsigned.uint((int)250);
    }
}

