/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.identity;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import javax.crypto.Cipher;
import org.eclipse.milo.opcua.sdk.server.Session;
import org.eclipse.milo.opcua.sdk.server.identity.IdentityValidator;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.channel.SecureChannel;
import org.eclipse.milo.opcua.stack.core.security.SecurityAlgorithm;
import org.eclipse.milo.opcua.stack.core.types.builtin.ByteString;
import org.eclipse.milo.opcua.stack.core.types.structured.AnonymousIdentityToken;
import org.eclipse.milo.opcua.stack.core.types.structured.IssuedIdentityToken;
import org.eclipse.milo.opcua.stack.core.types.structured.SignatureData;
import org.eclipse.milo.opcua.stack.core.types.structured.UserIdentityToken;
import org.eclipse.milo.opcua.stack.core.types.structured.UserNameIdentityToken;
import org.eclipse.milo.opcua.stack.core.types.structured.UserTokenPolicy;
import org.eclipse.milo.opcua.stack.core.types.structured.X509IdentityToken;
import org.eclipse.milo.opcua.stack.core.util.CertificateUtil;
import org.eclipse.milo.opcua.stack.core.util.DigestUtil;

public abstract class AbstractIdentityValidator
implements IdentityValidator {
    @Override
    public Object validateIdentityToken(Session session, UserIdentityToken token, UserTokenPolicy tokenPolicy, SignatureData tokenSignature) throws UaException {
        if (token instanceof AnonymousIdentityToken) {
            return this.validateAnonymousToken(session, (AnonymousIdentityToken)token, tokenPolicy, tokenSignature);
        }
        if (token instanceof UserNameIdentityToken) {
            return this.validateUsernameToken(session, (UserNameIdentityToken)token, tokenPolicy, tokenSignature);
        }
        if (token instanceof X509IdentityToken) {
            return this.validateX509Token(session, (X509IdentityToken)token, tokenPolicy, tokenSignature);
        }
        if (token instanceof IssuedIdentityToken) {
            return this.validateIssuedIdentityToken(session, (IssuedIdentityToken)token, tokenPolicy, tokenSignature);
        }
        throw new UaException(0x80200000L);
    }

    protected Object validateAnonymousToken(Session session, AnonymousIdentityToken token, UserTokenPolicy tokenPolicy, SignatureData tokenSignature) throws UaException {
        throw new UaException(0x80200000L);
    }

    protected Object validateUsernameToken(Session session, UserNameIdentityToken token, UserTokenPolicy tokenPolicy, SignatureData tokenSignature) throws UaException {
        throw new UaException(0x80200000L);
    }

    protected Object validateX509Token(Session session, X509IdentityToken token, UserTokenPolicy tokenPolicy, SignatureData tokenSignature) throws UaException {
        throw new UaException(0x80200000L);
    }

    protected Object validateIssuedIdentityToken(Session session, IssuedIdentityToken token, UserTokenPolicy tokenPolicy, SignatureData tokenSignature) throws UaException {
        throw new UaException(0x80200000L);
    }

    protected byte[] decryptTokenData(Session session, SecurityAlgorithm algorithm, byte[] dataBytes) throws UaException {
        X509Certificate certificate = CertificateUtil.decodeCertificate((byte[])session.getEndpoint().getServerCertificate().bytesOrEmpty());
        int cipherTextBlockSize = SecureChannel.getAsymmetricCipherTextBlockSize((Certificate)certificate, (SecurityAlgorithm)algorithm);
        int blockCount = dataBytes.length / cipherTextBlockSize;
        int plainTextBufferSize = cipherTextBlockSize * blockCount;
        byte[] plainTextBytes = new byte[plainTextBufferSize];
        ByteBuffer plainTextNioBuffer = ByteBuffer.wrap(plainTextBytes);
        ByteBuffer passwordNioBuffer = ByteBuffer.wrap(dataBytes);
        try {
            KeyPair keyPair = (KeyPair)session.getServer().getConfig().getCertificateManager().getKeyPair(ByteString.of((byte[])DigestUtil.sha1((byte[])certificate.getEncoded()))).orElseThrow(() -> new UaException(2148728832L));
            Cipher cipher = this.getCipher(algorithm, keyPair);
            for (int blockNumber = 0; blockNumber < blockCount; ++blockNumber) {
                ((Buffer)passwordNioBuffer).limit(passwordNioBuffer.position() + cipherTextBlockSize);
                cipher.doFinal(passwordNioBuffer, plainTextNioBuffer);
            }
        }
        catch (GeneralSecurityException e) {
            throw new UaException(2148728832L, (Throwable)e);
        }
        return plainTextBytes;
    }

    private Cipher getCipher(SecurityAlgorithm algorithm, KeyPair keyPair) throws UaException {
        try {
            String transformation = algorithm.getTransformation();
            Cipher cipher = Cipher.getInstance(transformation);
            cipher.init(2, keyPair.getPrivate());
            return cipher;
        }
        catch (GeneralSecurityException e) {
            throw new UaException(2148728832L, (Throwable)e);
        }
    }
}

