/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.services;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.eclipse.milo.opcua.sdk.server.OpcUaServer;
import org.eclipse.milo.opcua.sdk.server.Session;
import org.eclipse.milo.opcua.sdk.server.items.MonitoredDataItem;
import org.eclipse.milo.opcua.sdk.server.services.ServiceAttributes;
import org.eclipse.milo.opcua.sdk.server.subscriptions.Subscription;
import org.eclipse.milo.opcua.sdk.server.subscriptions.SubscriptionManager;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.serialization.UaResponseMessage;
import org.eclipse.milo.opcua.stack.core.types.builtin.DiagnosticInfo;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.structured.TransferResult;
import org.eclipse.milo.opcua.stack.core.types.structured.TransferSubscriptionsRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.TransferSubscriptionsResponse;
import org.eclipse.milo.opcua.stack.core.util.ConversionUtil;
import org.eclipse.milo.opcua.stack.server.services.ServiceRequest;
import org.eclipse.milo.opcua.stack.server.services.SubscriptionServiceSet;

public class DefaultSubscriptionServiceSet
implements SubscriptionServiceSet {
    private final SubscriptionManager subscriptionManager;

    public DefaultSubscriptionServiceSet(SubscriptionManager subscriptionManager) {
        this.subscriptionManager = subscriptionManager;
    }

    public void onCreateSubscription(ServiceRequest service) {
        this.subscriptionManager.createSubscription(service);
    }

    public void onModifySubscription(ServiceRequest service) throws UaException {
        this.subscriptionManager.modifySubscription(service);
    }

    public void onDeleteSubscriptions(ServiceRequest service) throws UaException {
        this.subscriptionManager.deleteSubscription(service);
    }

    public void onSetPublishingMode(ServiceRequest service) {
        this.subscriptionManager.setPublishingMode(service);
    }

    public void onPublish(ServiceRequest service) {
        this.subscriptionManager.publish(service);
    }

    public void onRepublish(ServiceRequest service) {
        this.subscriptionManager.republish(service);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onTransferSubscriptions(ServiceRequest service) throws UaException {
        TransferSubscriptionsRequest request = (TransferSubscriptionsRequest)service.getRequest();
        OpcUaServer server = (OpcUaServer)service.attr(ServiceAttributes.SERVER_KEY).get();
        Session session = (Session)service.attr(ServiceAttributes.SESSION_KEY).get();
        List subscriptionIds = ConversionUtil.l((Object[])request.getSubscriptionIds());
        if (subscriptionIds.isEmpty()) {
            throw new UaException(0x800F0000L);
        }
        ArrayList results = Lists.newArrayList();
        for (UInteger subscriptionId : subscriptionIds) {
            UInteger[] availableSequenceNumbers;
            Subscription subscription = server.getSubscriptions().get(subscriptionId);
            if (subscription == null) {
                results.add(new TransferResult(new StatusCode(0x80280000L), new UInteger[0]));
                continue;
            }
            Session otherSession = subscription.getSession();
            if (!this.sessionsHaveSameUser(session, otherSession)) {
                results.add(new TransferResult(new StatusCode(2149515264L), new UInteger[0]));
                continue;
            }
            Subscription subscription2 = subscription;
            synchronized (subscription2) {
                otherSession.getSubscriptionManager().sendStatusChangeNotification(subscription);
                otherSession.getSubscriptionManager().removeSubscription(subscriptionId);
                subscription.setSubscriptionManager(session.getSubscriptionManager());
                this.subscriptionManager.addSubscription(subscription);
                availableSequenceNumbers = subscription.getAvailableSequenceNumbers();
                if (request.getSendInitialValues().booleanValue()) {
                    subscription.getMonitoredItems().values().stream().filter(item -> item instanceof MonitoredDataItem).map(item -> (MonitoredDataItem)item).forEach(MonitoredDataItem::clearLastValue);
                }
            }
            results.add(new TransferResult(StatusCode.GOOD, availableSequenceNumbers));
        }
        TransferSubscriptionsResponse response = new TransferSubscriptionsResponse(service.createResponseHeader(), (TransferResult[])ConversionUtil.a((List)results, TransferResult.class), new DiagnosticInfo[0]);
        service.setResponse((UaResponseMessage)response);
    }

    private boolean sessionsHaveSameUser(Session s1, Session s2) {
        Object identity1 = s1.getIdentityObject();
        Object identity2 = s2.getIdentityObject();
        return Objects.equals(identity1, identity2);
    }
}

