/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.events.conversions;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.eclipse.milo.opcua.stack.core.BuiltinDataType;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UByte;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.ULong;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UShort;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.Unsigned;

final class Int32Conversions {
    private Int32Conversions() {
    }

    @Nonnull
    static Boolean int32ToBoolean(@Nonnull Integer i) {
        return i != 0;
    }

    @Nullable
    static UByte int32ToByte(@Nonnull Integer i) {
        if (i >= 0 && i <= 255) {
            return Unsigned.ubyte((int)i);
        }
        return null;
    }

    @Nonnull
    static Double int32ToDouble(@Nonnull Integer i) {
        return i.doubleValue();
    }

    @Nonnull
    static Float int32ToFloat(@Nonnull Integer i) {
        return Float.valueOf(i.floatValue());
    }

    @Nullable
    static Short int32ToInt16(@Nonnull Integer i) {
        if (i >= Short.MIN_VALUE && i <= Short.MAX_VALUE) {
            return i.shortValue();
        }
        return null;
    }

    @Nonnull
    static Long int32ToInt64(@Nonnull Integer i) {
        return i.longValue();
    }

    @Nullable
    static Byte int32ToSByte(@Nonnull Integer i) {
        if (i >= -128 && i <= 127) {
            return i.byteValue();
        }
        return null;
    }

    @Nonnull
    static StatusCode int32ToStatusCode(@Nonnull Integer i) {
        return new StatusCode(i.intValue());
    }

    @Nonnull
    static String int32ToString(@Nonnull Integer i) {
        return i.toString();
    }

    @Nullable
    static UShort int32ToUInt16(@Nonnull Integer i) {
        if (i >= 0 && i <= 65535) {
            return Unsigned.ushort((int)i);
        }
        return null;
    }

    @Nullable
    static UInteger int32ToUInt32(@Nonnull Integer i) {
        if (i >= 0) {
            return Unsigned.uint((int)i);
        }
        return null;
    }

    @Nullable
    static ULong int32ToUInt64(@Nonnull Integer i) {
        if (i >= 0) {
            return Unsigned.ulong((long)i.intValue());
        }
        return null;
    }

    @Nullable
    static Object convert(@Nullable Object o, BuiltinDataType targetType, boolean implicit) {
        if (o instanceof Integer) {
            Integer i = (Integer)o;
            return implicit ? Int32Conversions.implicitConversion(i, targetType) : Int32Conversions.explicitConversion(i, targetType);
        }
        return null;
    }

    @Nullable
    static Object explicitConversion(@Nonnull Integer i, BuiltinDataType targetType) {
        switch (targetType) {
            case Boolean: {
                return Int32Conversions.int32ToBoolean(i);
            }
            case Byte: {
                return Int32Conversions.int32ToByte(i);
            }
            case Int16: {
                return Int32Conversions.int32ToInt16(i);
            }
            case SByte: {
                return Int32Conversions.int32ToSByte(i);
            }
            case StatusCode: {
                return Int32Conversions.int32ToStatusCode(i);
            }
            case String: {
                return Int32Conversions.int32ToString(i);
            }
            case UInt16: {
                return Int32Conversions.int32ToUInt16(i);
            }
            case UInt32: {
                return Int32Conversions.int32ToUInt32(i);
            }
        }
        return Int32Conversions.implicitConversion(i, targetType);
    }

    @Nullable
    static Object implicitConversion(@Nonnull Integer i, BuiltinDataType targetType) {
        switch (targetType) {
            case Double: {
                return Int32Conversions.int32ToDouble(i);
            }
            case Float: {
                return Int32Conversions.int32ToFloat(i);
            }
            case Int64: {
                return Int32Conversions.int32ToInt64(i);
            }
            case UInt64: {
                return Int32Conversions.int32ToUInt64(i);
            }
        }
        return null;
    }
}

