/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.items;

import com.google.common.primitives.Ints;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.milo.opcua.sdk.server.OpcUaServer;
import org.eclipse.milo.opcua.sdk.server.Session;
import org.eclipse.milo.opcua.sdk.server.api.MonitoredItem;
import org.eclipse.milo.opcua.sdk.server.util.RingBuffer;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.serialization.UaStructure;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExtensionObject;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.enumerated.MonitoringMode;
import org.eclipse.milo.opcua.stack.core.types.enumerated.TimestampsToReturn;
import org.eclipse.milo.opcua.stack.core.types.structured.ReadValueId;

public abstract class BaseMonitoredItem<T>
implements MonitoredItem {
    private static final int MAX_QUEUE_SIZE = 65535;
    protected volatile Map<UInteger, BaseMonitoredItem<?>> triggeredItems;
    protected volatile boolean triggered = false;
    protected volatile RingBuffer<T> queue;
    protected volatile long clientHandle;
    protected volatile int queueSize;
    protected volatile double samplingInterval;
    protected volatile boolean discardOldest;
    protected final OpcUaServer server;
    protected volatile Session session;
    protected final UInteger id;
    protected final UInteger subscriptionId;
    protected final ReadValueId readValueId;
    protected volatile MonitoringMode monitoringMode;
    protected volatile TimestampsToReturn timestamps;

    protected BaseMonitoredItem(OpcUaServer server, Session session, UInteger id, UInteger subscriptionId, ReadValueId readValueId, MonitoringMode monitoringMode, TimestampsToReturn timestamps, UInteger clientHandle, double samplingInterval, UInteger queueSize, boolean discardOldest) {
        this.server = server;
        this.session = session;
        this.id = id;
        this.subscriptionId = subscriptionId;
        this.readValueId = readValueId;
        this.monitoringMode = monitoringMode;
        this.timestamps = timestamps;
        this.clientHandle = clientHandle.longValue();
        this.samplingInterval = samplingInterval;
        this.discardOldest = discardOldest;
        this.setQueueSize(queueSize);
        this.queue = new RingBuffer(this.queueSize);
    }

    protected void setQueueSize(UInteger queueSize) {
        int qs = Ints.saturatedCast((long)queueSize.longValue());
        qs = Math.min(qs, 65535);
        this.queueSize = qs = Math.max(qs, 1);
    }

    public synchronized boolean getNotifications(List<UaStructure> notifications, int max) {
        int queueSize = this.queue.size();
        int count = Math.min(queueSize, max);
        for (int i = 0; i < count; ++i) {
            notifications.add(this.wrapQueueValue(this.queue.remove()));
        }
        boolean queueIsEmpty = this.queue.isEmpty();
        if (queueIsEmpty && this.triggered) {
            this.triggered = false;
        }
        return queueIsEmpty;
    }

    public synchronized boolean hasNotifications() {
        return this.queue.size() > 0 && this.monitoringMode == MonitoringMode.Reporting;
    }

    public synchronized void modify(TimestampsToReturn timestamps, UInteger clientHandle, double samplingInterval, ExtensionObject filter, UInteger queueSize, boolean discardOldest) throws UaException {
        this.installFilter(filter);
        this.timestamps = timestamps;
        this.clientHandle = clientHandle.longValue();
        this.samplingInterval = samplingInterval;
        this.discardOldest = discardOldest;
        if (queueSize.intValue() != this.queueSize) {
            this.setQueueSize(queueSize);
            RingBuffer<T> oldQueue = this.queue;
            this.queue = new RingBuffer(this.queueSize);
            while (oldQueue.size() > 0) {
                this.enqueue(oldQueue.remove());
            }
        }
    }

    protected abstract void enqueue(T var1);

    public void setMonitoringMode(MonitoringMode monitoringMode) {
        this.monitoringMode = monitoringMode;
        if (monitoringMode == MonitoringMode.Disabled) {
            this.queue.clear();
        }
    }

    public Session getSession() {
        return this.session;
    }

    public void setSession(Session session) {
        this.session = session;
    }

    @Override
    public UInteger getId() {
        return this.id;
    }

    @Override
    public UInteger getSubscriptionId() {
        return this.subscriptionId;
    }

    @Override
    public ReadValueId getReadValueId() {
        return this.readValueId;
    }

    @Override
    public TimestampsToReturn getTimestampsToReturn() {
        return this.timestamps;
    }

    public long getClientHandle() {
        return this.clientHandle;
    }

    public int getQueueSize() {
        return this.queueSize;
    }

    public double getSamplingInterval() {
        return this.samplingInterval;
    }

    public boolean isDiscardOldest() {
        return this.discardOldest;
    }

    public MonitoringMode getMonitoringMode() {
        return this.monitoringMode;
    }

    public synchronized Map<UInteger, BaseMonitoredItem<?>> getTriggeredItems() {
        if (this.triggeredItems == null) {
            this.triggeredItems = new HashMap();
        }
        return this.triggeredItems;
    }

    public synchronized boolean isTriggered() {
        return this.triggered;
    }

    public abstract ExtensionObject getFilterResult();

    protected abstract void installFilter(ExtensionObject var1) throws UaException;

    protected abstract UaStructure wrapQueueValue(T var1);
}

