/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.model.nodes.objects;

import java.util.Optional;
import org.eclipse.milo.opcua.sdk.core.Reference;
import org.eclipse.milo.opcua.sdk.server.api.nodes.VariableNode;
import org.eclipse.milo.opcua.sdk.server.model.nodes.objects.ConditionNode;
import org.eclipse.milo.opcua.sdk.server.model.nodes.variables.TwoStateVariableNode;
import org.eclipse.milo.opcua.sdk.server.model.types.objects.AcknowledgeableConditionType;
import org.eclipse.milo.opcua.sdk.server.nodes.UaMethodNode;
import org.eclipse.milo.opcua.sdk.server.nodes.UaNode;
import org.eclipse.milo.opcua.sdk.server.nodes.UaNodeContext;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UByte;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;

public class AcknowledgeableConditionNode
extends ConditionNode
implements AcknowledgeableConditionType {
    public AcknowledgeableConditionNode(UaNodeContext context, NodeId nodeId, QualifiedName browseName, LocalizedText displayName, LocalizedText description, UInteger writeMask, UInteger userWriteMask) {
        super(context, nodeId, browseName, displayName, description, writeMask, userWriteMask);
    }

    public AcknowledgeableConditionNode(UaNodeContext context, NodeId nodeId, QualifiedName browseName, LocalizedText displayName, LocalizedText description, UInteger writeMask, UInteger userWriteMask, UByte eventNotifier) {
        super(context, nodeId, browseName, displayName, description, writeMask, userWriteMask, eventNotifier);
    }

    @Override
    public TwoStateVariableNode getEnabledStateNode() {
        Optional<VariableNode> component = this.getVariableComponent("http://opcfoundation.org/UA/", "EnabledState");
        return component.orElse(null);
    }

    @Override
    public LocalizedText getEnabledState() {
        Optional<VariableNode> component = this.getVariableComponent("EnabledState");
        return component.map(node -> (LocalizedText)node.getValue().getValue().getValue()).orElse(null);
    }

    @Override
    public void setEnabledState(LocalizedText value) {
        this.getVariableComponent("EnabledState").ifPresent(n -> n.setValue(new DataValue(new Variant((Object)value))));
    }

    @Override
    public UaMethodNode getConfirmMethodNode() {
        Optional<UaNode> methodNode = this.findNode("http://opcfoundation.org/UA/", "Confirm", node -> node instanceof UaMethodNode, Reference.HAS_COMPONENT_PREDICATE);
        return methodNode.orElse(null);
    }

    @Override
    public UaMethodNode getAcknowledgeMethodNode() {
        Optional<UaNode> methodNode = this.findNode("http://opcfoundation.org/UA/", "Acknowledge", node -> node instanceof UaMethodNode, Reference.HAS_COMPONENT_PREDICATE);
        return methodNode.orElse(null);
    }

    @Override
    public TwoStateVariableNode getConfirmedStateNode() {
        Optional<VariableNode> component = this.getVariableComponent("http://opcfoundation.org/UA/", "ConfirmedState");
        return component.orElse(null);
    }

    @Override
    public LocalizedText getConfirmedState() {
        Optional<VariableNode> component = this.getVariableComponent("ConfirmedState");
        return component.map(node -> (LocalizedText)node.getValue().getValue().getValue()).orElse(null);
    }

    @Override
    public void setConfirmedState(LocalizedText value) {
        this.getVariableComponent("ConfirmedState").ifPresent(n -> n.setValue(new DataValue(new Variant((Object)value))));
    }

    @Override
    public TwoStateVariableNode getAckedStateNode() {
        Optional<VariableNode> component = this.getVariableComponent("http://opcfoundation.org/UA/", "AckedState");
        return component.orElse(null);
    }

    @Override
    public LocalizedText getAckedState() {
        Optional<VariableNode> component = this.getVariableComponent("AckedState");
        return component.map(node -> (LocalizedText)node.getValue().getValue().getValue()).orElse(null);
    }

    @Override
    public void setAckedState(LocalizedText value) {
        this.getVariableComponent("AckedState").ifPresent(n -> n.setValue(new DataValue(new Variant((Object)value))));
    }
}

