/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.api;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.MapMaker;
import com.google.common.collect.Multimaps;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.eclipse.milo.opcua.sdk.core.Reference;
import org.eclipse.milo.opcua.sdk.server.api.NodeManager;
import org.eclipse.milo.opcua.sdk.server.api.nodes.Node;
import org.eclipse.milo.opcua.stack.core.NamespaceTable;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;

public class AbstractNodeManager<T extends Node>
implements NodeManager<T> {
    private final ConcurrentMap<NodeId, T> nodeMap = this.makeNodeMap(new MapMaker());
    private final ListMultimap<NodeId, Reference> referenceMultimap = Multimaps.synchronizedListMultimap((ListMultimap)ArrayListMultimap.create());

    protected ConcurrentMap<NodeId, T> makeNodeMap(MapMaker mapMaker) {
        return mapMaker.makeMap();
    }

    protected ConcurrentMap<NodeId, T> getNodeMap() {
        return this.nodeMap;
    }

    protected ListMultimap<NodeId, Reference> getReferenceMultimap() {
        return this.referenceMultimap;
    }

    @Override
    public boolean containsNode(NodeId nodeId) {
        return this.nodeMap.containsKey(nodeId);
    }

    @Override
    public boolean containsNode(ExpandedNodeId nodeId, NamespaceTable namespaceTable) {
        return nodeId.local(namespaceTable).map(this::containsNode).orElse(false);
    }

    @Override
    public Optional<T> addNode(T node) {
        return Optional.ofNullable(this.nodeMap.put(node.getNodeId(), node));
    }

    @Override
    public Optional<T> getNode(NodeId nodeId) {
        return Optional.ofNullable(this.nodeMap.get(nodeId));
    }

    @Override
    public Optional<T> getNode(ExpandedNodeId nodeId, NamespaceTable namespaceTable) {
        return nodeId.local(namespaceTable).flatMap(this::getNode);
    }

    @Override
    public Optional<T> removeNode(NodeId nodeId) {
        return Optional.ofNullable(this.nodeMap.remove(nodeId));
    }

    @Override
    public Optional<T> removeNode(ExpandedNodeId nodeId, NamespaceTable namespaceTable) {
        return nodeId.local(namespaceTable).flatMap(this::removeNode);
    }

    @Override
    public void addReference(Reference reference) {
        this.referenceMultimap.put((Object)reference.getSourceNodeId(), (Object)reference);
    }

    @Override
    public void addReferences(Reference reference, NamespaceTable namespaceTable) {
        this.referenceMultimap.put((Object)reference.getSourceNodeId(), (Object)reference);
        reference.invert(namespaceTable).ifPresent(inverted -> this.referenceMultimap.put((Object)inverted.getSourceNodeId(), inverted));
    }

    @Override
    public void removeReference(Reference reference) {
        this.referenceMultimap.remove((Object)reference.getSourceNodeId(), (Object)reference);
    }

    @Override
    public void removeReferences(Reference reference, NamespaceTable namespaceTable) {
        this.referenceMultimap.remove((Object)reference.getSourceNodeId(), (Object)reference);
        reference.invert(namespaceTable).ifPresent(inverted -> this.referenceMultimap.remove((Object)inverted.getSourceNodeId(), inverted));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Reference> getReferences(NodeId nodeId) {
        ListMultimap<NodeId, Reference> listMultimap = this.referenceMultimap;
        synchronized (listMultimap) {
            return new ArrayList<Reference>(this.referenceMultimap.get((Object)nodeId));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Reference> getReferences(NodeId nodeId, Predicate<Reference> filter) {
        ListMultimap<NodeId, Reference> listMultimap = this.referenceMultimap;
        synchronized (listMultimap) {
            return this.referenceMultimap.get((Object)nodeId).stream().filter(filter).collect(Collectors.toList());
        }
    }
}

