/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.model.nodes.objects;

import java.util.Optional;
import org.eclipse.milo.opcua.sdk.server.api.nodes.ObjectNode;
import org.eclipse.milo.opcua.sdk.server.api.nodes.VariableNode;
import org.eclipse.milo.opcua.sdk.server.model.nodes.objects.AcknowledgeableConditionNode;
import org.eclipse.milo.opcua.sdk.server.model.nodes.objects.ShelvedStateMachineNode;
import org.eclipse.milo.opcua.sdk.server.model.nodes.variables.PropertyNode;
import org.eclipse.milo.opcua.sdk.server.model.nodes.variables.TwoStateVariableNode;
import org.eclipse.milo.opcua.sdk.server.model.types.objects.AlarmConditionType;
import org.eclipse.milo.opcua.sdk.server.nodes.UaNodeContext;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UByte;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;

public class AlarmConditionNode
extends AcknowledgeableConditionNode
implements AlarmConditionType {
    public AlarmConditionNode(UaNodeContext context, NodeId nodeId, QualifiedName browseName, LocalizedText displayName, LocalizedText description, UInteger writeMask, UInteger userWriteMask) {
        super(context, nodeId, browseName, displayName, description, writeMask, userWriteMask);
    }

    public AlarmConditionNode(UaNodeContext context, NodeId nodeId, QualifiedName browseName, LocalizedText displayName, LocalizedText description, UInteger writeMask, UInteger userWriteMask, UByte eventNotifier) {
        super(context, nodeId, browseName, displayName, description, writeMask, userWriteMask, eventNotifier);
    }

    @Override
    public PropertyNode getInputNodeNode() {
        Optional<VariableNode> propertyNode = this.getPropertyNode(AlarmConditionType.INPUT_NODE);
        return propertyNode.orElse(null);
    }

    @Override
    public NodeId getInputNode() {
        Optional<NodeId> propertyValue = this.getProperty(AlarmConditionType.INPUT_NODE);
        return propertyValue.orElse(null);
    }

    @Override
    public void setInputNode(NodeId value) {
        this.setProperty(AlarmConditionType.INPUT_NODE, value);
    }

    @Override
    public PropertyNode getSuppressedOrShelvedNode() {
        Optional<VariableNode> propertyNode = this.getPropertyNode(AlarmConditionType.SUPPRESSED_OR_SHELVED);
        return propertyNode.orElse(null);
    }

    @Override
    public Boolean getSuppressedOrShelved() {
        Optional<Boolean> propertyValue = this.getProperty(AlarmConditionType.SUPPRESSED_OR_SHELVED);
        return propertyValue.orElse(null);
    }

    @Override
    public void setSuppressedOrShelved(Boolean value) {
        this.setProperty(AlarmConditionType.SUPPRESSED_OR_SHELVED, value);
    }

    @Override
    public PropertyNode getMaxTimeShelvedNode() {
        Optional<VariableNode> propertyNode = this.getPropertyNode(AlarmConditionType.MAX_TIME_SHELVED);
        return propertyNode.orElse(null);
    }

    @Override
    public Double getMaxTimeShelved() {
        Optional<Double> propertyValue = this.getProperty(AlarmConditionType.MAX_TIME_SHELVED);
        return propertyValue.orElse(null);
    }

    @Override
    public void setMaxTimeShelved(Double value) {
        this.setProperty(AlarmConditionType.MAX_TIME_SHELVED, value);
    }

    @Override
    public TwoStateVariableNode getActiveStateNode() {
        Optional<VariableNode> component = this.getVariableComponent("http://opcfoundation.org/UA/", "ActiveState");
        return component.orElse(null);
    }

    @Override
    public LocalizedText getActiveState() {
        Optional<VariableNode> component = this.getVariableComponent("ActiveState");
        return component.map(node -> (LocalizedText)node.getValue().getValue().getValue()).orElse(null);
    }

    @Override
    public void setActiveState(LocalizedText value) {
        this.getVariableComponent("ActiveState").ifPresent(n -> n.setValue(new DataValue(new Variant((Object)value))));
    }

    @Override
    public TwoStateVariableNode getSuppressedStateNode() {
        Optional<VariableNode> component = this.getVariableComponent("http://opcfoundation.org/UA/", "SuppressedState");
        return component.orElse(null);
    }

    @Override
    public LocalizedText getSuppressedState() {
        Optional<VariableNode> component = this.getVariableComponent("SuppressedState");
        return component.map(node -> (LocalizedText)node.getValue().getValue().getValue()).orElse(null);
    }

    @Override
    public void setSuppressedState(LocalizedText value) {
        this.getVariableComponent("SuppressedState").ifPresent(n -> n.setValue(new DataValue(new Variant((Object)value))));
    }

    @Override
    public TwoStateVariableNode getEnabledStateNode() {
        Optional<VariableNode> component = this.getVariableComponent("http://opcfoundation.org/UA/", "EnabledState");
        return component.orElse(null);
    }

    @Override
    public LocalizedText getEnabledState() {
        Optional<VariableNode> component = this.getVariableComponent("EnabledState");
        return component.map(node -> (LocalizedText)node.getValue().getValue().getValue()).orElse(null);
    }

    @Override
    public void setEnabledState(LocalizedText value) {
        this.getVariableComponent("EnabledState").ifPresent(n -> n.setValue(new DataValue(new Variant((Object)value))));
    }

    @Override
    public ShelvedStateMachineNode getShelvingStateNode() {
        Optional<ObjectNode> component = this.getObjectComponent("http://opcfoundation.org/UA/", "ShelvingState");
        return component.orElse(null);
    }
}

