/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.namespaces.loader;

import org.eclipse.milo.opcua.sdk.server.api.NodeManager;
import org.eclipse.milo.opcua.sdk.server.namespaces.loader.UaDataTypeLoader;
import org.eclipse.milo.opcua.sdk.server.namespaces.loader.UaMethodLoader;
import org.eclipse.milo.opcua.sdk.server.namespaces.loader.UaObjectLoader;
import org.eclipse.milo.opcua.sdk.server.namespaces.loader.UaObjectTypeLoader;
import org.eclipse.milo.opcua.sdk.server.namespaces.loader.UaReferenceTypeLoader;
import org.eclipse.milo.opcua.sdk.server.namespaces.loader.UaVariableLoader;
import org.eclipse.milo.opcua.sdk.server.namespaces.loader.UaVariableTypeLoader;
import org.eclipse.milo.opcua.sdk.server.namespaces.loader.UaViewLoader;
import org.eclipse.milo.opcua.sdk.server.nodes.UaNode;
import org.eclipse.milo.opcua.sdk.server.nodes.UaNodeContext;

public class UaNodeLoader {
    private final UaNodeContext context;
    private final NodeManager<UaNode> nodeManager;

    public UaNodeLoader(UaNodeContext context, NodeManager<UaNode> nodeManager) {
        this.context = context;
        this.nodeManager = nodeManager;
    }

    public void loadNodes() throws Exception {
        new UaDataTypeLoader(this.context, this.nodeManager).buildNodes();
        new UaMethodLoader(this.context, this.nodeManager).buildNodes();
        new UaObjectLoader(this.context, this.nodeManager).buildNodes();
        new UaObjectTypeLoader(this.context, this.nodeManager).buildNodes();
        new UaReferenceTypeLoader(this.context, this.nodeManager).buildNodes();
        new UaVariableLoader(this.context, this.nodeManager).buildNodes();
        new UaVariableTypeLoader(this.context, this.nodeManager).buildNodes();
        new UaViewLoader(this.context, this.nodeManager).buildNodes();
    }
}

