/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.nodes;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.lang.ref.WeakReference;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import org.eclipse.milo.opcua.sdk.core.QualifiedProperty;
import org.eclipse.milo.opcua.sdk.core.Reference;
import org.eclipse.milo.opcua.sdk.core.util.StreamUtil;
import org.eclipse.milo.opcua.sdk.server.api.NodeManager;
import org.eclipse.milo.opcua.sdk.server.api.nodes.Node;
import org.eclipse.milo.opcua.sdk.server.api.nodes.ObjectNode;
import org.eclipse.milo.opcua.sdk.server.api.nodes.VariableNode;
import org.eclipse.milo.opcua.sdk.server.nodes.AttributeContext;
import org.eclipse.milo.opcua.sdk.server.nodes.AttributeObserver;
import org.eclipse.milo.opcua.sdk.server.nodes.UaNodeContext;
import org.eclipse.milo.opcua.sdk.server.nodes.UaPropertyNode;
import org.eclipse.milo.opcua.sdk.server.nodes.UaServerNode;
import org.eclipse.milo.opcua.sdk.server.nodes.UaVariableNode;
import org.eclipse.milo.opcua.sdk.server.nodes.delegates.AttributeDelegate;
import org.eclipse.milo.opcua.stack.core.AttributeId;
import org.eclipse.milo.opcua.stack.core.Identifiers;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UShort;
import org.eclipse.milo.opcua.stack.core.types.enumerated.NodeClass;

public abstract class UaNode
implements UaServerNode {
    private static final AttributeDelegate DEFAULT_ATTRIBUTE_DELEGATE = AttributeDelegate.DEFAULT;
    private final AtomicReference<AttributeDelegate> attributeDelegate = new AtomicReference<AttributeDelegate>(DEFAULT_ATTRIBUTE_DELEGATE);
    private List<WeakReference<AttributeObserver>> observers;
    private final UaNodeContext context;
    private volatile NodeId nodeId;
    private volatile NodeClass nodeClass;
    private volatile QualifiedName browseName;
    private volatile LocalizedText displayName;
    private volatile LocalizedText description;
    private volatile UInteger writeMask;
    private volatile UInteger userWriteMask;

    protected UaNode(UaNodeContext context, NodeId nodeId, NodeClass nodeClass, QualifiedName browseName, LocalizedText displayName) {
        this(context, nodeId, nodeClass, browseName, displayName, LocalizedText.NULL_VALUE, UInteger.MIN, UInteger.MIN);
    }

    protected UaNode(UaNodeContext context, NodeId nodeId, NodeClass nodeClass, QualifiedName browseName, LocalizedText displayName, LocalizedText description, UInteger writeMask, UInteger userWriteMask) {
        this.context = context;
        this.nodeId = nodeId;
        this.nodeClass = nodeClass;
        this.browseName = browseName;
        this.displayName = displayName;
        this.description = description;
        this.writeMask = writeMask;
        this.userWriteMask = userWriteMask;
    }

    @Override
    public NodeId getNodeId() {
        return this.nodeId;
    }

    @Override
    public NodeClass getNodeClass() {
        return this.nodeClass;
    }

    @Override
    public QualifiedName getBrowseName() {
        return this.browseName;
    }

    @Override
    public LocalizedText getDisplayName() {
        return this.displayName;
    }

    @Override
    public LocalizedText getDescription() {
        return this.description;
    }

    @Override
    public UInteger getWriteMask() {
        return this.writeMask;
    }

    @Override
    public UInteger getUserWriteMask() {
        return this.userWriteMask;
    }

    @Override
    public synchronized void setNodeId(NodeId nodeId) {
        this.nodeId = nodeId;
        this.fireAttributeChanged(AttributeId.NodeId, nodeId);
    }

    @Override
    public synchronized void setNodeClass(NodeClass nodeClass) {
        this.nodeClass = nodeClass;
        this.fireAttributeChanged(AttributeId.NodeClass, nodeClass);
    }

    @Override
    public synchronized void setBrowseName(QualifiedName browseName) {
        this.browseName = browseName;
        this.fireAttributeChanged(AttributeId.BrowseName, browseName);
    }

    @Override
    public synchronized void setDisplayName(LocalizedText displayName) {
        this.displayName = displayName;
        this.fireAttributeChanged(AttributeId.DisplayName, displayName);
    }

    @Override
    public synchronized void setDescription(LocalizedText description) {
        this.description = description;
        this.fireAttributeChanged(AttributeId.Description, description);
    }

    @Override
    public synchronized void setWriteMask(UInteger writeMask) {
        this.writeMask = writeMask;
        this.fireAttributeChanged(AttributeId.WriteMask, writeMask);
    }

    @Override
    public synchronized void setUserWriteMask(UInteger userWriteMask) {
        this.userWriteMask = userWriteMask;
        this.fireAttributeChanged(AttributeId.UserWriteMask, userWriteMask);
    }

    public final void delete() {
        NodeManager<UaNode> nodeManager = this.context.getNodeManager();
        nodeManager.removeNode((UaNode)this.nodeId);
        for (Reference reference : nodeManager.getReferences(this.nodeId)) {
            if (reference.isForward() && reference.subtypeOf(Identifiers.HasChild)) {
                Optional<UaNode> targetNode = nodeManager.getNode(reference.getTargetNodeId(), this.getNodeContext().getServer().getNamespaceTable());
                targetNode.ifPresent(UaNode::delete);
            }
            nodeManager.removeReferences(reference, this.context.getNamespaceTable());
        }
    }

    @Override
    public final UaNodeContext getNodeContext() {
        return this.context;
    }

    public final NodeManager<UaNode> getNodeManager() {
        return this.context.getNodeManager();
    }

    protected Optional<UaNode> getManagedNode(NodeId nodeId) {
        return this.context.getServer().getAddressSpaceManager().getManagedNode(nodeId);
    }

    protected Optional<UaNode> getManagedNode(ExpandedNodeId nodeId) {
        return this.context.getServer().getAddressSpaceManager().getManagedNode(nodeId);
    }

    @Override
    public ImmutableList<Reference> getReferences() {
        return ImmutableList.copyOf(this.context.getServer().getAddressSpaceManager().getManagedReferences(this.nodeId));
    }

    @Override
    public void addReference(Reference reference) {
        this.context.getNodeManager().addReferences(reference, this.context.getNamespaceTable());
    }

    @Override
    public void removeReference(Reference reference) {
        this.context.getNodeManager().removeReferences(reference, this.context.getNamespaceTable());
    }

    public <T> Optional<T> getProperty(QualifiedProperty<T> property) {
        String namespaceUri = property.getNamespaceUri();
        UShort namespaceIndex = this.context.getServer().getNamespaceTable().getIndex(namespaceUri);
        if (namespaceIndex != null) {
            QualifiedName browseName = new QualifiedName(namespaceIndex, property.getBrowseName());
            try {
                return this.getProperty(browseName).map(property.getJavaType()::cast);
            }
            catch (Throwable t) {
                return Optional.empty();
            }
        }
        return Optional.empty();
    }

    public Optional<Object> getProperty(QualifiedName browseName) {
        return this.getPropertyNode(browseName).map(node -> node.getValue().getValue().getValue());
    }

    public <T> void setProperty(QualifiedProperty<T> property, T value) {
        UShort namespaceIndex = this.context.getServer().getNamespaceTable().getIndex(property.getNamespaceUri());
        if (namespaceIndex == null) {
            throw new IllegalArgumentException("property belongs to unregistered namespace: " + property.getNamespaceUri());
        }
        VariableNode node = this.getPropertyNode(property).orElseGet(() -> {
            String browseName = property.getBrowseName();
            NodeId propertyNodeId = new NodeId(this.getNodeId().getNamespaceIndex(), String.format("%s.%s", this.getNodeId().getIdentifier().toString(), browseName));
            UaPropertyNode propertyNode = new UaPropertyNode(this.context, propertyNodeId, new QualifiedName(namespaceIndex, browseName), LocalizedText.english((String)browseName));
            propertyNode.setDataType(property.getDataType());
            propertyNode.setValueRank(property.getValueRank());
            propertyNode.setArrayDimensions(property.getArrayDimensions());
            this.addProperty(propertyNode);
            this.context.getNodeManager().addNode(propertyNode);
            return propertyNode;
        });
        node.setValue(new DataValue(new Variant(value)));
    }

    public Optional<VariableNode> getPropertyNode(QualifiedProperty<?> property) {
        Optional qualifiedName = property.getQualifiedName(this.context.getServer().getNamespaceTable());
        return qualifiedName.map(this::getPropertyNode).orElseGet(() -> this.getPropertyNode(property.getBrowseName()));
    }

    public Optional<VariableNode> getPropertyNode(String browseName) {
        return this.getPropertyNode(new QualifiedName(this.getNodeId().getNamespaceIndex(), browseName));
    }

    public Optional<VariableNode> getPropertyNode(QualifiedName browseName) {
        Node node = this.getReferences().stream().filter(Reference.HAS_PROPERTY_PREDICATE).flatMap(r -> StreamUtil.opt2stream(this.getManagedNode(r.getTargetNodeId()))).filter(n -> n.getBrowseName().equals((Object)browseName)).findFirst().orElse(null);
        try {
            return Optional.ofNullable((VariableNode)node);
        }
        catch (Throwable t) {
            return Optional.empty();
        }
    }

    void addProperty(UaVariableNode node) {
        this.addReference(new Reference(this.getNodeId(), Identifiers.HasProperty, node.getNodeId().expanded(), true));
        node.addReference(new Reference(node.getNodeId(), Identifiers.HasProperty, this.getNodeId().expanded(), false));
    }

    void removeProperty(UaVariableNode node) {
        this.removeReference(new Reference(this.getNodeId(), Identifiers.HasProperty, node.getNodeId().expanded(), true));
        node.removeReference(new Reference(node.getNodeId(), Identifiers.HasProperty, this.getNodeId().expanded(), false));
    }

    public Optional<UaNode> findNode(QualifiedName browseName) {
        return this.findNode(browseName, uaNode -> true, reference -> true);
    }

    public Optional<UaNode> findNode(QualifiedName browseName, Predicate<Reference> references) {
        return this.findNode(browseName, uaNode -> true, references);
    }

    public Optional<UaNode> findNode(QualifiedName browseName, Predicate<UaNode> nodePredicate, Predicate<Reference> referencePredicate) {
        return this.getReferences().stream().filter(referencePredicate).flatMap(r -> StreamUtil.opt2stream(this.getManagedNode(r.getTargetNodeId()))).filter(nodePredicate).filter(n -> n.getBrowseName().equals((Object)browseName)).findFirst();
    }

    public Optional<UaNode> findNode(String namespaceUri, String browseName, Predicate<UaNode> nodePredicate, Predicate<Reference> referencePredicate) {
        return this.getReferences().stream().filter(referencePredicate).flatMap(r -> StreamUtil.opt2stream(this.getManagedNode(r.getTargetNodeId()))).filter(nodePredicate).filter(n -> {
            String nodeBrowseName = n.getBrowseName().getName();
            UShort index = n.getBrowseName().getNamespaceIndex();
            String nodeBrowseNameUri = this.context.getServer().getNamespaceTable().getUri(index);
            return Objects.equals(browseName, nodeBrowseName) && Objects.equals(namespaceUri, nodeBrowseNameUri);
        }).findFirst();
    }

    protected Optional<ObjectNode> getObjectComponent(String namespaceUri, String name) {
        UShort namespaceIndex = this.context.getServer().getNamespaceTable().getIndex(namespaceUri);
        if (namespaceIndex != null) {
            return this.getObjectComponent(new QualifiedName(namespaceIndex, name));
        }
        return Optional.empty();
    }

    protected Optional<ObjectNode> getObjectComponent(String browseName) {
        return this.getObjectComponent(new QualifiedName(this.getNodeId().getNamespaceIndex(), browseName));
    }

    protected Optional<ObjectNode> getObjectComponent(QualifiedName browseName) {
        ObjectNode node = this.getReferences().stream().filter(Reference.HAS_COMPONENT_PREDICATE).flatMap(r -> StreamUtil.opt2stream(this.getManagedNode(r.getTargetNodeId()))).filter(n -> n.getNodeClass() == NodeClass.Object && n.getBrowseName().equals((Object)browseName)).findFirst().orElse(null);
        return Optional.ofNullable(node);
    }

    protected Optional<VariableNode> getVariableComponent(String namespaceUri, String name) {
        UShort namespaceIndex = this.context.getServer().getNamespaceTable().getIndex(namespaceUri);
        if (namespaceIndex != null) {
            return this.getVariableComponent(new QualifiedName(namespaceIndex, name));
        }
        return Optional.empty();
    }

    protected Optional<VariableNode> getVariableComponent(String browseName) {
        return this.getVariableComponent(new QualifiedName(this.getNodeId().getNamespaceIndex(), browseName));
    }

    protected Optional<VariableNode> getVariableComponent(QualifiedName browseName) {
        VariableNode node = this.getReferences().stream().filter(Reference.HAS_COMPONENT_PREDICATE).flatMap(r -> StreamUtil.opt2stream(this.getManagedNode(r.getTargetNodeId()))).filter(n -> n.getNodeClass() == NodeClass.Variable && n.getBrowseName().equals((Object)browseName)).findFirst().orElse(null);
        return Optional.ofNullable(node);
    }

    public synchronized void addAttributeObserver(AttributeObserver observer) {
        if (this.observers == null) {
            this.observers = new LinkedList<WeakReference<AttributeObserver>>();
        }
        this.observers.add(new WeakReference<AttributeObserver>(observer));
    }

    public synchronized void removeAttributeObserver(AttributeObserver observer) {
        if (this.observers == null) {
            return;
        }
        Iterator<WeakReference<AttributeObserver>> iterator = this.observers.iterator();
        while (iterator.hasNext()) {
            WeakReference<AttributeObserver> ref = iterator.next();
            if (ref.get() != null && ref.get() != observer) continue;
            iterator.remove();
        }
        if (this.observers.isEmpty()) {
            this.observers = null;
        }
    }

    protected synchronized void fireAttributeChanged(AttributeId attributeId, Object attributeValue) {
        if (this.observers == null) {
            return;
        }
        Iterator<WeakReference<AttributeObserver>> iterator = this.observers.iterator();
        while (iterator.hasNext()) {
            WeakReference<AttributeObserver> ref = iterator.next();
            AttributeObserver observer = (AttributeObserver)ref.get();
            if (observer != null) {
                observer.attributeChanged(this, attributeId, attributeValue);
                continue;
            }
            iterator.remove();
        }
    }

    public void setAttributeDelegate(@Nonnull AttributeDelegate attributeDelegate) {
        Preconditions.checkNotNull((Object)attributeDelegate);
        this.attributeDelegate.set(attributeDelegate);
    }

    @Override
    public DataValue getAttribute(AttributeContext context, AttributeId attributeId) {
        return this.attributeDelegate.get().getAttribute(context, this, attributeId);
    }

    @Override
    public void setAttribute(AttributeContext context, AttributeId attributeId, DataValue value) throws UaException {
        this.attributeDelegate.get().setAttribute(context, this, attributeId, value);
    }
}

