/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.nodes;

import javax.annotation.Nullable;
import org.eclipse.milo.opcua.sdk.core.QualifiedProperty;
import org.eclipse.milo.opcua.sdk.server.api.nodes.ViewNode;
import org.eclipse.milo.opcua.sdk.server.nodes.UaNode;
import org.eclipse.milo.opcua.sdk.server.nodes.UaNodeContext;
import org.eclipse.milo.opcua.stack.core.AttributeId;
import org.eclipse.milo.opcua.stack.core.Identifiers;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UByte;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.enumerated.NodeClass;

public class UaViewNode
extends UaNode
implements ViewNode {
    private volatile Boolean containsNoLoops;
    private volatile UByte eventNotifier;
    public static final QualifiedProperty<String> NodeVersion = new QualifiedProperty("http://opcfoundation.org/UA/", "NodeVersion", Identifiers.String, Integer.valueOf(-1), String.class);
    public static final QualifiedProperty<UInteger> ViewVersion = new QualifiedProperty("http://opcfoundation.org/UA/", "ViewVersion", Identifiers.UInt32, Integer.valueOf(-1), UInteger.class);

    public UaViewNode(UaNodeContext context, NodeId nodeId, QualifiedName browseName, LocalizedText displayName, LocalizedText description, UInteger writeMask, UInteger userWriteMask, Boolean containsNoLoops, UByte eventNotifier) {
        super(context, nodeId, NodeClass.View, browseName, displayName, description, writeMask, userWriteMask);
        this.containsNoLoops = containsNoLoops;
        this.eventNotifier = eventNotifier;
    }

    @Override
    public Boolean getContainsNoLoops() {
        return this.containsNoLoops;
    }

    @Override
    public UByte getEventNotifier() {
        return this.eventNotifier;
    }

    @Override
    public synchronized void setContainsNoLoops(Boolean containsNoLoops) {
        this.containsNoLoops = containsNoLoops;
        this.fireAttributeChanged(AttributeId.ContainsNoLoops, containsNoLoops);
    }

    @Override
    public synchronized void setEventNotifier(UByte eventNotifier) {
        this.eventNotifier = eventNotifier;
        this.fireAttributeChanged(AttributeId.EventNotifier, eventNotifier);
    }

    @Nullable
    public String getNodeVersion() {
        return this.getProperty(NodeVersion).orElse(null);
    }

    @Nullable
    public UInteger getViewVersion() {
        return this.getProperty(ViewVersion).orElse(null);
    }

    public void setNodeVersion(String nodeVersion) {
        this.setProperty(NodeVersion, nodeVersion);
    }

    public void setViewVersion(UInteger viewVersion) {
        this.setProperty(ViewVersion, viewVersion);
    }
}

