/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.namespaces;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.eclipse.milo.opcua.sdk.server.OpcUaServer;
import org.eclipse.milo.opcua.sdk.server.Session;
import org.eclipse.milo.opcua.sdk.server.api.DataItem;
import org.eclipse.milo.opcua.sdk.server.api.EventItem;
import org.eclipse.milo.opcua.sdk.server.api.ManagedNamespace;
import org.eclipse.milo.opcua.sdk.server.api.MonitoredItem;
import org.eclipse.milo.opcua.sdk.server.api.config.OpcUaServerConfigLimits;
import org.eclipse.milo.opcua.sdk.server.api.methods.AbstractMethodInvocationHandler;
import org.eclipse.milo.opcua.sdk.server.api.methods.Out;
import org.eclipse.milo.opcua.sdk.server.api.nodes.VariableNode;
import org.eclipse.milo.opcua.sdk.server.items.BaseMonitoredItem;
import org.eclipse.milo.opcua.sdk.server.items.MonitoredDataItem;
import org.eclipse.milo.opcua.sdk.server.model.methods.ConditionRefreshMethod;
import org.eclipse.milo.opcua.sdk.server.model.methods.GetMonitoredItemsMethod;
import org.eclipse.milo.opcua.sdk.server.model.methods.ResendDataMethod;
import org.eclipse.milo.opcua.sdk.server.model.nodes.objects.BaseEventNode;
import org.eclipse.milo.opcua.sdk.server.model.nodes.objects.OperationLimitsNode;
import org.eclipse.milo.opcua.sdk.server.model.nodes.objects.ServerCapabilitiesNode;
import org.eclipse.milo.opcua.sdk.server.model.nodes.objects.ServerNode;
import org.eclipse.milo.opcua.sdk.server.model.nodes.variables.ServerStatusNode;
import org.eclipse.milo.opcua.sdk.server.namespaces.loader.UaNodeLoader;
import org.eclipse.milo.opcua.sdk.server.nodes.AttributeContext;
import org.eclipse.milo.opcua.sdk.server.nodes.UaMethodNode;
import org.eclipse.milo.opcua.sdk.server.nodes.UaNode;
import org.eclipse.milo.opcua.sdk.server.nodes.delegates.AttributeDelegate;
import org.eclipse.milo.opcua.sdk.server.subscriptions.Subscription;
import org.eclipse.milo.opcua.sdk.server.util.SubscriptionModel;
import org.eclipse.milo.opcua.stack.core.Identifiers;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.UaSerializationException;
import org.eclipse.milo.opcua.stack.core.serialization.SerializationContext;
import org.eclipse.milo.opcua.stack.core.serialization.UaStructure;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.DateTime;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExtensionObject;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.Unsigned;
import org.eclipse.milo.opcua.stack.core.types.enumerated.RedundancySupport;
import org.eclipse.milo.opcua.stack.core.types.enumerated.ServerState;
import org.eclipse.milo.opcua.stack.core.types.structured.BuildInfo;
import org.eclipse.milo.opcua.stack.core.types.structured.ServerStatusDataType;
import org.eclipse.milo.opcua.stack.core.util.NonceUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpcUaNamespace
extends ManagedNamespace {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final SubscriptionModel subscriptionModel;
    private final OpcUaServer server;

    public OpcUaNamespace(OpcUaServer server) {
        super(server, "http://opcfoundation.org/UA/");
        this.server = server;
        this.subscriptionModel = new SubscriptionModel(server, this);
    }

    @Override
    protected void onStartup() {
        super.onStartup();
        this.loadNodes();
        this.configureServerObject();
        this.configureConditionRefresh();
    }

    @Override
    public void onDataItemsCreated(List<DataItem> dataItems) {
        this.subscriptionModel.onDataItemsCreated(dataItems);
    }

    @Override
    public void onDataItemsModified(List<DataItem> dataItems) {
        this.subscriptionModel.onDataItemsModified(dataItems);
    }

    @Override
    public void onDataItemsDeleted(List<DataItem> dataItems) {
        this.subscriptionModel.onDataItemsDeleted(dataItems);
    }

    @Override
    public void onMonitoringModeChanged(List<MonitoredItem> monitoredItems) {
        this.subscriptionModel.onMonitoringModeChanged(monitoredItems);
    }

    @Override
    public void onEventItemsCreated(List<EventItem> eventItems) {
        eventItems.stream().filter(MonitoredItem::isSamplingEnabled).forEach(item -> this.server.getEventBus().register(item));
    }

    @Override
    public void onEventItemsModified(List<EventItem> eventItems) {
        for (EventItem item : eventItems) {
            if (item.isSamplingEnabled()) {
                this.server.getEventBus().register((Object)item);
                continue;
            }
            this.server.getEventBus().unregister((Object)item);
        }
    }

    @Override
    public void onEventItemsDeleted(List<EventItem> eventItems) {
        eventItems.forEach(item -> this.server.getEventBus().unregister(item));
    }

    private void loadNodes() {
        try {
            long startTime = System.nanoTime();
            new UaNodeLoader(this.getNodeContext(), this.getNodeManager()).loadNodes();
            long endTime = System.nanoTime();
            long deltaMs = TimeUnit.MILLISECONDS.convert(endTime - startTime, TimeUnit.NANOSECONDS);
            this.logger.info("Loaded nodes in {}ms.", (Object)deltaMs);
        }
        catch (Exception e) {
            this.logger.error("Error loading nodes.", (Throwable)e);
        }
    }

    private void configureServerObject() {
        ServerNode serverNode = (ServerNode)this.getNodeManager().get(Identifiers.Server);
        assert (serverNode != null);
        serverNode.getNamespaceArrayNode().setAttributeDelegate(new AttributeDelegate(){

            @Override
            public DataValue getValue(AttributeContext context, VariableNode node) {
                return new DataValue(new Variant((Object)OpcUaNamespace.this.server.getNamespaceTable().toArray()));
            }
        });
        serverNode.getServerArrayNode().setAttributeDelegate(new AttributeDelegate(){

            @Override
            public DataValue getValue(AttributeContext context, VariableNode node) {
                return new DataValue(new Variant((Object)OpcUaNamespace.this.server.getServerTable().toArray()));
            }
        });
        serverNode.setAuditing(false);
        serverNode.getServerDiagnosticsNode().setEnabledFlag(false);
        serverNode.setServiceLevel(Unsigned.ubyte((int)255));
        ServerStatusNode serverStatus = serverNode.getServerStatusNode();
        BuildInfo buildInfo = this.server.getConfig().getBuildInfo();
        serverStatus.setBuildInfo(buildInfo);
        serverStatus.getBuildInfoNode().setBuildDate(buildInfo.getBuildDate());
        serverStatus.getBuildInfoNode().setBuildNumber(buildInfo.getBuildNumber());
        serverStatus.getBuildInfoNode().setManufacturerName(buildInfo.getManufacturerName());
        serverStatus.getBuildInfoNode().setProductName(buildInfo.getProductName());
        serverStatus.getBuildInfoNode().setProductUri(buildInfo.getProductUri());
        serverStatus.getBuildInfoNode().setSoftwareVersion(buildInfo.getSoftwareVersion());
        serverStatus.setCurrentTime(DateTime.now());
        serverStatus.setSecondsTillShutdown(Unsigned.uint((int)0));
        serverStatus.setShutdownReason(LocalizedText.NULL_VALUE);
        serverStatus.setState(ServerState.Running);
        serverStatus.setStartTime(DateTime.now());
        serverStatus.getCurrentTimeNode().setAttributeDelegate(new AttributeDelegate(){

            @Override
            public DataValue getValue(AttributeContext context, VariableNode node) {
                DataValue value = new DataValue(new Variant((Object)DateTime.now()));
                node.setValue(value);
                return value;
            }
        });
        serverStatus.setAttributeDelegate(new AttributeDelegate(){

            @Override
            public DataValue getValue(AttributeContext context, VariableNode node) throws UaException {
                ServerStatusNode serverStatusNode = (ServerStatusNode)node;
                ServerStatusDataType serverStatus = new ServerStatusDataType(serverStatusNode.getStartTime(), DateTime.now(), serverStatusNode.getState(), serverStatusNode.getBuildInfo(), serverStatusNode.getSecondsTillShutdown(), serverStatusNode.getShutdownReason());
                try {
                    ExtensionObject xo = ExtensionObject.encode((SerializationContext)OpcUaNamespace.this.server.getSerializationContext(), (UaStructure)serverStatus);
                    DataValue value = new DataValue(new Variant((Object)xo));
                    node.setValue(value);
                    return value;
                }
                catch (UaSerializationException e) {
                    throw new UaException((Throwable)e);
                }
            }
        });
        OpcUaServerConfigLimits limits = this.server.getConfig().getLimits();
        ServerCapabilitiesNode serverCapabilities = serverNode.getServerCapabilitiesNode();
        serverCapabilities.setLocaleIdArray(new String[]{Locale.ENGLISH.getLanguage()});
        serverCapabilities.setServerProfileArray(new String[0]);
        serverCapabilities.setMaxArrayLength(limits.getMaxArrayLength());
        serverCapabilities.setMaxStringLength(limits.getMaxStringLength());
        serverCapabilities.setMaxByteStringLength(limits.getMaxByteStringLength());
        serverCapabilities.setMaxBrowseContinuationPoints(limits.getMaxBrowseContinuationPoints());
        serverCapabilities.setMaxHistoryContinuationPoints(limits.getMaxHistoryContinuationPoints());
        serverCapabilities.setMaxQueryContinuationPoints(limits.getMaxQueryContinuationPoints());
        serverCapabilities.setMinSupportedSampleRate(limits.getMinSupportedSampleRate());
        OperationLimitsNode limitsNode = serverCapabilities.getOperationLimitsNode();
        limitsNode.setMaxMonitoredItemsPerCall(limits.getMaxMonitoredItemsPerCall());
        limitsNode.setMaxNodesPerBrowse(limits.getMaxNodesPerBrowse());
        limitsNode.setMaxNodesPerHistoryReadData(limits.getMaxNodesPerHistoryReadData());
        limitsNode.setMaxNodesPerHistoryReadEvents(limits.getMaxNodesPerHistoryReadEvents());
        limitsNode.setMaxNodesPerHistoryUpdateData(limits.getMaxNodesPerHistoryUpdateData());
        limitsNode.setMaxNodesPerHistoryUpdateEvents(limits.getMaxNodesPerHistoryUpdateEvents());
        limitsNode.setMaxNodesPerMethodCall(limits.getMaxNodesPerMethodCall());
        limitsNode.setMaxNodesPerNodeManagement(limits.getMaxNodesPerNodeManagement());
        limitsNode.setMaxNodesPerRead(limits.getMaxNodesPerRead());
        limitsNode.setMaxNodesPerRegisterNodes(limits.getMaxNodesPerRegisterNodes());
        limitsNode.setMaxNodesPerTranslateBrowsePathsToNodeIds(limits.getMaxNodesPerTranslateBrowsePathsToNodeIds());
        limitsNode.setMaxNodesPerWrite(limits.getMaxNodesPerWrite());
        serverNode.getServerRedundancyNode().setRedundancySupport(RedundancySupport.None);
        this.configureGetMonitoredItems();
        this.configureResendData();
    }

    private void configureGetMonitoredItems() {
        UaNode node = (UaNode)this.getNodeManager().get(Identifiers.Server_GetMonitoredItems);
        if (node instanceof UaMethodNode) {
            UaMethodNode methodNode = (UaMethodNode)node;
            OpcUaNamespace.configureMethodNode(methodNode, GetMonitoredItemsMethodImpl::new);
        } else {
            this.logger.warn("GetMonitoredItems UaMethodNode not found.");
        }
    }

    private void configureResendData() {
        UaNode node = (UaNode)this.getNodeManager().get(Identifiers.Server_ResendData);
        if (node instanceof UaMethodNode) {
            UaMethodNode resendDataNode = (UaMethodNode)node;
            OpcUaNamespace.configureMethodNode(resendDataNode, ResendDataMethodImpl::new);
        } else {
            this.logger.warn("ResendData UaMethodNode not found.");
        }
    }

    private void configureConditionRefresh() {
        UaNode node = (UaNode)this.getNodeManager().get(Identifiers.ConditionType_ConditionRefresh);
        if (node instanceof UaMethodNode) {
            UaMethodNode conditionRefreshNode = (UaMethodNode)node;
            OpcUaNamespace.configureMethodNode(conditionRefreshNode, ConditionRefreshMethodImpl::new);
        } else {
            this.logger.warn("ConditionRefresh UaMethodNode not found.");
        }
    }

    private static <T extends AbstractMethodInvocationHandler> void configureMethodNode(UaMethodNode methodNode, Function<UaMethodNode, T> f) {
        AbstractMethodInvocationHandler invocationHandler = (AbstractMethodInvocationHandler)f.apply(methodNode);
        methodNode.setInvocationHandler(invocationHandler);
        methodNode.setInputArguments(invocationHandler.getInputArguments());
        methodNode.setOutputArguments(invocationHandler.getOutputArguments());
    }

    private static class ResendDataMethodImpl
    extends ResendDataMethod {
        ResendDataMethodImpl(UaMethodNode node) {
            super(node);
        }

        @Override
        protected void invoke(AbstractMethodInvocationHandler.InvocationContext context, UInteger subscriptionId) throws UaException {
            Subscription subscription;
            Session session = context.getSession().orElse(null);
            if (session != null) {
                subscription = session.getSubscriptionManager().getSubscription(subscriptionId);
                if (subscription == null) {
                    throw new UaException(0x80280000L);
                }
            } else {
                throw new UaException(2149515264L);
            }
            subscription.getMonitoredItems().values().stream().filter(item -> item instanceof MonitoredDataItem).map(item -> (MonitoredDataItem)item).forEach(MonitoredDataItem::clearLastValue);
        }
    }

    private static class GetMonitoredItemsMethodImpl
    extends GetMonitoredItemsMethod {
        private final OpcUaServer server;

        GetMonitoredItemsMethodImpl(UaMethodNode node) {
            super(node);
            this.server = node.getNodeContext().getServer();
        }

        @Override
        protected void invoke(AbstractMethodInvocationHandler.InvocationContext context, UInteger subscriptionId, Out<UInteger[]> serverHandles, Out<UInteger[]> clientHandles) throws UaException {
            ArrayList clientHandleList;
            ArrayList serverHandleList;
            Subscription subscription = this.server.getSubscriptions().get(subscriptionId);
            if (subscription != null) {
                serverHandleList = Lists.newArrayList();
                clientHandleList = Lists.newArrayList();
                for (BaseMonitoredItem<?> item : subscription.getMonitoredItems().values()) {
                    serverHandleList.add(item.getId());
                    clientHandleList.add(Unsigned.uint((long)item.getClientHandle()));
                }
            } else {
                throw new UaException(new StatusCode(0x80280000L));
            }
            serverHandles.set(serverHandleList.toArray(new UInteger[0]));
            clientHandles.set(clientHandleList.toArray(new UInteger[0]));
        }
    }

    private static class ConditionRefreshMethodImpl
    extends ConditionRefreshMethod {
        private final OpcUaServer server;

        ConditionRefreshMethodImpl(UaMethodNode node) {
            super(node);
            this.server = node.getNodeContext().getServer();
        }

        @Override
        protected void invoke(AbstractMethodInvocationHandler.InvocationContext context, UInteger subscriptionId) throws UaException {
            Session session = context.getSession().orElse(null);
            if (session != null) {
                Subscription subscription = session.getSubscriptionManager().getSubscription(subscriptionId);
                if (subscription == null) {
                    throw new UaException(0x80280000L);
                }
            } else {
                throw new UaException(2149515264L);
            }
            BaseEventNode refreshStart = this.server.getEventFactory().createEvent(new NodeId(1, UUID.randomUUID()), Identifiers.RefreshStartEventType);
            refreshStart.setBrowseName(new QualifiedName(1, "RefreshStart"));
            refreshStart.setDisplayName(LocalizedText.english((String)"RefreshStart"));
            refreshStart.setEventId(NonceUtil.generateNonce((int)16));
            refreshStart.setEventType(Identifiers.RefreshStartEventType);
            refreshStart.setSourceNode(Identifiers.Server);
            refreshStart.setSourceName("Server");
            refreshStart.setTime(DateTime.now());
            refreshStart.setReceiveTime(DateTime.NULL_VALUE);
            refreshStart.setMessage(LocalizedText.english((String)"RefreshStart"));
            refreshStart.setSeverity(Unsigned.ushort((int)0));
            BaseEventNode refreshEnd = this.server.getEventFactory().createEvent(new NodeId(1, UUID.randomUUID()), Identifiers.RefreshEndEventType);
            refreshEnd.setBrowseName(new QualifiedName(1, "RefreshEnd"));
            refreshEnd.setDisplayName(LocalizedText.english((String)"RefreshEnd"));
            refreshEnd.setEventId(NonceUtil.generateNonce((int)16));
            refreshEnd.setEventType(Identifiers.RefreshEndEventType);
            refreshEnd.setSourceNode(Identifiers.Server);
            refreshEnd.setSourceName("Server");
            refreshEnd.setTime(DateTime.now());
            refreshEnd.setReceiveTime(DateTime.NULL_VALUE);
            refreshEnd.setMessage(LocalizedText.english((String)"RefreshEnd"));
            refreshEnd.setSeverity(Unsigned.ushort((int)0));
            this.server.getEventBus().post((Object)refreshStart);
            this.server.getEventBus().post((Object)refreshEnd);
            refreshStart.delete();
            refreshEnd.delete();
        }
    }
}

