/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.nodes.delegates;

import org.eclipse.milo.opcua.sdk.server.api.nodes.DataTypeNode;
import org.eclipse.milo.opcua.sdk.server.api.nodes.MethodNode;
import org.eclipse.milo.opcua.sdk.server.api.nodes.Node;
import org.eclipse.milo.opcua.sdk.server.api.nodes.ObjectNode;
import org.eclipse.milo.opcua.sdk.server.api.nodes.ObjectTypeNode;
import org.eclipse.milo.opcua.sdk.server.api.nodes.ReferenceTypeNode;
import org.eclipse.milo.opcua.sdk.server.api.nodes.VariableNode;
import org.eclipse.milo.opcua.sdk.server.api.nodes.VariableTypeNode;
import org.eclipse.milo.opcua.sdk.server.api.nodes.ViewNode;
import org.eclipse.milo.opcua.sdk.server.nodes.AttributeContext;
import org.eclipse.milo.opcua.sdk.server.nodes.delegates.GetSetBase;
import org.eclipse.milo.opcua.sdk.server.nodes.delegates.GetSetDataTypeNode;
import org.eclipse.milo.opcua.sdk.server.nodes.delegates.GetSetMethodNode;
import org.eclipse.milo.opcua.sdk.server.nodes.delegates.GetSetObjectNode;
import org.eclipse.milo.opcua.sdk.server.nodes.delegates.GetSetObjectTypeNode;
import org.eclipse.milo.opcua.sdk.server.nodes.delegates.GetSetReferenceTypeNode;
import org.eclipse.milo.opcua.sdk.server.nodes.delegates.GetSetVariableNode;
import org.eclipse.milo.opcua.sdk.server.nodes.delegates.GetSetVariableTypeNode;
import org.eclipse.milo.opcua.sdk.server.nodes.delegates.GetSetViewNode;
import org.eclipse.milo.opcua.stack.core.AttributeId;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;

public interface AttributeDelegate
extends GetSetBase,
GetSetDataTypeNode,
GetSetMethodNode,
GetSetObjectNode,
GetSetObjectTypeNode,
GetSetReferenceTypeNode,
GetSetVariableNode,
GetSetVariableTypeNode,
GetSetViewNode {
    public static final AttributeDelegate DEFAULT = new AttributeDelegate(){};

    default public DataValue getAttribute(AttributeContext context, Node node, AttributeId attributeId) {
        try {
            switch (node.getNodeClass()) {
                case DataType: {
                    return this.getDataTypeAttribute(context, (DataTypeNode)node, attributeId);
                }
                case Method: {
                    return this.getMethodAttribute(context, (MethodNode)node, attributeId);
                }
                case Object: {
                    return this.getObjectAttribute(context, (ObjectNode)node, attributeId);
                }
                case ObjectType: {
                    return this.getObjectTypeAttribute(context, (ObjectTypeNode)node, attributeId);
                }
                case ReferenceType: {
                    return this.getReferenceTypeAttribute(context, (ReferenceTypeNode)node, attributeId);
                }
                case Variable: {
                    return this.getVariableAttribute(context, (VariableNode)node, attributeId);
                }
                case VariableType: {
                    return this.getVariableTypeAttribute(context, (VariableTypeNode)node, attributeId);
                }
                case View: {
                    return this.getViewAttribute(context, (ViewNode)node, attributeId);
                }
            }
            throw new UaException(2153709568L);
        }
        catch (UaException e) {
            return new DataValue(e.getStatusCode());
        }
    }

    default public void setAttribute(AttributeContext context, Node node, AttributeId attributeId, DataValue value) throws UaException {
        switch (node.getNodeClass()) {
            case DataType: {
                this.setDataTypeAttribute(context, (DataTypeNode)node, attributeId, value);
                break;
            }
            case Method: {
                this.setMethodAttribute(context, (MethodNode)node, attributeId, value);
                break;
            }
            case Object: {
                this.setObjectAttribute(context, (ObjectNode)node, attributeId, value);
                break;
            }
            case ObjectType: {
                this.setObjectTypeAttribute(context, (ObjectTypeNode)node, attributeId, value);
                break;
            }
            case ReferenceType: {
                this.setReferenceTypeAttribute(context, (ReferenceTypeNode)node, attributeId, value);
                break;
            }
            case Variable: {
                this.setVariableAttribute(context, (VariableNode)node, attributeId, value);
                break;
            }
            case VariableType: {
                this.setVariableTypeAttribute(context, (VariableTypeNode)node, attributeId, value);
                break;
            }
            case View: {
                this.setViewAttribute(context, (ViewNode)node, attributeId, value);
                break;
            }
            default: {
                throw new UaException(2153709568L);
            }
        }
    }
}

