/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.api;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.eclipse.milo.opcua.sdk.server.AbstractLifecycle;
import org.eclipse.milo.opcua.sdk.server.OpcUaServer;
import org.eclipse.milo.opcua.sdk.server.Session;
import org.eclipse.milo.opcua.sdk.server.api.AddressSpace;
import org.eclipse.milo.opcua.sdk.server.api.AddressSpaceFilter;
import org.eclipse.milo.opcua.sdk.server.api.DataItem;
import org.eclipse.milo.opcua.sdk.server.api.EventItem;
import org.eclipse.milo.opcua.sdk.server.api.ManagedAddressSpace;
import org.eclipse.milo.opcua.sdk.server.api.MonitoredItem;
import org.eclipse.milo.opcua.sdk.server.api.SimpleAddressSpaceFilter;
import org.eclipse.milo.opcua.sdk.server.api.services.AttributeHistoryServices;
import org.eclipse.milo.opcua.sdk.server.api.services.AttributeServices;
import org.eclipse.milo.opcua.sdk.server.api.services.MethodServices;
import org.eclipse.milo.opcua.sdk.server.api.services.MonitoredItemServices;
import org.eclipse.milo.opcua.sdk.server.api.services.NodeManagementServices;
import org.eclipse.milo.opcua.sdk.server.api.services.ViewServices;
import org.eclipse.milo.opcua.sdk.server.util.GroupMapCollate;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.Unsigned;
import org.eclipse.milo.opcua.stack.core.types.enumerated.TimestampsToReturn;
import org.eclipse.milo.opcua.stack.core.types.structured.AddNodesItem;
import org.eclipse.milo.opcua.stack.core.types.structured.AddReferencesItem;
import org.eclipse.milo.opcua.stack.core.types.structured.CallMethodRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.DeleteNodesItem;
import org.eclipse.milo.opcua.stack.core.types.structured.DeleteReferencesItem;
import org.eclipse.milo.opcua.stack.core.types.structured.HistoryReadDetails;
import org.eclipse.milo.opcua.stack.core.types.structured.HistoryReadValueId;
import org.eclipse.milo.opcua.stack.core.types.structured.HistoryUpdateDetails;
import org.eclipse.milo.opcua.stack.core.types.structured.ReadValueId;
import org.eclipse.milo.opcua.stack.core.types.structured.ViewDescription;
import org.eclipse.milo.opcua.stack.core.types.structured.WriteValue;
import org.eclipse.milo.opcua.stack.core.util.FutureUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AddressSpaceComposite
extends AbstractLifecycle
implements AddressSpace {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final CopyOnWriteArrayList<AddressSpace> addressSpaces = new CopyOnWriteArrayList();
    private final CompositeAddressSpaceFilter filter = new CompositeAddressSpaceFilter(this.addressSpaces);
    private final OpcUaServer server;

    public AddressSpaceComposite(OpcUaServer server) {
        this.server = server;
    }

    @Override
    protected void onStartup() {
    }

    @Override
    protected void onShutdown() {
    }

    @Override
    public AddressSpaceFilter getFilter() {
        return this.filter;
    }

    public synchronized void register(AddressSpace addressSpace) {
        if (!this.addressSpaces.contains(addressSpace)) {
            this.addressSpaces.add(addressSpace);
            this.logger.debug("registered {}", (Object)addressSpace);
        } else {
            this.logger.warn("AddressSpace already registered: {}", (Object)addressSpace);
        }
    }

    public synchronized void registerFirst(AddressSpace addressSpace) {
        if (!this.addressSpaces.contains(addressSpace)) {
            this.addressSpaces.add(0, addressSpace);
            this.logger.debug("registered {} at index 0", (Object)addressSpace);
        } else {
            this.logger.warn("AddressSpace already registered: {}", (Object)addressSpace);
        }
    }

    public synchronized void unregister(AddressSpace addressSpace) {
        if (this.addressSpaces.contains(addressSpace)) {
            this.addressSpaces.remove(addressSpace);
            this.logger.debug("unregistered {}", (Object)addressSpace);
        } else {
            this.logger.warn("AddressSpace not registered: {}", (Object)addressSpace);
        }
    }

    protected OpcUaServer getServer() {
        return this.server;
    }

    protected List<AddressSpace> getAddressSpaces() {
        return new ArrayList<AddressSpace>(this.addressSpaces);
    }

    private AddressSpace getAddressSpace(Predicate<AddressSpace> filter) {
        return this.addressSpaces.stream().filter(filter).findFirst().orElse(new EmptyAddressSpace(this.server));
    }

    @Override
    public UInteger getViewCount() {
        return this.addressSpaces.stream().map(AddressSpace::getViewCount).reduce(Unsigned.uint((int)0), UInteger::add);
    }

    @Override
    public void browse(ViewServices.BrowseContext context, ViewDescription view, NodeId nodeId) {
        AddressSpace firstMatch;
        List<AddressSpace> addressSpaces = this.getAddressSpaces();
        try {
            firstMatch = addressSpaces.stream().filter(asx -> asx.getFilter().filterBrowse(this.server, nodeId)).findFirst().orElseThrow(() -> new UaException(2150891520L));
            addressSpaces.remove(firstMatch);
        }
        catch (UaException e) {
            context.failure(e);
            return;
        }
        ArrayList futures = new ArrayList();
        ViewServices.BrowseContext browseContext = new ViewServices.BrowseContext(this.getServer(), context.getSession().orElse(null));
        firstMatch.browse(browseContext, view, nodeId);
        futures.add(browseContext.getFuture());
        for (AddressSpace asx2 : addressSpaces) {
            browseContext = new ViewServices.BrowseContext(this.getServer(), context.getSession().orElse(null));
            asx2.getReferences(browseContext, view, nodeId);
            futures.add(browseContext.getFuture());
        }
        CompletionStage future = FutureUtils.sequence(futures).thenApply(refs -> refs.stream().flatMap(Collection::stream).distinct().collect(Collectors.toList()));
        ((CompletableFuture)future).whenComplete((references, ex) -> {
            if (references != null) {
                context.success(references);
            } else {
                context.failure(UaException.extract((Throwable)ex).orElse(new UaException(ex)));
            }
        });
    }

    @Override
    public void getReferences(ViewServices.BrowseContext context, ViewDescription view, NodeId nodeId) {
        ArrayList futures = new ArrayList();
        for (AddressSpace asx : this.addressSpaces) {
            ViewServices.BrowseContext browseContext = new ViewServices.BrowseContext(this.server, context.getSession().orElse(null));
            asx.getReferences(browseContext, view, nodeId);
            futures.add(browseContext.getFuture());
        }
        CompletionStage references = FutureUtils.sequence(futures).thenApply(refs -> refs.stream().flatMap(Collection::stream).distinct().collect(Collectors.toList()));
        ((CompletableFuture)((CompletableFuture)references).exceptionally(ex -> Collections.emptyList())).thenAccept(context::success);
    }

    @Override
    public void registerNodes(ViewServices.RegisterNodesContext context, List<NodeId> nodeIds) {
        CompletableFuture registeredNodeIds = GroupMapCollate.groupMapCollate(nodeIds, nodeId -> this.getAddressSpace(asx -> asx.getFilter().filterRegisterNode(this.server, (NodeId)nodeId)), asx -> group -> {
            ViewServices.RegisterNodesContext ctx = new ViewServices.RegisterNodesContext(this.server, (Session)context.getSession().orElse(null), context.getDiagnosticsContext());
            asx.registerNodes(ctx, group);
            return ctx.getFuture();
        });
        registeredNodeIds.thenAccept(context::success);
    }

    @Override
    public void unregisterNodes(ViewServices.UnregisterNodesContext context, List<NodeId> nodeIds) {
        CompletableFuture units = GroupMapCollate.groupMapCollate(nodeIds, nodeId -> this.getAddressSpace(asx -> asx.getFilter().filterUnregisterNode(this.server, (NodeId)nodeId)), asx -> group -> {
            ViewServices.UnregisterNodesContext ctx = new ViewServices.UnregisterNodesContext(this.server, (Session)context.getSession().orElse(null), context.getDiagnosticsContext());
            asx.unregisterNodes(ctx, group);
            return ctx.getFuture();
        });
        units.thenAccept(context::success);
    }

    @Override
    public void read(AttributeServices.ReadContext context, Double maxAge, TimestampsToReturn timestamps, List<ReadValueId> readValueIds) {
        CompletableFuture values = GroupMapCollate.groupMapCollate(readValueIds, readValueId -> this.getAddressSpace(asx -> asx.getFilter().filterRead(this.server, (ReadValueId)readValueId)), asx -> group -> {
            AttributeServices.ReadContext ctx = new AttributeServices.ReadContext(this.server, (Session)context.getSession().orElse(null), context.getDiagnosticsContext());
            asx.read(ctx, maxAge, timestamps, group);
            return ctx.getFuture();
        });
        values.thenAccept(context::success);
    }

    @Override
    public void write(AttributeServices.WriteContext context, List<WriteValue> writeValues) {
        CompletableFuture results = GroupMapCollate.groupMapCollate(writeValues, writeValue -> this.getAddressSpace(asx -> asx.getFilter().filterWrite(this.server, (WriteValue)writeValue)), asx -> group -> {
            AttributeServices.WriteContext ctx = new AttributeServices.WriteContext(this.server, (Session)context.getSession().orElse(null), context.getDiagnosticsContext());
            asx.write(ctx, group);
            return ctx.getFuture();
        });
        results.thenAccept(context::success);
    }

    @Override
    public void historyRead(AttributeHistoryServices.HistoryReadContext context, HistoryReadDetails details, TimestampsToReturn timestamps, List<HistoryReadValueId> readValueIds) {
        CompletableFuture results = GroupMapCollate.groupMapCollate(readValueIds, readValueId -> this.getAddressSpace(asx -> asx.getFilter().filterHistoryRead(this.server, (HistoryReadValueId)readValueId)), asx -> group -> {
            AttributeHistoryServices.HistoryReadContext ctx = new AttributeHistoryServices.HistoryReadContext(this.server, (Session)context.getSession().orElse(null), context.getDiagnosticsContext());
            asx.historyRead(ctx, details, timestamps, group);
            return ctx.getFuture();
        });
        results.thenAccept(context::success);
    }

    @Override
    public void historyUpdate(AttributeHistoryServices.HistoryUpdateContext context, List<HistoryUpdateDetails> updateDetailsList) {
        CompletableFuture results = GroupMapCollate.groupMapCollate(updateDetailsList, updateDetails -> this.getAddressSpace(asx -> asx.getFilter().filterHistoryUpdate(this.server, (HistoryUpdateDetails)updateDetails)), asx -> group -> {
            AttributeHistoryServices.HistoryUpdateContext ctx = new AttributeHistoryServices.HistoryUpdateContext(this.server, (Session)context.getSession().orElse(null), context.getDiagnosticsContext());
            asx.historyUpdate(ctx, group);
            return ctx.getFuture();
        });
        results.thenAccept(context::success);
    }

    @Override
    public void call(MethodServices.CallContext context, List<CallMethodRequest> requests) {
        CompletableFuture results = GroupMapCollate.groupMapCollate(requests, request -> this.getAddressSpace(asx -> asx.getFilter().filterCall(this.server, (CallMethodRequest)request)), asx -> group -> {
            MethodServices.CallContext ctx = new MethodServices.CallContext(this.server, (Session)context.getSession().orElse(null), context.getDiagnosticsContext());
            asx.call(ctx, group);
            return ctx.getFuture();
        });
        results.thenAccept(context::success);
    }

    @Override
    public void onCreateDataItem(ReadValueId itemToMonitor, Double requestedSamplingInterval, UInteger requestedQueueSize, BiConsumer<Double, UInteger> revisionCallback) {
        AddressSpace addressSpace = this.getAddressSpace(asx -> asx.getFilter().filterOnCreateDataItem(this.server, itemToMonitor));
        addressSpace.onCreateDataItem(itemToMonitor, requestedSamplingInterval, requestedQueueSize, revisionCallback);
    }

    @Override
    public void onModifyDataItem(ReadValueId itemToModify, Double requestedSamplingInterval, UInteger requestedQueueSize, BiConsumer<Double, UInteger> revisionCallback) {
        AddressSpace addressSpace = this.getAddressSpace(asx -> asx.getFilter().filterOnModifyDataItem(this.server, itemToModify));
        addressSpace.onModifyDataItem(itemToModify, requestedSamplingInterval, requestedQueueSize, revisionCallback);
    }

    @Override
    public void onCreateEventItem(ReadValueId itemToMonitor, UInteger requestedQueueSize, Consumer<UInteger> revisionCallback) {
        AddressSpace addressSpace = this.getAddressSpace(asx -> asx.getFilter().filterOnCreateEventItem(this.server, itemToMonitor));
        addressSpace.onCreateEventItem(itemToMonitor, requestedQueueSize, revisionCallback);
    }

    @Override
    public void onModifyEventItem(ReadValueId itemToModify, UInteger requestedQueueSize, Consumer<UInteger> revisionCallback) {
        AddressSpace addressSpace = this.getAddressSpace(asx -> asx.getFilter().filterOnModifyEventItem(this.server, itemToModify));
        addressSpace.onModifyEventItem(itemToModify, requestedQueueSize, revisionCallback);
    }

    @Override
    public void onDataItemsCreated(List<DataItem> dataItems) {
        Map<AddressSpace, List<DataItem>> byAddressSpace = dataItems.stream().collect(Collectors.groupingBy(item -> this.getAddressSpace(asx -> asx.getFilter().filterOnDataItemsCreated(this.server, item.getReadValueId()))));
        byAddressSpace.forEach(MonitoredItemServices::onDataItemsCreated);
    }

    @Override
    public void onDataItemsModified(List<DataItem> dataItems) {
        Map<AddressSpace, List<DataItem>> byAddressSpace = dataItems.stream().collect(Collectors.groupingBy(item -> this.getAddressSpace(asx -> asx.getFilter().filterOnDataItemsModified(this.server, item.getReadValueId()))));
        byAddressSpace.forEach(MonitoredItemServices::onDataItemsModified);
    }

    @Override
    public void onDataItemsDeleted(List<DataItem> dataItems) {
        Map<AddressSpace, List<DataItem>> byAddressSpace = dataItems.stream().collect(Collectors.groupingBy(item -> this.getAddressSpace(asx -> asx.getFilter().filterOnDataItemsDeleted(this.server, item.getReadValueId()))));
        byAddressSpace.forEach(MonitoredItemServices::onDataItemsDeleted);
    }

    @Override
    public void onEventItemsCreated(List<EventItem> eventItems) {
        Map<AddressSpace, List<EventItem>> byAddressSpace = eventItems.stream().collect(Collectors.groupingBy(item -> this.getAddressSpace(asx -> asx.getFilter().filterOnEventItemsCreated(this.server, item.getReadValueId()))));
        byAddressSpace.forEach(MonitoredItemServices::onEventItemsCreated);
    }

    @Override
    public void onEventItemsModified(List<EventItem> eventItems) {
        Map<AddressSpace, List<EventItem>> byAddressSpace = eventItems.stream().collect(Collectors.groupingBy(item -> this.getAddressSpace(asx -> asx.getFilter().filterOnEventItemsModified(this.server, item.getReadValueId()))));
        byAddressSpace.forEach(MonitoredItemServices::onEventItemsModified);
    }

    @Override
    public void onEventItemsDeleted(List<EventItem> eventItems) {
        Map<AddressSpace, List<EventItem>> byAddressSpace = eventItems.stream().collect(Collectors.groupingBy(item -> this.getAddressSpace(asx -> asx.getFilter().filterOnEventItemsDeleted(this.server, item.getReadValueId()))));
        byAddressSpace.forEach(MonitoredItemServices::onEventItemsDeleted);
    }

    @Override
    public void onMonitoringModeChanged(List<MonitoredItem> monitoredItems) {
        Map<AddressSpace, List<MonitoredItem>> byAddressSpace = monitoredItems.stream().collect(Collectors.groupingBy(item -> this.getAddressSpace(asx -> asx.getFilter().filterOnMonitoringModeChanged(this.server, item.getReadValueId()))));
        byAddressSpace.forEach(MonitoredItemServices::onMonitoringModeChanged);
    }

    @Override
    public void addNodes(NodeManagementServices.AddNodesContext context, List<AddNodesItem> nodesToAdd) {
        CompletableFuture results = GroupMapCollate.groupMapCollate(nodesToAdd, addNodesItem -> this.getAddressSpace(asx -> asx.getFilter().filterAddNodes(this.server, (AddNodesItem)addNodesItem)), asx -> group -> {
            NodeManagementServices.AddNodesContext ctx = new NodeManagementServices.AddNodesContext(this.server, (Session)context.getSession().orElse(null), context.getDiagnosticsContext());
            asx.addNodes(ctx, group);
            return ctx.getFuture();
        });
        results.thenAccept(context::success);
    }

    @Override
    public void deleteNodes(NodeManagementServices.DeleteNodesContext context, List<DeleteNodesItem> nodesToDelete) {
        CompletableFuture results = GroupMapCollate.groupMapCollate(nodesToDelete, deleteNodesItem -> this.getAddressSpace(asx -> asx.getFilter().filterDeleteNodes(this.server, (DeleteNodesItem)deleteNodesItem)), asx -> group -> {
            NodeManagementServices.DeleteNodesContext ctx = new NodeManagementServices.DeleteNodesContext(this.server, (Session)context.getSession().orElse(null), context.getDiagnosticsContext());
            asx.deleteNodes(ctx, group);
            return ctx.getFuture();
        });
        results.thenAccept(context::success);
    }

    @Override
    public void addReferences(NodeManagementServices.AddReferencesContext context, List<AddReferencesItem> referencesToAdd) {
        CompletableFuture results = GroupMapCollate.groupMapCollate(referencesToAdd, addReferencesItem -> this.getAddressSpace(asx -> asx.getFilter().filterAddReferences(this.server, (AddReferencesItem)addReferencesItem)), asx -> group -> {
            NodeManagementServices.AddReferencesContext ctx = new NodeManagementServices.AddReferencesContext(this.server, (Session)context.getSession().orElse(null), context.getDiagnosticsContext());
            asx.addReferences(ctx, group);
            return ctx.getFuture();
        });
        results.thenAccept(context::success);
    }

    @Override
    public void deleteReferences(NodeManagementServices.DeleteReferencesContext context, List<DeleteReferencesItem> referencesToDelete) {
        CompletableFuture results = GroupMapCollate.groupMapCollate(referencesToDelete, deleteReferencesItem -> this.getAddressSpace(asx -> asx.getFilter().filterDeleteReferences(this.server, (DeleteReferencesItem)deleteReferencesItem)), asx -> group -> {
            NodeManagementServices.DeleteReferencesContext ctx = new NodeManagementServices.DeleteReferencesContext(this.server, (Session)context.getSession().orElse(null), context.getDiagnosticsContext());
            asx.deleteReferences(ctx, group);
            return ctx.getFuture();
        });
        results.thenAccept(context::success);
    }

    private static class EmptyAddressSpace
    extends ManagedAddressSpace {
        EmptyAddressSpace(OpcUaServer server) {
            super(server);
        }

        @Override
        protected void onStartup() {
            throw new IllegalStateException("EmptyAddressSpace onStartup()");
        }

        @Override
        protected void onShutdown() {
            throw new IllegalStateException("EmptyAddressSpace onShutdown()");
        }

        @Override
        public AddressSpaceFilter getFilter() {
            return new SimpleAddressSpaceFilter(){

                @Override
                protected boolean filter(NodeId nodeId) {
                    return true;
                }
            };
        }

        @Override
        public void onDataItemsCreated(List<DataItem> dataItems) {
        }

        @Override
        public void onDataItemsModified(List<DataItem> dataItems) {
        }

        @Override
        public void onDataItemsDeleted(List<DataItem> dataItems) {
        }

        @Override
        public void onMonitoringModeChanged(List<MonitoredItem> monitoredItems) {
        }
    }

    private static class CompositeAddressSpaceFilter
    implements AddressSpaceFilter {
        private final List<AddressSpace> addressSpaces;

        CompositeAddressSpaceFilter(List<AddressSpace> addressSpaces) {
            this.addressSpaces = addressSpaces;
        }

        @Override
        public boolean filterBrowse(OpcUaServer server, NodeId nodeId) {
            return this.addressSpaces.stream().anyMatch(asx -> asx.getFilter().filterBrowse(server, nodeId));
        }

        @Override
        public boolean filterRegisterNode(OpcUaServer server, NodeId nodeId) {
            return this.addressSpaces.stream().anyMatch(asx -> asx.getFilter().filterRegisterNode(server, nodeId));
        }

        @Override
        public boolean filterUnregisterNode(OpcUaServer server, NodeId nodeId) {
            return this.addressSpaces.stream().anyMatch(asx -> asx.getFilter().filterUnregisterNode(server, nodeId));
        }

        @Override
        public boolean filterRead(OpcUaServer server, ReadValueId readValueId) {
            return this.addressSpaces.stream().anyMatch(asx -> asx.getFilter().filterRead(server, readValueId));
        }

        @Override
        public boolean filterWrite(OpcUaServer server, WriteValue writeValue) {
            return this.addressSpaces.stream().anyMatch(asx -> asx.getFilter().filterWrite(server, writeValue));
        }

        @Override
        public boolean filterHistoryRead(OpcUaServer server, HistoryReadValueId historyReadValueId) {
            return this.addressSpaces.stream().anyMatch(asx -> asx.getFilter().filterHistoryRead(server, historyReadValueId));
        }

        @Override
        public boolean filterHistoryUpdate(OpcUaServer server, HistoryUpdateDetails historyUpdateDetails) {
            return this.addressSpaces.stream().anyMatch(asx -> asx.getFilter().filterHistoryUpdate(server, historyUpdateDetails));
        }

        @Override
        public boolean filterCall(OpcUaServer server, CallMethodRequest callMethodRequest) {
            return this.addressSpaces.stream().anyMatch(asx -> asx.getFilter().filterCall(server, callMethodRequest));
        }

        @Override
        public boolean filterOnCreateDataItem(OpcUaServer server, ReadValueId readValueId) {
            return this.addressSpaces.stream().anyMatch(asx -> asx.getFilter().filterOnCreateDataItem(server, readValueId));
        }

        @Override
        public boolean filterOnModifyDataItem(OpcUaServer server, ReadValueId readValueId) {
            return this.addressSpaces.stream().anyMatch(asx -> asx.getFilter().filterOnModifyDataItem(server, readValueId));
        }

        @Override
        public boolean filterOnCreateEventItem(OpcUaServer server, ReadValueId readValueId) {
            return this.addressSpaces.stream().anyMatch(asx -> asx.getFilter().filterOnCreateEventItem(server, readValueId));
        }

        @Override
        public boolean filterOnModifyEventItem(OpcUaServer server, ReadValueId readValueId) {
            return this.addressSpaces.stream().anyMatch(asx -> asx.getFilter().filterOnModifyEventItem(server, readValueId));
        }

        @Override
        public boolean filterOnDataItemsCreated(OpcUaServer server, ReadValueId readValueId) {
            return this.addressSpaces.stream().anyMatch(asx -> asx.getFilter().filterOnDataItemsCreated(server, readValueId));
        }

        @Override
        public boolean filterOnDataItemsModified(OpcUaServer server, ReadValueId readValueId) {
            return this.addressSpaces.stream().anyMatch(asx -> asx.getFilter().filterOnDataItemsModified(server, readValueId));
        }

        @Override
        public boolean filterOnDataItemsDeleted(OpcUaServer server, ReadValueId readValueId) {
            return this.addressSpaces.stream().anyMatch(asx -> asx.getFilter().filterOnDataItemsDeleted(server, readValueId));
        }

        @Override
        public boolean filterOnEventItemsCreated(OpcUaServer server, ReadValueId readValueId) {
            return this.addressSpaces.stream().anyMatch(asx -> asx.getFilter().filterOnEventItemsCreated(server, readValueId));
        }

        @Override
        public boolean filterOnEventItemsModified(OpcUaServer server, ReadValueId readValueId) {
            return this.addressSpaces.stream().anyMatch(asx -> asx.getFilter().filterOnEventItemsModified(server, readValueId));
        }

        @Override
        public boolean filterOnEventItemsDeleted(OpcUaServer server, ReadValueId readValueId) {
            return this.addressSpaces.stream().anyMatch(asx -> asx.getFilter().filterOnEventItemsDeleted(server, readValueId));
        }

        @Override
        public boolean filterOnMonitoringModeChanged(OpcUaServer server, ReadValueId readValueId) {
            return this.addressSpaces.stream().anyMatch(asx -> asx.getFilter().filterOnMonitoringModeChanged(server, readValueId));
        }

        @Override
        public boolean filterAddNodes(OpcUaServer server, AddNodesItem addNodesItem) {
            return this.addressSpaces.stream().anyMatch(asx -> asx.getFilter().filterAddNodes(server, addNodesItem));
        }

        @Override
        public boolean filterDeleteNodes(OpcUaServer server, DeleteNodesItem deleteNodesItem) {
            return this.addressSpaces.stream().anyMatch(asx -> asx.getFilter().filterDeleteNodes(server, deleteNodesItem));
        }

        @Override
        public boolean filterAddReferences(OpcUaServer server, AddReferencesItem addReferencesItem) {
            return this.addressSpaces.stream().anyMatch(asx -> asx.getFilter().filterAddReferences(server, addReferencesItem));
        }

        @Override
        public boolean filterDeleteReferences(OpcUaServer server, DeleteReferencesItem deleteReferencesItem) {
            return this.addressSpaces.stream().anyMatch(asx -> asx.getFilter().filterDeleteReferences(server, deleteReferencesItem));
        }
    }
}

