/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.api;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.eclipse.milo.opcua.sdk.core.Reference;
import org.eclipse.milo.opcua.sdk.server.AbstractLifecycle;
import org.eclipse.milo.opcua.sdk.server.OpcUaServer;
import org.eclipse.milo.opcua.sdk.server.UaNodeManager;
import org.eclipse.milo.opcua.sdk.server.api.AddressSpaceServices;
import org.eclipse.milo.opcua.sdk.server.api.NodeManager;
import org.eclipse.milo.opcua.sdk.server.api.methods.MethodInvocationHandler;
import org.eclipse.milo.opcua.sdk.server.api.services.AttributeServices;
import org.eclipse.milo.opcua.sdk.server.api.services.MethodServices;
import org.eclipse.milo.opcua.sdk.server.api.services.ViewServices;
import org.eclipse.milo.opcua.sdk.server.nodes.AttributeContext;
import org.eclipse.milo.opcua.sdk.server.nodes.UaMethodNode;
import org.eclipse.milo.opcua.sdk.server.nodes.UaNode;
import org.eclipse.milo.opcua.sdk.server.nodes.UaNodeContext;
import org.eclipse.milo.opcua.sdk.server.nodes.UaObjectNode;
import org.eclipse.milo.opcua.sdk.server.nodes.UaObjectTypeNode;
import org.eclipse.milo.opcua.sdk.server.nodes.UaServerNode;
import org.eclipse.milo.opcua.sdk.server.nodes.factories.NodeFactory;
import org.eclipse.milo.opcua.stack.core.AttributeId;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.DiagnosticInfo;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.enumerated.TimestampsToReturn;
import org.eclipse.milo.opcua.stack.core.types.structured.CallMethodRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.CallMethodResult;
import org.eclipse.milo.opcua.stack.core.types.structured.ReadValueId;
import org.eclipse.milo.opcua.stack.core.types.structured.ViewDescription;
import org.eclipse.milo.opcua.stack.core.types.structured.WriteValue;
import org.eclipse.milo.opcua.stack.core.util.Unit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ManagedAddressSpaceServices
extends AbstractLifecycle
implements AddressSpaceServices {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final UaNodeManager nodeManager = new UaNodeManager();
    private final UaNodeContext nodeContext;
    private final NodeFactory nodeFactory;
    private final OpcUaServer server;

    public ManagedAddressSpaceServices(final OpcUaServer server) {
        this.server = server;
        this.nodeContext = new UaNodeContext(){

            @Override
            public OpcUaServer getServer() {
                return server;
            }

            @Override
            public NodeManager<UaNode> getNodeManager() {
                return ManagedAddressSpaceServices.this.nodeManager;
            }
        };
        this.nodeFactory = this.createNodeFactory();
    }

    protected NodeFactory createNodeFactory() {
        return new NodeFactory(this.nodeContext);
    }

    protected OpcUaServer getServer() {
        return this.server;
    }

    protected UaNodeContext getNodeContext() {
        return this.nodeContext;
    }

    protected NodeFactory getNodeFactory() {
        return this.nodeFactory;
    }

    protected UaNodeManager getNodeManager() {
        return this.nodeManager;
    }

    @Override
    protected void onStartup() {
        this.registerNodeManager(this.nodeManager);
    }

    @Override
    protected void onShutdown() {
        this.unregisterNodeManager(this.nodeManager);
    }

    protected void registerNodeManager(UaNodeManager nodeManager) {
        this.server.getAddressSpaceManager().register(nodeManager);
    }

    protected void unregisterNodeManager(UaNodeManager nodeManager) {
        this.server.getAddressSpaceManager().unregister(nodeManager);
    }

    @Override
    public void browse(ViewServices.BrowseContext context, ViewDescription viewDescription, NodeId nodeId) {
        if (this.nodeManager.containsNode(nodeId)) {
            List<Reference> references = this.nodeManager.getReferences(nodeId);
            this.logger.debug("Browsed {} references for {}", (Object)references.size(), (Object)nodeId);
            context.success(references);
        } else {
            context.failure(2150891520L);
        }
    }

    @Override
    public void getReferences(ViewServices.BrowseContext context, ViewDescription viewDescription, NodeId nodeId) {
        List<Reference> references = this.nodeManager.getReferences(nodeId);
        this.logger.debug("Got {} references for {}", (Object)references.size(), (Object)nodeId);
        context.success(references);
    }

    @Override
    public void registerNodes(ViewServices.RegisterNodesContext context, List<NodeId> nodeIds) {
        context.success(nodeIds);
    }

    @Override
    public void unregisterNodes(ViewServices.UnregisterNodesContext context, List<NodeId> nodeIds) {
        context.success(Collections.nCopies(nodeIds.size(), Unit.VALUE));
    }

    @Override
    public void read(AttributeServices.ReadContext context, Double maxAge, TimestampsToReturn timestamps, List<ReadValueId> readValueIds) {
        ArrayList results = Lists.newArrayListWithCapacity((int)readValueIds.size());
        for (ReadValueId readValueId : readValueIds) {
            UaServerNode node = (UaServerNode)this.nodeManager.get(readValueId.getNodeId());
            if (node != null) {
                DataValue value = node.readAttribute(new AttributeContext(context), readValueId.getAttributeId(), timestamps, readValueId.getIndexRange(), readValueId.getDataEncoding());
                this.logger.debug("Read value {} from attribute {} of {}", new Object[]{value.getValue().getValue(), AttributeId.from((UInteger)readValueId.getAttributeId()).map(Object::toString).orElse("unknown"), node.getNodeId()});
                results.add(value);
                continue;
            }
            results.add(new DataValue(2150891520L));
        }
        context.success(results);
    }

    @Override
    public void write(AttributeServices.WriteContext context, List<WriteValue> writeValues) {
        ArrayList results = Lists.newArrayListWithCapacity((int)writeValues.size());
        for (WriteValue writeValue : writeValues) {
            UaServerNode node = (UaServerNode)this.nodeManager.get(writeValue.getNodeId());
            if (node != null) {
                try {
                    node.writeAttribute(new AttributeContext(context), writeValue.getAttributeId(), writeValue.getValue(), writeValue.getIndexRange());
                    results.add(StatusCode.GOOD);
                    this.logger.debug("Wrote value {} to {} attribute of {}", new Object[]{writeValue.getValue().getValue(), AttributeId.from((UInteger)writeValue.getAttributeId()).map(Object::toString).orElse("unknown"), node.getNodeId()});
                }
                catch (UaException e) {
                    this.logger.error("Unable to write value={}", (Object)writeValue.getValue(), (Object)e);
                    results.add(e.getStatusCode());
                }
                continue;
            }
            results.add(new StatusCode(2150891520L));
        }
        context.success(results);
    }

    @Override
    public void call(MethodServices.CallContext context, List<CallMethodRequest> requests) {
        ArrayList results = Lists.newArrayListWithCapacity((int)requests.size());
        for (CallMethodRequest request : requests) {
            MethodInvocationHandler handler = this.getInvocationHandler(request.getObjectId(), request.getMethodId()).orElse(MethodInvocationHandler.NODE_ID_UNKNOWN);
            try {
                results.add(handler.invoke(context, request));
            }
            catch (Throwable t) {
                LoggerFactory.getLogger(this.getClass()).error("Uncaught Throwable invoking method handler for methodId={}.", (Object)request.getMethodId(), (Object)t);
                results.add(new CallMethodResult(new StatusCode(0x80020000L), new StatusCode[0], new DiagnosticInfo[0], new Variant[0]));
            }
        }
        context.success(results);
    }

    protected Optional<MethodInvocationHandler> getInvocationHandler(NodeId objectId, NodeId methodId) {
        return this.nodeManager.getNode(objectId).flatMap(node -> {
            UaMethodNode methodNode = null;
            if (node instanceof UaObjectNode) {
                UaObjectNode objectNode = (UaObjectNode)node;
                methodNode = objectNode.findMethodNode(methodId);
            } else if (node instanceof UaObjectTypeNode) {
                UaObjectTypeNode objectTypeNode = (UaObjectTypeNode)node;
                methodNode = objectTypeNode.findMethodNode(methodId);
            }
            if (methodNode != null) {
                return Optional.of(methodNode.getInvocationHandler());
            }
            return Optional.empty();
        });
    }
}

