/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.api.config;

import java.security.KeyPair;
import java.security.cert.X509Certificate;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import org.eclipse.milo.opcua.sdk.server.api.config.OpcUaServerConfig;
import org.eclipse.milo.opcua.sdk.server.api.config.OpcUaServerConfigLimits;
import org.eclipse.milo.opcua.sdk.server.identity.AnonymousIdentityValidator;
import org.eclipse.milo.opcua.sdk.server.identity.IdentityValidator;
import org.eclipse.milo.opcua.stack.core.channel.MessageLimits;
import org.eclipse.milo.opcua.stack.core.security.CertificateManager;
import org.eclipse.milo.opcua.stack.core.security.TrustListManager;
import org.eclipse.milo.opcua.stack.core.serialization.EncodingLimits;
import org.eclipse.milo.opcua.stack.core.types.builtin.DateTime;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.structured.BuildInfo;
import org.eclipse.milo.opcua.stack.server.EndpointConfiguration;
import org.eclipse.milo.opcua.stack.server.UaStackServerConfig;
import org.eclipse.milo.opcua.stack.server.UaStackServerConfigBuilder;
import org.eclipse.milo.opcua.stack.server.security.ServerCertificateValidator;

public class OpcUaServerConfigBuilder
extends UaStackServerConfigBuilder {
    private IdentityValidator identityValidator = AnonymousIdentityValidator.INSTANCE;
    private BuildInfo buildInfo = new BuildInfo("", "", "", "", "", DateTime.MIN_VALUE);
    private OpcUaServerConfigLimits limits = new OpcUaServerConfigLimits(){};

    public OpcUaServerConfigBuilder setIdentityValidator(IdentityValidator identityValidator) {
        this.identityValidator = identityValidator;
        return this;
    }

    public OpcUaServerConfigBuilder setBuildInfo(BuildInfo buildInfo) {
        this.buildInfo = buildInfo;
        return this;
    }

    public OpcUaServerConfigBuilder setLimits(OpcUaServerConfigLimits limits) {
        this.limits = limits;
        return this;
    }

    public OpcUaServerConfigBuilder setEndpoints(Set<EndpointConfiguration> endpointConfigurations) {
        super.setEndpoints(endpointConfigurations);
        return this;
    }

    public OpcUaServerConfigBuilder setApplicationName(LocalizedText applicationName) {
        super.setApplicationName(applicationName);
        return this;
    }

    public OpcUaServerConfigBuilder setApplicationUri(String applicationUri) {
        super.setApplicationUri(applicationUri);
        return this;
    }

    public OpcUaServerConfigBuilder setProductUri(String productUri) {
        super.setProductUri(productUri);
        return this;
    }

    public OpcUaServerConfigBuilder setCertificateManager(CertificateManager certificateManager) {
        super.setCertificateManager(certificateManager);
        return this;
    }

    public OpcUaServerConfigBuilder setTrustListManager(TrustListManager trustListManager) {
        super.setTrustListManager(trustListManager);
        return this;
    }

    public OpcUaServerConfigBuilder setCertificateValidator(ServerCertificateValidator certificateValidator) {
        super.setCertificateValidator(certificateValidator);
        return this;
    }

    public OpcUaServerConfigBuilder setHttpsKeyPair(KeyPair httpsKeyPair) {
        super.setHttpsKeyPair(httpsKeyPair);
        return this;
    }

    public OpcUaServerConfigBuilder setHttpsCertificate(X509Certificate httpsCertificate) {
        super.setHttpsCertificate(httpsCertificate);
        return this;
    }

    public OpcUaServerConfigBuilder setExecutor(ExecutorService executor) {
        super.setExecutor(executor);
        return this;
    }

    public OpcUaServerConfigBuilder setMessageLimits(MessageLimits messageLimits) {
        super.setMessageLimits(messageLimits);
        return this;
    }

    public OpcUaServerConfigBuilder setEncodingLimits(EncodingLimits encodingLimits) {
        super.setEncodingLimits(encodingLimits);
        return this;
    }

    public OpcUaServerConfig build() {
        UaStackServerConfig stackServerConfig = super.build();
        return new OpcUaServerConfigImpl(stackServerConfig, this.identityValidator, this.buildInfo, this.limits);
    }

    public static final class OpcUaServerConfigImpl
    implements OpcUaServerConfig {
        private final UaStackServerConfig stackServerConfig;
        private final IdentityValidator identityValidator;
        private final BuildInfo buildInfo;
        private final OpcUaServerConfigLimits limits;

        public OpcUaServerConfigImpl(UaStackServerConfig stackServerConfig, IdentityValidator identityValidator, BuildInfo buildInfo, OpcUaServerConfigLimits limits) {
            this.stackServerConfig = stackServerConfig;
            this.identityValidator = identityValidator;
            this.buildInfo = buildInfo;
            this.limits = limits;
        }

        @Override
        public IdentityValidator getIdentityValidator() {
            return this.identityValidator;
        }

        @Override
        public BuildInfo getBuildInfo() {
            return this.buildInfo;
        }

        @Override
        public OpcUaServerConfigLimits getLimits() {
            return this.limits;
        }

        public Set<EndpointConfiguration> getEndpoints() {
            return this.stackServerConfig.getEndpoints();
        }

        public LocalizedText getApplicationName() {
            return this.stackServerConfig.getApplicationName();
        }

        public String getApplicationUri() {
            return this.stackServerConfig.getApplicationUri();
        }

        public String getProductUri() {
            return this.stackServerConfig.getProductUri();
        }

        public CertificateManager getCertificateManager() {
            return this.stackServerConfig.getCertificateManager();
        }

        public TrustListManager getTrustListManager() {
            return this.stackServerConfig.getTrustListManager();
        }

        public ServerCertificateValidator getCertificateValidator() {
            return this.stackServerConfig.getCertificateValidator();
        }

        public Optional<KeyPair> getHttpsKeyPair() {
            return this.stackServerConfig.getHttpsKeyPair();
        }

        public Optional<X509Certificate> getHttpsCertificate() {
            return this.stackServerConfig.getHttpsCertificate();
        }

        public ExecutorService getExecutor() {
            return this.stackServerConfig.getExecutor();
        }

        public MessageLimits getMessageLimits() {
            return this.stackServerConfig.getMessageLimits();
        }

        public EncodingLimits getEncodingLimits() {
            return this.stackServerConfig.getEncodingLimits();
        }
    }
}

