/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.diagnostics;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.eclipse.milo.opcua.sdk.core.AccessLevel;
import org.eclipse.milo.opcua.sdk.server.AbstractLifecycle;
import org.eclipse.milo.opcua.sdk.server.OpcUaServer;
import org.eclipse.milo.opcua.sdk.server.Session;
import org.eclipse.milo.opcua.sdk.server.SessionListener;
import org.eclipse.milo.opcua.sdk.server.UaNodeManager;
import org.eclipse.milo.opcua.sdk.server.diagnostics.ArrayValueAttributeFilter;
import org.eclipse.milo.opcua.sdk.server.diagnostics.ComplexValueAttributeFilter;
import org.eclipse.milo.opcua.sdk.server.model.nodes.objects.ServerDiagnosticsTypeNode;
import org.eclipse.milo.opcua.sdk.server.model.nodes.objects.SessionDiagnosticsObjectTypeNode;
import org.eclipse.milo.opcua.sdk.server.model.nodes.objects.SessionsDiagnosticsSummaryTypeNode;
import org.eclipse.milo.opcua.sdk.server.model.nodes.variables.ServerDiagnosticsSummaryTypeNode;
import org.eclipse.milo.opcua.sdk.server.model.nodes.variables.SessionDiagnosticsArrayTypeNode;
import org.eclipse.milo.opcua.sdk.server.model.nodes.variables.SessionDiagnosticsVariableTypeNode;
import org.eclipse.milo.opcua.sdk.server.model.nodes.variables.SessionSecurityDiagnosticsArrayTypeNode;
import org.eclipse.milo.opcua.sdk.server.model.nodes.variables.SessionSecurityDiagnosticsTypeNode;
import org.eclipse.milo.opcua.sdk.server.nodes.factories.NodeFactory;
import org.eclipse.milo.opcua.sdk.server.nodes.filters.AttributeFilter;
import org.eclipse.milo.opcua.sdk.server.nodes.filters.AttributeFilters;
import org.eclipse.milo.opcua.stack.core.Identifiers;
import org.eclipse.milo.opcua.stack.core.Stack;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.serialization.SerializationContext;
import org.eclipse.milo.opcua.stack.core.serialization.UaStructure;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExtensionObject;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;
import org.eclipse.milo.opcua.stack.core.types.structured.SubscriptionDiagnosticsDataType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DiagnosticsManager
extends AbstractLifecycle {
    private final Logger logger = LoggerFactory.getLogger(DiagnosticsManager.class);
    private final List<Runnable> diagnosticTasks = Collections.synchronizedList(new ArrayList());
    private ServerDiagnosticsObject serverDiagnosticsObject;
    private long updateRateMillis = 1000L;
    private ScheduledFuture<?> updateTasksFuture;
    private final OpcUaServer server;
    private final NodeFactory nodeFactory;
    private final UaNodeManager nodeManager;

    public DiagnosticsManager(OpcUaServer server, NodeFactory nodeFactory, UaNodeManager nodeManager) {
        this.server = server;
        this.nodeFactory = nodeFactory;
        this.nodeManager = nodeManager;
    }

    public OpcUaServer getServer() {
        return this.server;
    }

    @Override
    protected void onStartup() {
        ServerDiagnosticsTypeNode serverDiagnosticsNode = (ServerDiagnosticsTypeNode)this.getServer().getAddressSpaceManager().getManagedNode(Identifiers.Server_ServerDiagnostics).orElseThrow(() -> new NoSuchElementException("NodeId: " + Identifiers.Server_ServerDiagnostics));
        serverDiagnosticsNode.getEnabledFlagNode().setUserAccessLevel(AccessLevel.toValue((Set)AccessLevel.READ_WRITE));
        serverDiagnosticsNode.getEnabledFlagNode().getFilterChain().addLast(AttributeFilters.getValue(ctx -> new DataValue(new Variant((Object)this.isDiagnosticsEnabled()))), AttributeFilters.setValue((ctx, value) -> this.setDiagnosticsEnabled((Boolean)value.getValue().getValue())));
    }

    @Override
    protected void onShutdown() {
        if (this.updateTasksFuture != null) {
            this.updateTasksFuture.cancel(false);
            this.updateTasksFuture = null;
        }
        if (this.serverDiagnosticsObject != null) {
            this.serverDiagnosticsObject.shutdown();
            this.serverDiagnosticsObject = null;
        }
    }

    public synchronized void setDiagnosticsEnabled(boolean diagnosticsEnabled) {
        if (diagnosticsEnabled) {
            if (this.updateTasksFuture == null) {
                if (this.serverDiagnosticsObject != null) {
                    this.serverDiagnosticsObject.shutdown();
                }
                ServerDiagnosticsTypeNode serverDiagnosticsNode = (ServerDiagnosticsTypeNode)this.getServer().getAddressSpaceManager().getManagedNode(Identifiers.Server_ServerDiagnostics).orElseThrow(() -> new NoSuchElementException("NodeId: " + Identifiers.Server_ServerDiagnostics));
                this.serverDiagnosticsObject = new ServerDiagnosticsObject(serverDiagnosticsNode);
                this.serverDiagnosticsObject.startup();
                this.updateTasksFuture = Stack.sharedScheduledExecutor().scheduleWithFixedDelay(this::runUpdateTasks, 0L, this.getUpdateRate(), TimeUnit.MILLISECONDS);
            }
        } else if (this.updateTasksFuture != null) {
            this.updateTasksFuture.cancel(false);
            this.updateTasksFuture = null;
        }
    }

    public synchronized boolean isDiagnosticsEnabled() {
        return this.updateTasksFuture != null;
    }

    public synchronized void setUpdateRate(long updateRateMillis) {
        Preconditions.checkArgument((updateRateMillis > 0L ? 1 : 0) != 0, (Object)"update rate must be > 0");
        this.updateRateMillis = updateRateMillis;
        if (this.updateTasksFuture != null) {
            this.updateTasksFuture.cancel(false);
            this.updateTasksFuture = Stack.sharedScheduledExecutor().scheduleWithFixedDelay(() -> Stack.sharedExecutor().execute(this::runUpdateTasks), 0L, updateRateMillis, TimeUnit.MILLISECONDS);
        }
    }

    public synchronized long getUpdateRate() {
        return this.updateRateMillis;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runUpdateTasks() {
        List<Runnable> list = this.diagnosticTasks;
        synchronized (list) {
            this.diagnosticTasks.forEach(r -> {
                try {
                    r.run();
                }
                catch (Throwable t) {
                    this.logger.warn("Uncaught exception running diagnostic task", t);
                }
            });
        }
    }

    class SessionDiagnosticsObject
    extends AbstractLifecycle {
        private final Logger logger = LoggerFactory.getLogger(this.getClass());
        private final List<Runnable> registeredTasks = Collections.synchronizedList(new ArrayList());
        private SessionDiagnosticsObjectTypeNode node;
        private final Session session;
        private final SessionsDiagnosticsSummaryTypeNode summaryNode;

        SessionDiagnosticsObject(Session session, SessionsDiagnosticsSummaryTypeNode summaryNode) {
            Preconditions.checkNotNull((Object)session, (Object)"Session");
            Preconditions.checkNotNull((Object)summaryNode, (Object)"SessionsDiagnosticsSummaryTypeNode");
            this.session = session;
            this.summaryNode = summaryNode;
        }

        @Override
        protected synchronized void onStartup() {
            this.logger.debug("SessionDiagnosticsObject onStartup()");
            try {
                this.node = (SessionDiagnosticsObjectTypeNode)DiagnosticsManager.this.nodeFactory.createNode(new NodeId(0, UUID.randomUUID()), Identifiers.SessionDiagnosticsObjectType);
                this.node.setBrowseName(new QualifiedName(1, this.session.getSessionName()));
                this.node.setDisplayName(LocalizedText.english((String)this.session.getSessionName()));
                DiagnosticsManager.this.nodeManager.addNode(this.node);
                this.summaryNode.addComponent(this.node);
                this.configureSessionDiagnostics();
                this.configureSessionSecurityDiagnostics();
                this.configureSubscriptionDiagnosticsArray();
            }
            catch (UaException e) {
                this.logger.error("Error starting SessionDiagnosticsObject: {}", (Object)e.getMessage(), (Object)e);
            }
        }

        @Override
        protected synchronized void onShutdown() {
            this.logger.debug("SessionDiagnosticsObject onShutdown()");
            DiagnosticsManager.this.diagnosticTasks.removeAll(this.registeredTasks);
            this.registeredTasks.clear();
            if (this.node != null) {
                this.node.delete();
                this.summaryNode.removeComponent(this.node);
            }
        }

        private void configureSessionDiagnostics() {
            SessionDiagnosticsVariableTypeNode sessionDiagnosticsNode = this.node.getSessionDiagnosticsNode();
            sessionDiagnosticsNode.getFilterChain().addLast((AttributeFilter)new ComplexValueAttributeFilter());
            Runnable updateTask = () -> {
                ExtensionObject xo = ExtensionObject.encode((SerializationContext)DiagnosticsManager.this.getServer().getSerializationContext(), (UaStructure)this.session.getSessionDiagnostics().getSessionDiagnosticsDataType());
                sessionDiagnosticsNode.setValue(new DataValue(new Variant((Object)xo)));
            };
            DiagnosticsManager.this.diagnosticTasks.add(updateTask);
            this.registeredTasks.add(updateTask);
        }

        private void configureSessionSecurityDiagnostics() {
            SessionSecurityDiagnosticsTypeNode sessionSecurityDiagnosticsNode = this.node.getSessionSecurityDiagnosticsNode();
            sessionSecurityDiagnosticsNode.getFilterChain().addLast((AttributeFilter)new ComplexValueAttributeFilter());
            Runnable updateTask = () -> {
                ExtensionObject xo = ExtensionObject.encode((SerializationContext)DiagnosticsManager.this.getServer().getSerializationContext(), (UaStructure)this.session.getSessionSecurityDiagnostics().getSessionSecurityDiagnosticsDataType());
                sessionSecurityDiagnosticsNode.setValue(new DataValue(new Variant((Object)xo)));
            };
            DiagnosticsManager.this.diagnosticTasks.add(updateTask);
            this.registeredTasks.add(updateTask);
        }

        private void configureSubscriptionDiagnosticsArray() {
            this.node.getSubscriptionDiagnosticsArrayNode().getFilterChain().addLast((AttributeFilter)new ArrayValueAttributeFilter(Identifiers.SubscriptionDiagnosticsType){

                @Override
                protected String getElementNodeName(String arrayNodeName, Object value, int index) {
                    if (value instanceof SubscriptionDiagnosticsDataType) {
                        return ((SubscriptionDiagnosticsDataType)value).getSubscriptionId().toString();
                    }
                    return super.getElementNodeName(arrayNodeName, value, index);
                }
            });
            Runnable updateTask = () -> {
                SubscriptionDiagnosticsDataType[] value = (SubscriptionDiagnosticsDataType[])this.session.getSubscriptionManager().getSubscriptions().stream().map(s -> s.getSubscriptionDiagnostics().getSubscriptionDiagnosticsDataType()).toArray(SubscriptionDiagnosticsDataType[]::new);
                this.node.getSubscriptionDiagnosticsArrayNode().setValue(new DataValue(new Variant((Object)value)));
            };
            DiagnosticsManager.this.diagnosticTasks.add(updateTask);
            this.registeredTasks.add(updateTask);
        }
    }

    class SessionsDiagnosticsSummaryObject
    extends AbstractLifecycle {
        private final Logger logger = LoggerFactory.getLogger(this.getClass());
        private final List<Runnable> registeredTasks = Collections.synchronizedList(new ArrayList());
        private final Map<NodeId, SessionDiagnosticsObject> sessionDiagnosticsObjects = Maps.newConcurrentMap();
        private SessionListener sessionListener;
        private final SessionsDiagnosticsSummaryTypeNode node;

        SessionsDiagnosticsSummaryObject(SessionsDiagnosticsSummaryTypeNode node) {
            Preconditions.checkNotNull((Object)node, (Object)"SessionsDiagnosticsSummaryTypeNode");
            this.node = node;
        }

        @Override
        protected synchronized void onStartup() {
            this.logger.debug("SessionsDiagnosticsSummaryObject onStartup()");
            this.configureSessionDiagnosticsArray();
            this.configureSessionSecurityDiagnosticsArray();
            DiagnosticsManager.this.getServer().getSessionManager().getAllSessions().forEach(session -> {
                SessionDiagnosticsObject sdo = new SessionDiagnosticsObject((Session)session, this.node);
                this.sessionDiagnosticsObjects.put(session.getSessionId(), sdo);
                sdo.startup();
            });
            this.sessionListener = new SessionListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onSessionCreated(Session session) {
                    SessionsDiagnosticsSummaryObject sessionsDiagnosticsSummaryObject = SessionsDiagnosticsSummaryObject.this;
                    synchronized (sessionsDiagnosticsSummaryObject) {
                        SessionDiagnosticsObject sdo = new SessionDiagnosticsObject(session, SessionsDiagnosticsSummaryObject.this.node);
                        SessionsDiagnosticsSummaryObject.this.sessionDiagnosticsObjects.put(session.getSessionId(), sdo);
                        sdo.startup();
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onSessionClosed(Session session) {
                    SessionsDiagnosticsSummaryObject sessionsDiagnosticsSummaryObject = SessionsDiagnosticsSummaryObject.this;
                    synchronized (sessionsDiagnosticsSummaryObject) {
                        SessionDiagnosticsObject sdo = (SessionDiagnosticsObject)SessionsDiagnosticsSummaryObject.this.sessionDiagnosticsObjects.remove(session.getSessionId());
                        if (sdo != null) {
                            sdo.shutdown();
                        }
                    }
                }
            };
            DiagnosticsManager.this.getServer().getSessionManager().addSessionListener(this.sessionListener);
        }

        @Override
        protected synchronized void onShutdown() {
            this.logger.debug("SessionsDiagnosticsSummaryObject onShutdown()");
            DiagnosticsManager.this.diagnosticTasks.removeAll(this.registeredTasks);
            this.registeredTasks.clear();
            if (this.sessionListener != null) {
                DiagnosticsManager.this.getServer().getSessionManager().removeSessionListener(this.sessionListener);
            }
            this.sessionDiagnosticsObjects.values().forEach(AbstractLifecycle::shutdown);
            this.sessionDiagnosticsObjects.clear();
        }

        private void configureSessionSecurityDiagnosticsArray() {
            SessionSecurityDiagnosticsArrayTypeNode sessionSecurityDiagnosticsArrayNode = this.node.getSessionSecurityDiagnosticsArrayNode();
            sessionSecurityDiagnosticsArrayNode.getFilterChain().addLast((AttributeFilter)new ArrayValueAttributeFilter(Identifiers.SessionSecurityDiagnosticsType));
            Runnable updateTask = () -> {
                ExtensionObject[] xos = (ExtensionObject[])this.sessionDiagnosticsObjects.values().stream().map(sdo -> ExtensionObject.encode((SerializationContext)DiagnosticsManager.this.getServer().getSerializationContext(), (UaStructure)((SessionDiagnosticsObject)sdo).session.getSessionSecurityDiagnostics().getSessionSecurityDiagnosticsDataType())).toArray(ExtensionObject[]::new);
                sessionSecurityDiagnosticsArrayNode.setValue(new DataValue(new Variant((Object)xos)));
            };
            DiagnosticsManager.this.diagnosticTasks.add(updateTask);
            this.registeredTasks.add(updateTask);
        }

        private void configureSessionDiagnosticsArray() {
            SessionDiagnosticsArrayTypeNode sessionDiagnosticsArrayNode = this.node.getSessionDiagnosticsArrayNode();
            sessionDiagnosticsArrayNode.getFilterChain().addLast((AttributeFilter)new ArrayValueAttributeFilter(Identifiers.SessionDiagnosticsVariableType));
            Runnable updateTask = () -> {
                ExtensionObject[] xos = (ExtensionObject[])this.sessionDiagnosticsObjects.values().stream().map(sdo -> ExtensionObject.encode((SerializationContext)DiagnosticsManager.this.getServer().getSerializationContext(), (UaStructure)((SessionDiagnosticsObject)sdo).session.getSessionDiagnostics().getSessionDiagnosticsDataType())).toArray(ExtensionObject[]::new);
                sessionDiagnosticsArrayNode.setValue(new DataValue(new Variant((Object)xos)));
            };
            DiagnosticsManager.this.diagnosticTasks.add(updateTask);
            this.registeredTasks.add(updateTask);
        }
    }

    class ServerDiagnosticsObject
    extends AbstractLifecycle {
        private final Logger logger = LoggerFactory.getLogger(this.getClass());
        private final List<Runnable> registeredTasks = Collections.synchronizedList(new ArrayList());
        private SessionsDiagnosticsSummaryObject sessionsDiagnosticsSummaryObject;
        private final ServerDiagnosticsTypeNode node;

        ServerDiagnosticsObject(ServerDiagnosticsTypeNode node) {
            Preconditions.checkNotNull((Object)node, (Object)"ServerDiagnosticsTypeNode");
            this.node = node;
        }

        @Override
        protected synchronized void onStartup() {
            this.logger.debug("ServerDiagnosticsNode onStartup()");
            this.configureServerDiagnosticsSummary();
            this.configureSubscriptionDiagnosticsArray();
            this.sessionsDiagnosticsSummaryObject = new SessionsDiagnosticsSummaryObject(this.node.getSessionsDiagnosticsSummaryNode());
            this.sessionsDiagnosticsSummaryObject.startup();
        }

        @Override
        protected synchronized void onShutdown() {
            this.logger.debug("ServerDiagnosticsNode onShutdown()");
            DiagnosticsManager.this.diagnosticTasks.removeAll(this.registeredTasks);
            this.registeredTasks.clear();
            if (this.sessionsDiagnosticsSummaryObject != null) {
                this.sessionsDiagnosticsSummaryObject.shutdown();
                this.sessionsDiagnosticsSummaryObject = null;
            }
        }

        private void configureSubscriptionDiagnosticsArray() {
            this.node.getSubscriptionDiagnosticsArrayNode().getFilterChain().addLast((AttributeFilter)new ArrayValueAttributeFilter(Identifiers.SubscriptionDiagnosticsType){

                @Override
                protected String getElementNodeName(String arrayNodeName, Object value, int index) {
                    if (value instanceof SubscriptionDiagnosticsDataType) {
                        return ((SubscriptionDiagnosticsDataType)value).getSubscriptionId().toString();
                    }
                    return super.getElementNodeName(arrayNodeName, value, index);
                }
            });
            Runnable updateTask = () -> {
                SubscriptionDiagnosticsDataType[] value = (SubscriptionDiagnosticsDataType[])DiagnosticsManager.this.server.getSubscriptions().values().stream().map(s -> s.getSubscriptionDiagnostics().getSubscriptionDiagnosticsDataType()).toArray(SubscriptionDiagnosticsDataType[]::new);
                this.node.getSubscriptionDiagnosticsArrayNode().setValue(new DataValue(new Variant((Object)value)));
            };
            DiagnosticsManager.this.diagnosticTasks.add(updateTask);
            this.registeredTasks.add(updateTask);
        }

        private void configureServerDiagnosticsSummary() {
            ServerDiagnosticsSummaryTypeNode serverDiagnosticsSummaryNode = this.node.getServerDiagnosticsSummaryNode();
            serverDiagnosticsSummaryNode.getFilterChain().addLast((AttributeFilter)new ComplexValueAttributeFilter());
            Runnable updateTask = () -> {
                ExtensionObject xo = ExtensionObject.encode((SerializationContext)DiagnosticsManager.this.getServer().getSerializationContext(), (UaStructure)DiagnosticsManager.this.getServer().getDiagnosticsSummary().getServerDiagnosticsSummaryDataType());
                serverDiagnosticsSummaryNode.setValue(new DataValue(new Variant((Object)xo)));
            };
            DiagnosticsManager.this.diagnosticTasks.add(updateTask);
            this.registeredTasks.add(updateTask);
        }
    }
}

