/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.model.nodes.objects;

import java.util.Optional;
import org.eclipse.milo.opcua.sdk.server.api.nodes.ObjectNode;
import org.eclipse.milo.opcua.sdk.server.api.nodes.VariableNode;
import org.eclipse.milo.opcua.sdk.server.model.nodes.objects.BaseObjectTypeNode;
import org.eclipse.milo.opcua.sdk.server.model.nodes.objects.SessionsDiagnosticsSummaryTypeNode;
import org.eclipse.milo.opcua.sdk.server.model.nodes.variables.PropertyTypeNode;
import org.eclipse.milo.opcua.sdk.server.model.nodes.variables.SamplingIntervalDiagnosticsArrayTypeNode;
import org.eclipse.milo.opcua.sdk.server.model.nodes.variables.ServerDiagnosticsSummaryTypeNode;
import org.eclipse.milo.opcua.sdk.server.model.nodes.variables.SubscriptionDiagnosticsArrayTypeNode;
import org.eclipse.milo.opcua.sdk.server.model.types.objects.ServerDiagnosticsType;
import org.eclipse.milo.opcua.sdk.server.nodes.UaNodeContext;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UByte;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.structured.SamplingIntervalDiagnosticsDataType;
import org.eclipse.milo.opcua.stack.core.types.structured.ServerDiagnosticsSummaryDataType;
import org.eclipse.milo.opcua.stack.core.types.structured.SubscriptionDiagnosticsDataType;

public class ServerDiagnosticsTypeNode
extends BaseObjectTypeNode
implements ServerDiagnosticsType {
    public ServerDiagnosticsTypeNode(UaNodeContext context, NodeId nodeId, QualifiedName browseName, LocalizedText displayName, LocalizedText description, UInteger writeMask, UInteger userWriteMask) {
        super(context, nodeId, browseName, displayName, description, writeMask, userWriteMask);
    }

    public ServerDiagnosticsTypeNode(UaNodeContext context, NodeId nodeId, QualifiedName browseName, LocalizedText displayName, LocalizedText description, UInteger writeMask, UInteger userWriteMask, UByte eventNotifier) {
        super(context, nodeId, browseName, displayName, description, writeMask, userWriteMask, eventNotifier);
    }

    @Override
    public PropertyTypeNode getEnabledFlagNode() {
        Optional<VariableNode> propertyNode = this.getPropertyNode(ServerDiagnosticsType.ENABLED_FLAG);
        return propertyNode.orElse(null);
    }

    @Override
    public Boolean getEnabledFlag() {
        Optional<Boolean> propertyValue = this.getProperty(ServerDiagnosticsType.ENABLED_FLAG);
        return propertyValue.orElse(null);
    }

    @Override
    public void setEnabledFlag(Boolean value) {
        this.setProperty(ServerDiagnosticsType.ENABLED_FLAG, value);
    }

    @Override
    public ServerDiagnosticsSummaryTypeNode getServerDiagnosticsSummaryNode() {
        Optional<VariableNode> component = this.getVariableComponent("http://opcfoundation.org/UA/", "ServerDiagnosticsSummary");
        return component.orElse(null);
    }

    @Override
    public ServerDiagnosticsSummaryDataType getServerDiagnosticsSummary() {
        Optional<VariableNode> component = this.getVariableComponent("http://opcfoundation.org/UA/", "ServerDiagnosticsSummary");
        return component.map(node -> (ServerDiagnosticsSummaryDataType)node.getValue().getValue().getValue()).orElse(null);
    }

    @Override
    public void setServerDiagnosticsSummary(ServerDiagnosticsSummaryDataType value) {
        this.getVariableComponent("http://opcfoundation.org/UA/", "ServerDiagnosticsSummary").ifPresent(n -> n.setValue(new DataValue(new Variant((Object)value))));
    }

    @Override
    public SamplingIntervalDiagnosticsArrayTypeNode getSamplingIntervalDiagnosticsArrayNode() {
        Optional<VariableNode> component = this.getVariableComponent("http://opcfoundation.org/UA/", "SamplingIntervalDiagnosticsArray");
        return component.orElse(null);
    }

    @Override
    public SamplingIntervalDiagnosticsDataType[] getSamplingIntervalDiagnosticsArray() {
        Optional<VariableNode> component = this.getVariableComponent("http://opcfoundation.org/UA/", "SamplingIntervalDiagnosticsArray");
        return component.map(node -> (SamplingIntervalDiagnosticsDataType[])node.getValue().getValue().getValue()).orElse(null);
    }

    @Override
    public void setSamplingIntervalDiagnosticsArray(SamplingIntervalDiagnosticsDataType[] value) {
        this.getVariableComponent("http://opcfoundation.org/UA/", "SamplingIntervalDiagnosticsArray").ifPresent(n -> n.setValue(new DataValue(new Variant((Object)value))));
    }

    @Override
    public SubscriptionDiagnosticsArrayTypeNode getSubscriptionDiagnosticsArrayNode() {
        Optional<VariableNode> component = this.getVariableComponent("http://opcfoundation.org/UA/", "SubscriptionDiagnosticsArray");
        return component.orElse(null);
    }

    @Override
    public SubscriptionDiagnosticsDataType[] getSubscriptionDiagnosticsArray() {
        Optional<VariableNode> component = this.getVariableComponent("http://opcfoundation.org/UA/", "SubscriptionDiagnosticsArray");
        return component.map(node -> (SubscriptionDiagnosticsDataType[])node.getValue().getValue().getValue()).orElse(null);
    }

    @Override
    public void setSubscriptionDiagnosticsArray(SubscriptionDiagnosticsDataType[] value) {
        this.getVariableComponent("http://opcfoundation.org/UA/", "SubscriptionDiagnosticsArray").ifPresent(n -> n.setValue(new DataValue(new Variant((Object)value))));
    }

    @Override
    public SessionsDiagnosticsSummaryTypeNode getSessionsDiagnosticsSummaryNode() {
        Optional<ObjectNode> component = this.getObjectComponent("http://opcfoundation.org/UA/", "SessionsDiagnosticsSummary");
        return component.orElse(null);
    }
}

