/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.nodes.delegates;

import org.eclipse.milo.opcua.sdk.server.api.nodes.Node;
import org.eclipse.milo.opcua.sdk.server.nodes.AttributeContext;
import org.eclipse.milo.opcua.sdk.server.nodes.UaNode;
import org.eclipse.milo.opcua.sdk.server.util.AttributeUtil;
import org.eclipse.milo.opcua.stack.core.AttributeId;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.enumerated.NodeClass;

public interface GetSetBase {
    default public DataValue getBaseAttribute(AttributeContext context, Node node, AttributeId attributeId) throws UaException {
        switch (attributeId) {
            case NodeId: {
                return AttributeUtil.dv(this.getNodeId(context, node));
            }
            case NodeClass: {
                return AttributeUtil.dv(this.getNodeClass(context, node));
            }
            case BrowseName: {
                return AttributeUtil.dv(this.getBrowseName(context, node));
            }
            case DisplayName: {
                return AttributeUtil.dv(this.getDisplayName(context, node));
            }
            case Description: {
                return AttributeUtil.dv(this.getDescription(context, node));
            }
            case WriteMask: {
                return AttributeUtil.dv(this.getWriteMask(context, node));
            }
            case UserWriteMask: {
                return AttributeUtil.dv(this.getUserWriteMask(context, node));
            }
        }
        throw new UaException(2150957056L);
    }

    default public void setBaseAttribute(AttributeContext context, Node node, AttributeId attributeId, DataValue value) throws UaException {
        switch (attributeId) {
            case NodeId: {
                this.setNodeId(context, node, (NodeId)AttributeUtil.extract(value));
                break;
            }
            case NodeClass: {
                this.setNodeClass(context, node, (NodeClass)AttributeUtil.extract(value));
                break;
            }
            case BrowseName: {
                this.setBrowseName(context, node, (QualifiedName)AttributeUtil.extract(value));
                break;
            }
            case DisplayName: {
                this.setDisplayName(context, node, (LocalizedText)AttributeUtil.extract(value));
                break;
            }
            case Description: {
                this.setDescription(context, node, (LocalizedText)AttributeUtil.extract(value));
                break;
            }
            case WriteMask: {
                this.setWriteMask(context, node, (UInteger)AttributeUtil.extract(value));
                break;
            }
            case UserWriteMask: {
                this.setUserWriteMask(context, node, (UInteger)AttributeUtil.extract(value));
                break;
            }
            default: {
                throw new UaException(2150957056L);
            }
        }
    }

    default public NodeId getNodeId(AttributeContext context, Node node) throws UaException {
        return (NodeId)((UaNode)node).getFilterChain().getAttribute(context.getSession().orElse(null), (UaNode)node, AttributeId.NodeId);
    }

    default public NodeClass getNodeClass(AttributeContext context, Node node) throws UaException {
        return (NodeClass)((UaNode)node).getFilterChain().getAttribute(context.getSession().orElse(null), (UaNode)node, AttributeId.NodeClass);
    }

    default public QualifiedName getBrowseName(AttributeContext context, Node node) throws UaException {
        return (QualifiedName)((UaNode)node).getFilterChain().getAttribute(context.getSession().orElse(null), (UaNode)node, AttributeId.BrowseName);
    }

    default public LocalizedText getDisplayName(AttributeContext context, Node node) throws UaException {
        return (LocalizedText)((UaNode)node).getFilterChain().getAttribute(context.getSession().orElse(null), (UaNode)node, AttributeId.DisplayName);
    }

    default public LocalizedText getDescription(AttributeContext context, Node node) throws UaException {
        return (LocalizedText)((UaNode)node).getFilterChain().getAttribute(context.getSession().orElse(null), (UaNode)node, AttributeId.Description);
    }

    default public UInteger getWriteMask(AttributeContext context, Node node) throws UaException {
        return (UInteger)((UaNode)node).getFilterChain().getAttribute(context.getSession().orElse(null), (UaNode)node, AttributeId.WriteMask);
    }

    default public UInteger getUserWriteMask(AttributeContext context, Node node) throws UaException {
        return (UInteger)((UaNode)node).getFilterChain().getAttribute(context.getSession().orElse(null), (UaNode)node, AttributeId.UserWriteMask);
    }

    default public void setNodeId(AttributeContext context, Node node, NodeId nodeId) throws UaException {
        ((UaNode)node).getFilterChain().setAttribute(context.getSession().orElse(null), (UaNode)node, AttributeId.NodeId, nodeId);
    }

    default public void setNodeClass(AttributeContext context, Node node, NodeClass nodeClass) throws UaException {
        ((UaNode)node).getFilterChain().setAttribute(context.getSession().orElse(null), (UaNode)node, AttributeId.NodeClass, nodeClass);
    }

    default public void setBrowseName(AttributeContext context, Node node, QualifiedName browseName) throws UaException {
        ((UaNode)node).getFilterChain().setAttribute(context.getSession().orElse(null), (UaNode)node, AttributeId.BrowseName, browseName);
    }

    default public void setDisplayName(AttributeContext context, Node node, LocalizedText displayName) throws UaException {
        ((UaNode)node).getFilterChain().setAttribute(context.getSession().orElse(null), (UaNode)node, AttributeId.DisplayName, displayName);
    }

    default public void setDescription(AttributeContext context, Node node, LocalizedText description) throws UaException {
        ((UaNode)node).getFilterChain().setAttribute(context.getSession().orElse(null), (UaNode)node, AttributeId.Description, description);
    }

    default public void setWriteMask(AttributeContext context, Node node, UInteger writeMask) throws UaException {
        ((UaNode)node).getFilterChain().setAttribute(context.getSession().orElse(null), (UaNode)node, AttributeId.WriteMask, writeMask);
    }

    default public void setUserWriteMask(AttributeContext context, Node node, UInteger userWriteMask) throws UaException {
        ((UaNode)node).getFilterChain().setAttribute(context.getSession().orElse(null), (UaNode)node, AttributeId.UserWriteMask, userWriteMask);
    }
}

