/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.nodes.delegates;

import org.eclipse.milo.opcua.sdk.server.api.nodes.ReferenceTypeNode;
import org.eclipse.milo.opcua.sdk.server.nodes.AttributeContext;
import org.eclipse.milo.opcua.sdk.server.nodes.UaNode;
import org.eclipse.milo.opcua.sdk.server.nodes.UaReferenceTypeNode;
import org.eclipse.milo.opcua.sdk.server.nodes.delegates.GetSetBase;
import org.eclipse.milo.opcua.sdk.server.util.AttributeUtil;
import org.eclipse.milo.opcua.stack.core.AttributeId;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;

public interface GetSetReferenceTypeNode
extends GetSetBase {
    default public DataValue getReferenceTypeAttribute(AttributeContext context, UaReferenceTypeNode node, AttributeId attributeId) throws UaException {
        switch (attributeId) {
            case IsAbstract: {
                return AttributeUtil.dv(this.getIsAbstract(context, node));
            }
            case Symmetric: {
                return AttributeUtil.dv(this.getSymmetric(context, node));
            }
            case InverseName: {
                return AttributeUtil.dv(this.getInverseName(context, node));
            }
        }
        return this.getBaseAttribute(context, node, attributeId);
    }

    default public void setReferenceTypeAttribute(AttributeContext context, UaReferenceTypeNode node, AttributeId attributeId, DataValue value) throws UaException {
        switch (attributeId) {
            case IsAbstract: {
                this.setIsAbstract(context, node, (Boolean)AttributeUtil.extract(value));
                break;
            }
            case Symmetric: {
                this.setSymmetric(context, node, (Boolean)AttributeUtil.extract(value));
                break;
            }
            case InverseName: {
                this.setInverseName(context, node, (LocalizedText)AttributeUtil.extract(value));
                break;
            }
            default: {
                this.setBaseAttribute(context, node, attributeId, value);
            }
        }
    }

    default public Boolean getIsAbstract(AttributeContext context, ReferenceTypeNode node) throws UaException {
        return (Boolean)((UaNode)((Object)node)).getFilterChain().getAttribute(context.getSession().orElse(null), (UaNode)((Object)node), AttributeId.IsAbstract);
    }

    default public Boolean getSymmetric(AttributeContext context, ReferenceTypeNode node) throws UaException {
        return (Boolean)((UaNode)((Object)node)).getFilterChain().getAttribute(context.getSession().orElse(null), (UaNode)((Object)node), AttributeId.Symmetric);
    }

    default public LocalizedText getInverseName(AttributeContext context, ReferenceTypeNode node) throws UaException {
        return (LocalizedText)((UaNode)((Object)node)).getFilterChain().getAttribute(context.getSession().orElse(null), (UaNode)((Object)node), AttributeId.InverseName);
    }

    default public void setIsAbstract(AttributeContext context, ReferenceTypeNode node, Boolean isAbstract) throws UaException {
        ((UaNode)((Object)node)).getFilterChain().setAttribute(context.getSession().orElse(null), (UaNode)((Object)node), AttributeId.IsAbstract, isAbstract);
    }

    default public void setSymmetric(AttributeContext context, ReferenceTypeNode node, Boolean symmetric) throws UaException {
        ((UaNode)((Object)node)).getFilterChain().setAttribute(context.getSession().orElse(null), (UaNode)((Object)node), AttributeId.Symmetric, symmetric);
    }

    default public void setInverseName(AttributeContext context, ReferenceTypeNode node, LocalizedText inverseName) throws UaException {
        ((UaNode)((Object)node)).getFilterChain().setAttribute(context.getSession().orElse(null), (UaNode)((Object)node), AttributeId.InverseName, inverseName);
    }
}

