/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.nodes.filters;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedDeque;
import javax.annotation.Nullable;
import org.eclipse.milo.opcua.sdk.server.Session;
import org.eclipse.milo.opcua.sdk.server.nodes.DefaultAttributeFilter;
import org.eclipse.milo.opcua.sdk.server.nodes.UaNode;
import org.eclipse.milo.opcua.sdk.server.nodes.filters.AttributeFilter;
import org.eclipse.milo.opcua.sdk.server.nodes.filters.AttributeFilterContext;
import org.eclipse.milo.opcua.stack.core.AttributeId;

public class AttributeFilterChain {
    private final ConcurrentLinkedDeque<AttributeFilter> filters = new ConcurrentLinkedDeque();

    public AttributeFilterChain() {
    }

    public AttributeFilterChain(AttributeFilter filter) {
        this.filters.add(filter);
    }

    public AttributeFilterChain(List<AttributeFilter> filters) {
        this.filters.addAll(filters);
    }

    public Object getAttribute(UaNode node, AttributeId attributeId) {
        return this.getAttribute(null, node, attributeId);
    }

    public Object getAttribute(@Nullable Session session, UaNode node, AttributeId attributeId) {
        Iterator<AttributeFilter> filterIterator = this.filters.iterator();
        DefaultAttributeFilter filter = filterIterator.hasNext() ? filterIterator.next() : AttributeFilter.DEFAULT_INSTANCE;
        AttributeFilterContext.GetAttributeContext ctx = new AttributeFilterContext.GetAttributeContext(session, node, filterIterator);
        Object value = filter.getAttribute(ctx, attributeId);
        if (ctx.isObservable()) {
            node.fireAttributeChanged(attributeId, value);
        }
        return value;
    }

    public void setAttribute(UaNode node, AttributeId attributeId, Object value) {
        this.setAttribute(null, node, attributeId, value);
    }

    public void setAttribute(@Nullable Session session, UaNode node, AttributeId attributeId, Object value) {
        Iterator<AttributeFilter> filterIterator = this.filters.iterator();
        DefaultAttributeFilter filter = filterIterator.hasNext() ? filterIterator.next() : AttributeFilter.DEFAULT_INSTANCE;
        AttributeFilterContext.SetAttributeContext ctx = new AttributeFilterContext.SetAttributeContext(session, node, filterIterator);
        filter.setAttribute(ctx, attributeId, value);
    }

    public AttributeFilterChain addFirst(AttributeFilter attributeFilter) {
        this.filters.addFirst(attributeFilter);
        return this;
    }

    public AttributeFilterChain addFirst(AttributeFilter ... attributeFilters) {
        Arrays.stream(attributeFilters).forEach(this::addFirst);
        return this;
    }

    public AttributeFilterChain addLast(AttributeFilter attributeFilter) {
        this.filters.addLast(attributeFilter);
        return this;
    }

    public AttributeFilterChain addLast(AttributeFilter ... attributeFilters) {
        Arrays.stream(attributeFilters).forEach(this::addLast);
        return this;
    }
}

