/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.net.InetAddress;
import java.security.cert.X509Certificate;
import java.time.Duration;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.eclipse.milo.opcua.sdk.server.OpcUaServer;
import org.eclipse.milo.opcua.sdk.server.SecurityConfiguration;
import org.eclipse.milo.opcua.sdk.server.diagnostics.SessionDiagnostics;
import org.eclipse.milo.opcua.sdk.server.diagnostics.SessionSecurityDiagnostics;
import org.eclipse.milo.opcua.sdk.server.services.DefaultAttributeHistoryServiceSet;
import org.eclipse.milo.opcua.sdk.server.services.DefaultAttributeServiceSet;
import org.eclipse.milo.opcua.sdk.server.services.DefaultMethodServiceSet;
import org.eclipse.milo.opcua.sdk.server.services.DefaultMonitoredItemServiceSet;
import org.eclipse.milo.opcua.sdk.server.services.DefaultNodeManagementServiceSet;
import org.eclipse.milo.opcua.sdk.server.services.DefaultQueryServiceSet;
import org.eclipse.milo.opcua.sdk.server.services.DefaultSubscriptionServiceSet;
import org.eclipse.milo.opcua.sdk.server.services.DefaultViewServiceSet;
import org.eclipse.milo.opcua.sdk.server.services.helpers.BrowseHelper;
import org.eclipse.milo.opcua.sdk.server.subscriptions.SubscriptionManager;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.serialization.UaResponseMessage;
import org.eclipse.milo.opcua.stack.core.types.builtin.ByteString;
import org.eclipse.milo.opcua.stack.core.types.builtin.DateTime;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.Unsigned;
import org.eclipse.milo.opcua.stack.core.types.enumerated.UserTokenType;
import org.eclipse.milo.opcua.stack.core.types.structured.AnonymousIdentityToken;
import org.eclipse.milo.opcua.stack.core.types.structured.ApplicationDescription;
import org.eclipse.milo.opcua.stack.core.types.structured.CancelResponse;
import org.eclipse.milo.opcua.stack.core.types.structured.EndpointDescription;
import org.eclipse.milo.opcua.stack.core.types.structured.IssuedIdentityToken;
import org.eclipse.milo.opcua.stack.core.types.structured.UserIdentityToken;
import org.eclipse.milo.opcua.stack.core.types.structured.UserNameIdentityToken;
import org.eclipse.milo.opcua.stack.core.types.structured.X509IdentityToken;
import org.eclipse.milo.opcua.stack.core.util.CertificateUtil;
import org.eclipse.milo.opcua.stack.server.services.NodeManagementServiceSet;
import org.eclipse.milo.opcua.stack.server.services.ServiceRequest;
import org.eclipse.milo.opcua.stack.server.services.SessionServiceSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Session
implements SessionServiceSet {
    private static final int IDENTITY_HISTORY_MAX_SIZE = 10;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final List<LifecycleListener> listeners = Lists.newCopyOnWriteArrayList();
    private final SubscriptionManager subscriptionManager;
    private final LinkedList<String> clientUserIdHistory = new LinkedList();
    private final Map<ByteString, BrowseHelper.BrowseContinuationPoint> browseContinuationPoints = Maps.newConcurrentMap();
    private volatile Object identityObject;
    private volatile UserIdentityToken identityToken;
    private volatile ByteString lastNonce = ByteString.NULL_VALUE;
    private volatile long lastActivityNanos = System.nanoTime();
    private volatile ScheduledFuture<?> checkTimeoutFuture;
    private final DefaultAttributeServiceSet attributeServiceSet;
    private final DefaultAttributeHistoryServiceSet attributeHistoryServiceSet;
    private final DefaultMethodServiceSet methodServiceSet;
    private final DefaultMonitoredItemServiceSet monitoredItemServiceSet;
    private final DefaultNodeManagementServiceSet nodeManagementServiceSet;
    private final DefaultQueryServiceSet queryServiceSet;
    private final DefaultSubscriptionServiceSet subscriptionServiceSet;
    private final DefaultViewServiceSet viewServiceSet;
    private volatile EndpointDescription endpoint;
    private volatile long secureChannelId;
    private volatile SecurityConfiguration securityConfiguration;
    private volatile InetAddress clientAddress;
    private volatile String[] localeIds;
    private volatile DateTime lastContactTime;
    private final DateTime connectTime = DateTime.now();
    private final SessionDiagnostics sessionDiagnostics;
    private final SessionSecurityDiagnostics sessionSecurityDiagnostics;
    private final OpcUaServer server;
    private final NodeId sessionId;
    private final String sessionName;
    private final Duration sessionTimeout;
    private final ApplicationDescription clientDescription;
    private final String serverUri;
    private final UInteger maxResponseMessageSize;

    public Session(OpcUaServer server, NodeId sessionId, String sessionName, Duration sessionTimeout, ApplicationDescription clientDescription, String serverUri, UInteger maxResponseMessageSize, EndpointDescription endpoint, long secureChannelId, SecurityConfiguration securityConfiguration) {
        this.server = server;
        this.sessionId = sessionId;
        this.sessionName = sessionName;
        this.sessionTimeout = sessionTimeout;
        this.clientDescription = clientDescription;
        this.serverUri = serverUri;
        this.maxResponseMessageSize = maxResponseMessageSize;
        this.secureChannelId = secureChannelId;
        this.securityConfiguration = securityConfiguration;
        this.endpoint = endpoint;
        this.sessionDiagnostics = new SessionDiagnostics(this);
        this.sessionSecurityDiagnostics = new SessionSecurityDiagnostics(this);
        this.subscriptionManager = new SubscriptionManager(this, server);
        this.attributeServiceSet = new DefaultAttributeServiceSet();
        this.attributeHistoryServiceSet = new DefaultAttributeHistoryServiceSet();
        this.methodServiceSet = new DefaultMethodServiceSet();
        this.monitoredItemServiceSet = new DefaultMonitoredItemServiceSet(this.subscriptionManager);
        this.nodeManagementServiceSet = new DefaultNodeManagementServiceSet();
        this.queryServiceSet = new DefaultQueryServiceSet();
        this.subscriptionServiceSet = new DefaultSubscriptionServiceSet(this.subscriptionManager);
        this.viewServiceSet = new DefaultViewServiceSet();
        this.checkTimeoutFuture = server.getScheduledExecutorService().schedule(this::checkTimeout, sessionTimeout.toNanos(), TimeUnit.NANOSECONDS);
    }

    public OpcUaServer getServer() {
        return this.server;
    }

    public long getSecureChannelId() {
        return this.secureChannelId;
    }

    public SecurityConfiguration getSecurityConfiguration() {
        return this.securityConfiguration;
    }

    public EndpointDescription getEndpoint() {
        return this.endpoint;
    }

    @Nullable
    public Object getIdentityObject() {
        return this.identityObject;
    }

    @Nullable
    public UserIdentityToken getIdentityToken() {
        return this.identityToken;
    }

    @Nullable
    public UserTokenType getTokenType() {
        UserIdentityToken token = this.identityToken;
        return token != null ? Session.getTokenType(token) : null;
    }

    @Nullable
    public String getClientUserId() {
        return Session.getClientUserId(this.identityToken);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getClientUserIdHistory() {
        LinkedList<String> linkedList = this.clientUserIdHistory;
        synchronized (linkedList) {
            return new ArrayList<String>(this.clientUserIdHistory);
        }
    }

    public Map<ByteString, BrowseHelper.BrowseContinuationPoint> getBrowseContinuationPoints() {
        return this.browseContinuationPoints;
    }

    public void setSecureChannelId(long secureChannelId) {
        this.secureChannelId = secureChannelId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setIdentityObject(Object identityObject, UserIdentityToken identityToken) {
        this.identityObject = identityObject;
        this.identityToken = identityToken;
        LinkedList<String> linkedList = this.clientUserIdHistory;
        synchronized (linkedList) {
            this.clientUserIdHistory.addLast(Session.getClientUserId(identityToken));
            while (this.clientUserIdHistory.size() > 10) {
                this.clientUserIdHistory.removeFirst();
            }
        }
    }

    public void setEndpoint(EndpointDescription endpoint) {
        this.endpoint = endpoint;
    }

    public void setSecurityConfiguration(SecurityConfiguration securityConfiguration) {
        this.securityConfiguration = securityConfiguration;
    }

    public void setClientAddress(InetAddress clientAddress) {
        this.clientAddress = clientAddress;
    }

    public InetAddress getClientAddress() {
        return this.clientAddress;
    }

    public SessionDiagnostics getSessionDiagnostics() {
        return this.sessionDiagnostics;
    }

    public SessionSecurityDiagnostics getSessionSecurityDiagnostics() {
        return this.sessionSecurityDiagnostics;
    }

    public void addLifecycleListener(LifecycleListener listener) {
        this.listeners.add(listener);
    }

    void updateLastActivity() {
        this.lastActivityNanos = System.nanoTime();
        this.lastContactTime = DateTime.now();
    }

    public ApplicationDescription getClientDescription() {
        return this.clientDescription;
    }

    public String getServerUri() {
        return this.serverUri;
    }

    public Double getSessionTimeout() {
        return this.sessionTimeout.toMillis();
    }

    public UInteger getMaxResponseMessageSize() {
        return this.maxResponseMessageSize;
    }

    public DateTime getConnectionTime() {
        return this.connectTime;
    }

    public DateTime getLastContactTime() {
        return this.lastContactTime;
    }

    void setLastNonce(ByteString lastNonce) {
        this.lastNonce = lastNonce;
    }

    public ByteString getLastNonce() {
        return this.lastNonce;
    }

    private void checkTimeout() {
        long elapsed = Math.abs(System.nanoTime() - this.lastActivityNanos);
        if (elapsed > this.sessionTimeout.toNanos()) {
            this.logger.debug("Session id={} lifetime expired ({}ms).", (Object)this.sessionId, (Object)this.sessionTimeout.toMillis());
            this.close(true);
            this.server.getDiagnosticsSummary().getSessionTimeoutCount().increment();
        } else {
            long remaining = this.sessionTimeout.toNanos() - elapsed;
            this.logger.trace("Session id={} timeout scheduled for +{}s.", (Object)this.sessionId, (Object)Duration.ofNanos(remaining).getSeconds());
            this.checkTimeoutFuture = this.server.getScheduledExecutorService().schedule(this::checkTimeout, remaining, TimeUnit.NANOSECONDS);
        }
    }

    public NodeId getSessionId() {
        return this.sessionId;
    }

    public String getSessionName() {
        return this.sessionName;
    }

    @Nullable
    public String[] getLocaleIds() {
        return this.localeIds;
    }

    public void setLocaleIds(@Nullable String[] localeIds) {
        this.localeIds = localeIds;
    }

    public DefaultAttributeServiceSet getAttributeServiceSet() {
        return this.attributeServiceSet;
    }

    public DefaultAttributeHistoryServiceSet getAttributeHistoryServiceSet() {
        return this.attributeHistoryServiceSet;
    }

    public DefaultMethodServiceSet getMethodServiceSet() {
        return this.methodServiceSet;
    }

    public DefaultMonitoredItemServiceSet getMonitoredItemServiceSet() {
        return this.monitoredItemServiceSet;
    }

    public NodeManagementServiceSet getNodeManagementServiceSet() {
        return this.nodeManagementServiceSet;
    }

    public DefaultQueryServiceSet getQueryServiceSet() {
        return this.queryServiceSet;
    }

    public DefaultSubscriptionServiceSet getSubscriptionServiceSet() {
        return this.subscriptionServiceSet;
    }

    public DefaultViewServiceSet getViewServiceSet() {
        return this.viewServiceSet;
    }

    public SubscriptionManager getSubscriptionManager() {
        return this.subscriptionManager;
    }

    public void onCreateSession(ServiceRequest serviceRequest) {
        serviceRequest.setServiceFault(0x80020000L);
    }

    public void onActivateSession(ServiceRequest serviceRequest) {
        serviceRequest.setServiceFault(0x80020000L);
    }

    public void onCloseSession(ServiceRequest serviceRequest) {
        serviceRequest.setServiceFault(0x80020000L);
    }

    void close(boolean deleteSubscriptions) {
        if (this.checkTimeoutFuture != null) {
            this.checkTimeoutFuture.cancel(false);
        }
        this.subscriptionManager.sessionClosed(deleteSubscriptions);
        this.listeners.forEach(listener -> listener.onSessionClosed(this, deleteSubscriptions));
    }

    public void onCancel(ServiceRequest serviceRequest) throws UaException {
        serviceRequest.setResponse((UaResponseMessage)new CancelResponse(serviceRequest.createResponseHeader(), Unsigned.uint((int)0)));
    }

    @Nullable
    private static String getClientUserId(UserIdentityToken identityToken) {
        UserTokenType tokenType = Session.getTokenType(identityToken);
        if (tokenType == null) {
            return null;
        }
        switch (tokenType) {
            case Anonymous: {
                return null;
            }
            case UserName: {
                return ((UserNameIdentityToken)identityToken).getUserName();
            }
            case Certificate: {
                try {
                    ByteString bs = ((X509IdentityToken)identityToken).getCertificateData();
                    X509Certificate certificate = CertificateUtil.decodeCertificate((byte[])bs.bytesOrEmpty());
                    return certificate.getSubjectX500Principal().getName();
                }
                catch (Throwable t) {
                    return null;
                }
            }
            case IssuedToken: {
                return "IssuedToken";
            }
        }
        throw new IllegalStateException("unhandled UserIdentityToken: " + identityToken);
    }

    private static UserTokenType getTokenType(UserIdentityToken identityToken) {
        UserTokenType identityType = null;
        if (identityToken instanceof AnonymousIdentityToken) {
            identityType = UserTokenType.Anonymous;
        } else if (identityToken instanceof UserNameIdentityToken) {
            identityType = UserTokenType.UserName;
        } else if (identityToken instanceof X509IdentityToken) {
            identityType = UserTokenType.Certificate;
        } else if (identityToken instanceof IssuedIdentityToken) {
            identityType = UserTokenType.IssuedToken;
        }
        return identityType;
    }

    public static interface LifecycleListener {
        public void onSessionClosed(Session var1, boolean var2);
    }
}

