/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.api;

import com.google.common.collect.LinkedHashMultiset;
import com.google.common.collect.MapMaker;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.eclipse.milo.opcua.sdk.core.Reference;
import org.eclipse.milo.opcua.sdk.server.api.NodeManager;
import org.eclipse.milo.opcua.sdk.server.api.nodes.Node;
import org.eclipse.milo.opcua.stack.core.NamespaceTable;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;

public class AbstractNodeManager<T extends Node>
implements NodeManager<T> {
    private final ConcurrentMap<NodeId, T> nodeMap = this.makeNodeMap(new MapMaker());
    private final ConcurrentMap<NodeId, LinkedHashMultiset<Reference>> referenceMap = new ConcurrentHashMap<NodeId, LinkedHashMultiset<Reference>>();

    protected ConcurrentMap<NodeId, T> makeNodeMap(MapMaker mapMaker) {
        return mapMaker.makeMap();
    }

    protected ConcurrentMap<NodeId, T> getNodeMap() {
        return this.nodeMap;
    }

    public ConcurrentMap<NodeId, LinkedHashMultiset<Reference>> getReferenceMap() {
        return this.referenceMap;
    }

    public List<T> getNodes() {
        return new ArrayList(this.nodeMap.values());
    }

    public List<NodeId> getNodeIds() {
        return new ArrayList<NodeId>(this.nodeMap.keySet());
    }

    @Override
    public boolean containsNode(NodeId nodeId) {
        return this.nodeMap.containsKey(nodeId);
    }

    @Override
    public boolean containsNode(ExpandedNodeId nodeId, NamespaceTable namespaceTable) {
        return nodeId.local(namespaceTable).map(this::containsNode).orElse(false);
    }

    @Override
    public Optional<T> addNode(T node) {
        return Optional.ofNullable(this.nodeMap.put(node.getNodeId(), node));
    }

    @Override
    public Optional<T> getNode(NodeId nodeId) {
        return Optional.ofNullable(this.nodeMap.get(nodeId));
    }

    @Override
    public Optional<T> getNode(ExpandedNodeId nodeId, NamespaceTable namespaceTable) {
        return nodeId.local(namespaceTable).flatMap(this::getNode);
    }

    @Override
    public Optional<T> removeNode(NodeId nodeId) {
        return Optional.ofNullable(this.nodeMap.remove(nodeId));
    }

    @Override
    public Optional<T> removeNode(ExpandedNodeId nodeId, NamespaceTable namespaceTable) {
        return nodeId.local(namespaceTable).flatMap(this::removeNode);
    }

    @Override
    public synchronized void addReference(Reference reference) {
        LinkedHashMultiset references = this.referenceMap.computeIfAbsent(reference.getSourceNodeId(), nodeId -> LinkedHashMultiset.create());
        references.add((Object)reference);
    }

    @Override
    public synchronized void addReferences(Reference reference, NamespaceTable namespaceTable) {
        this.addReference(reference);
        reference.invert(namespaceTable).ifPresent(this::addReference);
    }

    @Override
    public synchronized void removeReference(Reference reference) {
        LinkedHashMultiset references = (LinkedHashMultiset)this.referenceMap.get(reference.getSourceNodeId());
        if (references != null) {
            references.remove((Object)reference);
            if (references.isEmpty()) {
                this.referenceMap.remove(reference.getSourceNodeId());
            }
        }
    }

    @Override
    public synchronized void removeReferences(Reference reference, NamespaceTable namespaceTable) {
        this.removeReference(reference);
        reference.invert(namespaceTable).ifPresent(this::removeReference);
    }

    @Override
    public synchronized List<Reference> getReferences(NodeId nodeId) {
        LinkedHashMultiset references = (LinkedHashMultiset)this.referenceMap.get(nodeId);
        if (references != null) {
            return new ArrayList<Reference>((Collection<Reference>)references);
        }
        return Collections.emptyList();
    }

    @Override
    public List<Reference> getReferences(NodeId nodeId, Predicate<Reference> filter) {
        return this.getReferences(nodeId).stream().filter(filter).collect(Collectors.toList());
    }
}

