/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.diagnostics;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import org.eclipse.milo.opcua.sdk.core.AccessLevel;
import org.eclipse.milo.opcua.sdk.core.Reference;
import org.eclipse.milo.opcua.sdk.core.util.StreamUtil;
import org.eclipse.milo.opcua.sdk.server.OpcUaServer;
import org.eclipse.milo.opcua.sdk.server.diagnostics.ComplexValueAttributeFilter;
import org.eclipse.milo.opcua.sdk.server.nodes.UaNode;
import org.eclipse.milo.opcua.sdk.server.nodes.UaVariableNode;
import org.eclipse.milo.opcua.sdk.server.nodes.factories.NodeFactory;
import org.eclipse.milo.opcua.sdk.server.nodes.filters.AttributeFilter;
import org.eclipse.milo.opcua.sdk.server.nodes.filters.AttributeFilterContext;
import org.eclipse.milo.opcua.stack.core.AttributeId;
import org.eclipse.milo.opcua.stack.core.Identifiers;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.Unsigned;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ArrayValueAttributeFilter
implements AttributeFilter {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final LinkedList<UaVariableNode> elementNodes = new LinkedList();
    private final NodeId elementNodeTypeDefinitionId;

    ArrayValueAttributeFilter() {
        this(Identifiers.BaseDataVariableType);
    }

    ArrayValueAttributeFilter(NodeId elementNodeTypeDefinitionId) {
        this.elementNodeTypeDefinitionId = elementNodeTypeDefinitionId;
    }

    @Override
    public void setAttribute(AttributeFilterContext.SetAttributeContext ctx, AttributeId attributeId, Object value) {
        if (attributeId == AttributeId.Value) {
            ctx.setAttribute(attributeId, value);
            if (ctx.getNode() instanceof UaVariableNode) {
                this.synchronizeArrayElements((UaVariableNode)ctx.getNode(), ((DataValue)value).getValue().getValue());
            }
        } else {
            ctx.setAttribute(attributeId, value);
        }
    }

    private synchronized void synchronizeArrayElements(UaVariableNode arrayNode, Object arrayValue) {
        int i;
        if (arrayValue == null || !arrayValue.getClass().isArray()) {
            while (this.elementNodes.size() > 0) {
                UaVariableNode elementNode = this.elementNodes.removeLast();
                arrayNode.removeComponent(elementNode);
                elementNode.delete();
                this.logger.debug("Removed element: {}", (Object)elementNode.getNodeId());
            }
            return;
        }
        int length = Array.getLength(arrayValue);
        if (this.elementNodes.size() < length) {
            for (i = this.elementNodes.size(); i < length; ++i) {
                String id = ArrayValueAttributeFilter.buildBrowseNamePath(arrayNode) + "[" + i + "]";
                NodeId elementNodeId = arrayNode.getNodeId().withId(id);
                NodeFactory nodeFactory = new NodeFactory(arrayNode.getNodeContext());
                try {
                    UaVariableNode elementNode = (UaVariableNode)nodeFactory.createNode(elementNodeId, this.elementNodeTypeDefinitionId);
                    String elementNodeName = this.getElementNodeName(arrayNode.getBrowseName().getName(), Array.get(arrayValue, i), i);
                    elementNode.setBrowseName(new QualifiedName(arrayNode.getBrowseName().getNamespaceIndex(), elementNodeName));
                    elementNode.setDisplayName(new LocalizedText(arrayNode.getDisplayName().getLocale(), elementNodeName));
                    elementNode.setArrayDimensions(null);
                    elementNode.setValueRank(-1);
                    elementNode.setDataType(arrayNode.getDataType());
                    elementNode.setAccessLevel(Unsigned.ubyte((int)AccessLevel.getMask((Set)AccessLevel.READ_ONLY)));
                    elementNode.setUserAccessLevel(Unsigned.ubyte((int)AccessLevel.getMask((Set)AccessLevel.READ_ONLY)));
                    this.elementNodes.add(elementNode);
                    arrayNode.addComponent(elementNode);
                    arrayNode.getNodeManager().addNode(elementNode);
                    NodeId elementDataType = elementNode.getDataType();
                    OpcUaServer server = elementNode.getNodeContext().getServer();
                    if (ArrayValueAttributeFilter.subtypeOf(server, elementDataType, Identifiers.Structure)) {
                        elementNode.getFilterChain().addLast((AttributeFilter)new ComplexValueAttributeFilter());
                    }
                    this.logger.debug("Added element: {}", (Object)elementNodeId);
                    continue;
                }
                catch (UaException e) {
                    this.logger.error("Error creating element Node for {}", (Object)arrayNode.getNodeId(), (Object)e);
                }
            }
        } else if (this.elementNodes.size() > length) {
            while (this.elementNodes.size() > length) {
                UaVariableNode elementNode = this.elementNodes.removeLast();
                arrayNode.removeComponent(elementNode);
                elementNode.delete();
                this.logger.debug("Removed element: {}", (Object)elementNode.getNodeId());
            }
        }
        for (i = 0; i < length; ++i) {
            Object elementValue = Array.get(arrayValue, i);
            this.elementNodes.get(i).setValue(new DataValue(new Variant(elementValue)));
        }
    }

    private static String buildBrowseNamePath(UaNode node) {
        return ArrayValueAttributeFilter.buildBrowseNamePath(node, new ArrayList<String>());
    }

    private static String buildBrowseNamePath(UaNode node, List<String> browseNames) {
        if (node == null || node.getNodeId().equals((Object)Identifiers.ObjectsFolder)) {
            Collections.reverse(browseNames);
            return String.join((CharSequence)".", browseNames);
        }
        browseNames.add(node.getBrowseName().toParseableString());
        Optional<Reference> referenceToParent = node.getReferences().stream().filter(r -> r.isInverse() && r.subtypeOf(Identifiers.HierarchicalReferences)).findFirst();
        Optional parentNode = referenceToParent.flatMap(r -> node.getNodeContext().getServer().getAddressSpaceManager().getManagedNode(r.getTargetNodeId()));
        return ArrayValueAttributeFilter.buildBrowseNamePath(parentNode.orElse(null), browseNames);
    }

    protected String getElementNodeName(String arrayNodeName, Object value, int index) {
        return arrayNodeName + "[" + index + "]";
    }

    private static boolean subtypeOf(OpcUaServer server, NodeId dataTypeId, NodeId potentialSuperTypeId) {
        UaNode dataTypeNode = server.getAddressSpaceManager().getManagedNode(dataTypeId).orElse(null);
        if (dataTypeNode != null) {
            NodeId superTypeId = ArrayValueAttributeFilter.getSuperTypeId(server, dataTypeId);
            if (superTypeId != null) {
                return superTypeId.equals((Object)potentialSuperTypeId) || ArrayValueAttributeFilter.subtypeOf(server, superTypeId, potentialSuperTypeId);
            }
            return false;
        }
        return false;
    }

    @Nullable
    private static NodeId getSuperTypeId(OpcUaServer server, NodeId dataTypeId) {
        UaNode dataTypeNode = server.getAddressSpaceManager().getManagedNode(dataTypeId).orElse(null);
        if (dataTypeNode != null) {
            return dataTypeNode.getReferences().stream().filter(Reference.SUBTYPE_OF).flatMap(r -> StreamUtil.opt2stream((Optional)r.getTargetNodeId().local(server.getNamespaceTable()))).findFirst().orElse(null);
        }
        return null;
    }
}

