/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.diagnostics;

import com.google.common.collect.Sets;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.eclipse.milo.opcua.sdk.core.Reference;
import org.eclipse.milo.opcua.sdk.core.util.StreamUtil;
import org.eclipse.milo.opcua.sdk.server.OpcUaServer;
import org.eclipse.milo.opcua.sdk.server.diagnostics.ArrayValueAttributeFilter;
import org.eclipse.milo.opcua.sdk.server.nodes.UaNode;
import org.eclipse.milo.opcua.sdk.server.nodes.UaNodeContext;
import org.eclipse.milo.opcua.sdk.server.nodes.UaVariableNode;
import org.eclipse.milo.opcua.sdk.server.nodes.filters.AttributeFilter;
import org.eclipse.milo.opcua.sdk.server.nodes.filters.AttributeFilterContext;
import org.eclipse.milo.opcua.stack.core.AttributeId;
import org.eclipse.milo.opcua.stack.core.Identifiers;
import org.eclipse.milo.opcua.stack.core.serialization.SerializationContext;
import org.eclipse.milo.opcua.stack.core.serialization.UaStructure;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExtensionObject;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;
import org.slf4j.LoggerFactory;

class ComplexValueAttributeFilter
implements AttributeFilter {
    private final AtomicBoolean initialized = new AtomicBoolean(false);
    private final Map<String, Method> getters = new HashMap<String, Method>();
    private final List<UaVariableNode> members = new ArrayList<UaVariableNode>();

    ComplexValueAttributeFilter() {
    }

    @Override
    public void setAttribute(AttributeFilterContext.SetAttributeContext ctx, AttributeId attributeId, Object value) {
        if (attributeId == AttributeId.Value) {
            if (ctx.getNode() instanceof UaVariableNode) {
                Object o = ((DataValue)value).getValue().getValue();
                if (o instanceof ExtensionObject) {
                    o = ComplexValueAttributeFilter.decodeValue(ctx, (ExtensionObject)o);
                }
                this.synchronizeStructMembers((UaVariableNode)ctx.getNode(), o);
            }
            ctx.setAttribute(attributeId, value);
        } else {
            ctx.setAttribute(attributeId, value);
        }
    }

    private synchronized void synchronizeStructMembers(UaVariableNode complexNode, Object structValue) {
        if (this.initialized.compareAndSet(false, true)) {
            for (Method m : structValue.getClass().getMethods()) {
                String methodName = m.getName();
                if (!methodName.startsWith("get")) continue;
                this.getters.put(methodName.substring(3), m);
            }
            Set componentNames = complexNode.getComponentNodes().stream().map(n -> n.getBrowseName().getName()).collect(Collectors.toSet());
            Sets.SetView fieldNameIntersection = Sets.intersection(this.getters.keySet(), componentNames);
            this.getters.keySet().removeIf(arg_0 -> ComplexValueAttributeFilter.lambda$synchronizeStructMembers$1((Set)fieldNameIntersection, arg_0));
            complexNode.getComponentNodes().stream().distinct().forEach(node -> {
                if (node instanceof UaVariableNode) {
                    UaVariableNode memberNode = (UaVariableNode)node;
                    String memberName = node.getBrowseName().getName();
                    if (this.getters.containsKey(memberName)) {
                        this.members.add(memberNode);
                        NodeId memberDataType = memberNode.getDataType();
                        OpcUaServer server = complexNode.getNodeContext().getServer();
                        if (memberNode.getValueRank() == 1) {
                            memberNode.getFilterChain().addLast((AttributeFilter)new ArrayValueAttributeFilter());
                        } else if (ComplexValueAttributeFilter.subtypeOf(server, memberDataType, Identifiers.Structure)) {
                            memberNode.getFilterChain().addLast((AttributeFilter)new ComplexValueAttributeFilter());
                        }
                    }
                }
            });
        }
        this.members.forEach(memberNode -> {
            String memberName = memberNode.getBrowseName().getName();
            try {
                Method m = this.getters.get(memberName);
                Object o = m.invoke(structValue, new Object[0]);
                if (o instanceof UaStructure) {
                    ExtensionObject xo = ComplexValueAttributeFilter.encodeValue(complexNode.getNodeContext(), (UaStructure)o);
                    memberNode.setValue(new DataValue(new Variant((Object)xo)));
                } else {
                    memberNode.setValue(new DataValue(new Variant(o)));
                }
            }
            catch (Throwable e) {
                LoggerFactory.getLogger(ComplexValueAttributeFilter.class).error("error getting value for field '{}' of {}", new Object[]{memberName, structValue, e});
                memberNode.setValue(new DataValue(new StatusCode(0x80020000L)));
            }
        });
    }

    private static Object decodeValue(AttributeFilterContext ctx, ExtensionObject xo) {
        return xo.decode(ctx.getNode().getNodeContext().getServer().getSerializationContext());
    }

    private static ExtensionObject encodeValue(UaNodeContext ctx, UaStructure value) {
        return ExtensionObject.encode((SerializationContext)ctx.getServer().getSerializationContext(), (UaStructure)value);
    }

    private static boolean subtypeOf(OpcUaServer server, NodeId dataTypeId, NodeId potentialSuperTypeId) {
        UaNode dataTypeNode = server.getAddressSpaceManager().getManagedNode(dataTypeId).orElse(null);
        if (dataTypeNode != null) {
            NodeId superTypeId = ComplexValueAttributeFilter.getSuperTypeId(server, dataTypeId);
            if (superTypeId != null) {
                return superTypeId.equals((Object)potentialSuperTypeId) || ComplexValueAttributeFilter.subtypeOf(server, superTypeId, potentialSuperTypeId);
            }
            return false;
        }
        return false;
    }

    @Nullable
    private static NodeId getSuperTypeId(OpcUaServer server, NodeId dataTypeId) {
        UaNode dataTypeNode = server.getAddressSpaceManager().getManagedNode(dataTypeId).orElse(null);
        if (dataTypeNode != null) {
            return dataTypeNode.getReferences().stream().filter(Reference.SUBTYPE_OF).flatMap(r -> StreamUtil.opt2stream((Optional)r.getTargetNodeId().local(server.getNamespaceTable()))).findFirst().orElse(null);
        }
        return null;
    }

    private static /* synthetic */ boolean lambda$synchronizeStructMembers$1(Set fieldNameIntersection, String k) {
        return !fieldNameIntersection.contains(k);
    }
}

